/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.source;

import org.apache.avalon.framework.component.Component;

import java.io.IOException;
import java.net.MalformedURLException;

/**
 * @author <a href="mailto:cziegeler@apache.org">Carsten Ziegeler</a>
 * @version $Id: SourceFactory.java,v 1.4 2001/12/11 09:53:36 jefft Exp $
 */
public interface SourceFactory
extends Component {

    String ROLE = "org.apache.avalon.excalibur.source.SourceFactory";

    /**
     * Get a <code>Source</code> object.
     * @param parameters This is optional.
     */
    Source getSource(String location, SourceParameters parameters)
    throws MalformedURLException, IOException;

}
