/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.extension;

/**
 * Exception indicating an extension was not found in Package Repository.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 * @version $Revision: 1.3 $ $Date: 2001/12/11 09:53:34 $
 * @see Extension
 */
public class UnsatisfiedExtensionException
    extends Exception
{
    private Extension m_extension;

    /**
     * Construct the <code>UnsatisfiedPackageException</code>
     * for specified <code>Extension</code>.
     *
     * @param extension the extension that caused exception
     */
    public UnsatisfiedExtensionException( final Extension extension )
    {
        m_extension = extension;
    }

    /**
     * Return the unsatisfied <code>Extension</code> that 
     * caused this exception tho be thrown.
     *
     * @return the unsatisfied Extension
     */
    public Extension getUnsatisfiedExtension()
    {
        return m_extension;
    }
}
