/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;

public class InterTypeFieldDeclaration
extends InterTypeDeclaration {
    public Expression initialization;

    public InterTypeFieldDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public void resolveOnType(ClassScope classScope) {
        super.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (Modifier.isStatic(this.declaredModifiers) && this.onTypeBinding.isInterface()) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "static inter-type field on interface not supported");
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolve(ClassScope upperScope) {
        MethodBinding writeMethod;
        if (this.munger == null) {
            this.ignoreFurtherInvestigation = true;
        }
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(upperScope);
        ResolvedMember sig = this.munger.getSignature();
        TypeX aspectType = EclipseFactory.fromBinding(upperScope.referenceContext.binding);
        if (sig.getReturnType() == ResolvedTypeX.VOID || sig.getReturnType().isArray() && sig.getReturnType().getComponentType() == ResolvedTypeX.VOID) {
            upperScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "field type can not be void");
        }
        if (this.initialization != null && this.initialization instanceof ArrayInitializer) {
            ArrayAllocationExpression aae = new ArrayAllocationExpression();
            aae.initializer = (ArrayInitializer)this.initialization;
            ArrayBinding arrayType = (ArrayBinding)world.makeTypeBinding(sig.getReturnType());
            aae.type = AstUtil.makeTypeReference(arrayType.leafComponentType());
            aae.sourceStart = this.initialization.sourceStart;
            aae.sourceEnd = this.initialization.sourceEnd;
            aae.dimensions = new Expression[arrayType.dimensions];
            this.initialization = aae;
        }
        if (this.initialization == null) {
            this.statements = new Statement[]{new ReturnStatement(null, 0, 0)};
        } else if (!this.onTypeBinding.isInterface()) {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType));
            this.statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{AstUtil.makeLocalVariableReference(this.arguments[0].binding), this.initialization})};
        } else {
            writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, sig.getDeclaringType().resolve(world.getWorld()), aspectType));
            this.statements = Modifier.isStatic(this.declaredModifiers) ? new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeNameReference(writeMethod.declaringClass), new Expression[]{this.initialization})} : new Statement[]{new KnownMessageSend(writeMethod, AstUtil.makeLocalVariableReference(this.arguments[0].binding), new Expression[]{this.initialization})};
        }
        super.resolve(upperScope);
    }

    public void setInitialization(Expression initialization) {
        this.initialization = initialization;
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        this.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        this.binding = classScope.referenceContext.binding.resolveTypesFor(this.binding);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        if (this.isTargetAnnotation(classScope, "field")) {
            return null;
        }
        if (this.isTargetEnum(classScope, "field")) {
            return null;
        }
        if (!Modifier.isStatic(this.declaredModifiers)) {
            this.binding.parameters = new TypeBinding[]{this.onTypeBinding};
            this.arguments = new Argument[]{AstUtil.makeFinalArgument("ajc$this_".toCharArray(), this.onTypeBinding)};
        }
        ResolvedMember sig = new ResolvedMember(Member.FIELD, EclipseFactory.fromBinding(this.onTypeBinding), this.declaredModifiers, EclipseFactory.fromBinding(this.binding.returnType), new String(this.declaredSelector), TypeX.NONE);
        NewFieldTypeMunger myMunger = new NewFieldTypeMunger(sig, null);
        this.setMunger(myMunger);
        ResolvedTypeX aspectType = world.fromEclipse(classScope.referenceContext.binding);
        ResolvedMember me = myMunger.getInitMethod(aspectType);
        this.binding.selector = me.getName().toCharArray();
        this.selector = this.binding.selector;
        this.binding.returnType = BaseTypes.VoidBinding;
        return new EclipseTypeMunger(world, myMunger, aspectType, this);
    }

    private AjAttribute makeAttribute() {
        return new AjAttribute.TypeMunger(this.munger);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute()));
        super.generateCode(classScope, classFile);
        this.generateDispatchMethods(classScope, classFile);
    }

    private void generateDispatchMethods(ClassScope classScope, ClassFile classFile) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        ResolvedMember sig = this.munger.getSignature();
        TypeX aspectType = EclipseFactory.fromBinding(classScope.referenceContext.binding);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, true);
        this.generateDispatchMethod(world, sig, aspectType, classScope, classFile, false);
    }

    private void generateDispatchMethod(EclipseFactory world, ResolvedMember sig, TypeX aspectType, ClassScope classScope, ClassFile classFile, boolean isGetter) {
        MethodBinding binding = isGetter ? world.makeMethodBinding(AjcMemberMaker.interFieldGetDispatcher(sig, aspectType)) : world.makeMethodBinding(AjcMemberMaker.interFieldSetDispatcher(sig, aspectType));
        classFile.generateMethodInfoHeader(binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(binding, false, this.makeEffectiveSignatureAttribute(sig, isGetter ? Shadow.FieldGet : Shadow.FieldSet, false));
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        FieldBinding classField = world.makeFieldBinding(AjcMemberMaker.interFieldClassField(sig, aspectType));
        codeStream.initializeMaxLocals(binding);
        if (isGetter) {
            if (this.onTypeBinding.isInterface()) {
                TypeX declaringTX = sig.getDeclaringType();
                ResolvedTypeX declaringRTX = world.getWorld().resolve(declaringTX, this.munger.getSourceLocation());
                MethodBinding readMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceGetter(sig, declaringRTX, aspectType));
                this.generateInterfaceReadBody(binding, readMethod, codeStream);
            } else {
                this.generateClassReadBody(binding, classField, codeStream);
            }
        } else if (this.onTypeBinding.isInterface()) {
            MethodBinding writeMethod = world.makeMethodBinding(AjcMemberMaker.interFieldInterfaceSetter(sig, world.getWorld().resolve(sig.getDeclaringType(), this.munger.getSourceLocation()), aspectType));
            this.generateInterfaceWriteBody(binding, writeMethod, codeStream);
        } else {
            this.generateClassWriteBody(binding, classField, codeStream);
        }
        AstUtil.generateReturn(binding.returnType, codeStream);
        classFile.completeCodeAttribute(codeAttributeOffset);
        classFile.completeMethodInfo(methodAttributeOffset, ++attributeNumber);
    }

    private void generateInterfaceReadBody(MethodBinding binding, MethodBinding readMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.invokeinterface(readMethod);
    }

    private void generateInterfaceWriteBody(MethodBinding binding, MethodBinding writeMethod, CodeStream codeStream) {
        codeStream.aload_0();
        codeStream.load(writeMethod.parameters[0], 1);
        codeStream.invokeinterface(writeMethod);
    }

    private void generateClassReadBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isStatic()) {
            codeStream.getstatic(field);
        } else {
            codeStream.aload_0();
            codeStream.getfield(field);
        }
    }

    private void generateClassWriteBody(MethodBinding binding, FieldBinding field, CodeStream codeStream) {
        if (field.isStatic()) {
            codeStream.load(field.type, 0);
            codeStream.putstatic(field);
        } else {
            codeStream.aload_0();
            codeStream.load(field.type, 1);
            codeStream.putfield(field);
        }
    }

    protected Shadow.Kind getShadowKindForBody() {
        return null;
    }
}

