package POSIX;

our(@ISA, %EXPORT_TAGS, @EXPORT_OK, $AUTOLOAD) = ();

use AutoLoader;

use XSLoader ();

our $VERSION = "1.03" ;

# Grandfather old foo_h form to new :foo_h form
my $loaded;

sub import {
    load_imports() unless $loaded++;
    my $this = shift;
    my @list = map { m/^\w+_h$/ ? ":$_" : $_ } @_;
    local $Exporter::ExportLevel = 1;
    Exporter::import($this,@list);
}

sub croak { require Carp;  goto &Carp::croak }

XSLoader::load 'POSIX', $VERSION;

my $EINVAL = constant("EINVAL", 0);
my $EAGAIN = constant("EAGAIN", 0);

sub AUTOLOAD {
    if ($AUTOLOAD =~ /::(_?[a-z])/) {
	# require AutoLoader;
	$AutoLoader::AUTOLOAD = $AUTOLOAD;
	goto &AutoLoader::AUTOLOAD
    }
    local $! = 0;
    my $constname = $AUTOLOAD;
    $constname =~ s/.*:://;
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! == 0) {
	*$AUTOLOAD = sub { $val };
    }
    elsif ($! == $EAGAIN) {	# Not really a constant, so always call.
	*$AUTOLOAD = sub { constant($constname, $_[0]) };
    }
    elsif ($! == $EINVAL) {
	croak "$constname is not a valid POSIX macro";
    }
    else {
	croak "Your vendor has not defined POSIX macro $constname, used";
    }

    goto &$AUTOLOAD;
}

sub usage { 
    my ($mess) = @_;
    croak "Usage: POSIX::$mess";
}

sub redef { 
    my ($mess) = @_;
    croak "Use method $mess instead";
}

sub unimpl { 
    my ($mess) = @_;
    $mess =~ s/xxx//;
    croak "Unimplemented: POSIX::$mess";
}

############################
package POSIX::SigAction;

sub new {
    bless {HANDLER => $_[1], MASK => $_[2], FLAGS => $_[3] || 0}, $_[0];
}

############################
package POSIX; # return to package POSIX so AutoSplit is happy
1;
