/* $Id: virtual.c,v 1.33 1998/08/13 17:06:10 gjb Exp $ 
 * virtual.c
 *
 * (C) 1998 Maciej Stachowiak and Greg J. Badros
 *
 * Code is derived from Robert Nation's fvwm2 (twm, ctwm derivative)
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "scwm.h"
#include "window.h"
#include "icons.h"
#include "screen.h"
#include "Grab.h"
#include "resize.h"
#include "borders.h"
#include "focus.h"
#include "module-interface.h"
#include "virtual.h"
#include "xmisc.h"
#include "syscompat.h"


Bool
FNeedsPaging(int HorWarpSize, int VertWarpSize, int xl, int yt)
{
  int x, y;

  if ((Scr.ScrollResistance < 0) ||
      ((HorWarpSize == 0) && (VertWarpSize == 0)))
    return False;

  /* need to move the viewport */
  if ((Scr.VxMax == 0 ||
       (xl >= SCROLL_REGION && xl < Scr.DisplayWidth - SCROLL_REGION)) &&
      (Scr.VyMax == 0 ||
       (yt >= SCROLL_REGION && yt < Scr.DisplayHeight - SCROLL_REGION)))
    return False;

  WXGetPointerWindowOffsets(Scr.Root, &x, &y);
  
  /* check actual pointer location since PanFrames can get buried under
     a window being moved or resized - mab */
  if ((x >= SCROLL_REGION) && (x < Scr.DisplayWidth - SCROLL_REGION) &&
      (y >= SCROLL_REGION) && (y < Scr.DisplayHeight - SCROLL_REGION))
    return False;

  return True;
}



/***************************************************************************
 * 
 * Check to see if the pointer is on the edge of the screen, and scroll/page
 * if needed 
 ***************************************************************************/
void 
HandlePaging(int HorWarpSize, int VertWarpSize, int *xl, int *yt,
	     int *delta_x, int *delta_y, Bool Grab)
{
  int x, y, total;

  *delta_x = 0;
  *delta_y = 0;

  total = 0;

  if (!FNeedsPaging(HorWarpSize, VertWarpSize, *xl, *yt))
    return;

  while (total < Scr.ScrollResistance) {
    usleep(10);
    total += 10;

    WXGetPointerWindowOffsets(Scr.Root, &x, &y);

    if (XCheckWindowEvent(dpy, Scr.PanFrameTop.win,
			  LeaveWindowMask, &Event)) {
      StashEventTime(&Event);
      return;
    }
    if (XCheckWindowEvent(dpy, Scr.PanFrameBottom.win,
			  LeaveWindowMask, &Event)) {
      StashEventTime(&Event);
      return;
    }
    if (XCheckWindowEvent(dpy, Scr.PanFrameLeft.win,
			  LeaveWindowMask, &Event)) {
      StashEventTime(&Event);
      return;
    }
    if (XCheckWindowEvent(dpy, Scr.PanFrameRight.win,
			  LeaveWindowMask, &Event)) {
      StashEventTime(&Event);
      return;
    }
    /* check actual pointer location since PanFrames can get buried under
       a window being moved or resized - mab */
    if ((x >= SCROLL_REGION) && (x < Scr.DisplayWidth - SCROLL_REGION) &&
	(y >= SCROLL_REGION) && (y < Scr.DisplayHeight - SCROLL_REGION))
      return;
  }

  WXGetPointerWindowOffsets(Scr.Root, &x, &y);

  RemoveRubberbandOutline(Scr.Root);

  /* Move the viewport */
  /* and/or move the cursor back to the approximate correct location */
  /* that is, the same place on the virtual desktop that it */
  /* started at */
  if (x < SCROLL_REGION)
    *delta_x = -HorWarpSize;
  else if (x >= Scr.DisplayWidth - SCROLL_REGION)
    *delta_x = HorWarpSize;
  else
    *delta_x = 0;
  if (Scr.VxMax == 0)
    *delta_x = 0;
  if (y < SCROLL_REGION)
    *delta_y = -VertWarpSize;
  else if (y >= Scr.DisplayHeight - SCROLL_REGION)
    *delta_y = VertWarpSize;
  else
    *delta_y = 0;
  if (Scr.VyMax == 0)
    *delta_y = 0;

  /* Ouch! lots of bounds checking */
  if (Scr.Vx + *delta_x < 0) {
    if (!Scr.fEdgeWrapX) {
      *delta_x = -Scr.Vx;
      *xl = x - *delta_x;
    } else {
      *delta_x += Scr.VxMax + Scr.DisplayWidth;
      *xl = x + *delta_x % Scr.DisplayWidth + HorWarpSize;
    }
  } else if (Scr.Vx + *delta_x > Scr.VxMax) {
    if (!Scr.fEdgeWrapX) {
      *delta_x = Scr.VxMax - Scr.Vx;
      *xl = x - *delta_x;
    } else {
      *delta_x -= Scr.VxMax + Scr.DisplayWidth;
      *xl = x + *delta_x % Scr.DisplayWidth - HorWarpSize;
    }
  } else {
    *xl = x - *delta_x;
  }

  if (Scr.Vy + *delta_y < 0) {
    if (!Scr.fEdgeWrapY) {
      *delta_y = -Scr.Vy;
      *yt = y - *delta_y;
    } else {
      *delta_y += Scr.VyMax + Scr.DisplayHeight;
      *yt = y + *delta_y % Scr.DisplayHeight + VertWarpSize;
    }
  } else if (Scr.Vy + *delta_y > Scr.VyMax) {
    if (!Scr.fEdgeWrapY) {
      *delta_y = Scr.VyMax - Scr.Vy;
      *yt = y - *delta_y;
    } else {
      *delta_y -= Scr.VyMax + Scr.DisplayHeight;
      *yt = y + *delta_y % Scr.DisplayHeight - VertWarpSize;
    }
  } else {
    *yt = y - *delta_y;
  }

  if (*xl <= SCROLL_REGION)
    *xl = SCROLL_REGION + 1;
  if (*yt <= SCROLL_REGION)
    *yt = SCROLL_REGION + 1;
  if (*xl >= Scr.DisplayWidth - SCROLL_REGION)
    *xl = Scr.DisplayWidth - SCROLL_REGION - 1;
  if (*yt >= Scr.DisplayHeight - SCROLL_REGION)
    *yt = Scr.DisplayHeight - SCROLL_REGION - 1;

  if ((*delta_x != 0) || (*delta_y != 0)) {
    if (Grab)
      XGrabServer_withSemaphore(dpy);
    XWarpPointer(dpy, None, Scr.Root, 0, 0, 0, 0, *xl, *yt);
    MoveViewport(Scr.Vx + *delta_x, Scr.Vy + *delta_y, False);
    WXGetPointerWindowOffsets(Scr.Root, xl, yt);
    if (Grab)
      XUngrabServer_withSemaphore(dpy);
  }
}



/* the root window is surrounded by four window slices, which are InputOnly.
 * So you can see 'through' them, but they eat the input. An EnterEvent in
 * one of these windows causes a Paging. The windows have the according cursor
 * pointing in the pan direction or are hidden if there is no more panning
 * in that direction. This is mostly intended to get a panning even atop
 * of Motif applictions, which does not work yet. It seems Motif windows
 * eat all mouse events.
 *
 * Hermann Dunkel, HEDU, dunkel@cul-ipn.uni-kiel.de 1/94
 */

/*
 * checkPanFrames hides PanFrames if they are on the very border of the
 * VIRTUAL screen and EdgeWrap for that direction is off. 
 */
void 
checkPanFrames()
{
  Bool fWrapX = Scr.fEdgeWrapX;
  Bool fWrapY = Scr.fEdgeWrapY;

  if (!(Scr.fWindowsCaptured))
    return;

  /* Remove Pan frames if paging by edge-scroll is permanently or
   * temporarily disabled */
  if (Scr.EdgeScrollY == 0) {
    XUnmapWindow(dpy, Scr.PanFrameTop.win);
    Scr.PanFrameTop.isMapped = False;
    XUnmapWindow(dpy, Scr.PanFrameBottom.win);
    Scr.PanFrameBottom.isMapped = False;
  }
  if (Scr.EdgeScrollX == 0) {
    XUnmapWindow(dpy, Scr.PanFrameLeft.win);
    Scr.PanFrameLeft.isMapped = False;
    XUnmapWindow(dpy, Scr.PanFrameRight.win);
    Scr.PanFrameRight.isMapped = False;
  }
  if ((Scr.EdgeScrollX == 0) && (Scr.EdgeScrollY == 0))
    return;

  /* LEFT, hide only if EdgeWrap is off */
  if (Scr.Vx == 0 && Scr.PanFrameLeft.isMapped && !fWrapX) {
    XUnmapWindow(dpy, Scr.PanFrameLeft.win);
    Scr.PanFrameLeft.isMapped = False;
  } else if (Scr.Vx > 0 && Scr.PanFrameLeft.isMapped == False) {
    XMapRaised(dpy, Scr.PanFrameLeft.win);
    Scr.PanFrameLeft.isMapped = True;
  }
  /* RIGHT, hide only if EdgeWrap is off */
  if (Scr.Vx == Scr.VxMax && Scr.PanFrameRight.isMapped && !fWrapX) {
    XUnmapWindow(dpy, Scr.PanFrameRight.win);
    Scr.PanFrameRight.isMapped = False;
  } else if (Scr.Vx < Scr.VxMax && Scr.PanFrameRight.isMapped == False) {
    XMapRaised(dpy, Scr.PanFrameRight.win);
    Scr.PanFrameRight.isMapped = True;
  }
  /* TOP, hide only if EdgeWrap is off */
  if (Scr.Vy == 0 && Scr.PanFrameTop.isMapped && !fWrapY) {
    XUnmapWindow(dpy, Scr.PanFrameTop.win);
    Scr.PanFrameTop.isMapped = False;
  } else if (Scr.Vy > 0 && Scr.PanFrameTop.isMapped == False) {
    XMapRaised(dpy, Scr.PanFrameTop.win);
    Scr.PanFrameTop.isMapped = True;
  }
  /* BOTTOM, hide only if EdgeWrap is off */
  if (Scr.Vy == Scr.VyMax && Scr.PanFrameBottom.isMapped && !fWrapY) {
    XUnmapWindow(dpy, Scr.PanFrameBottom.win);
    Scr.PanFrameBottom.isMapped = False;
  } else if (Scr.Vy < Scr.VyMax && Scr.PanFrameBottom.isMapped == False) {
    XMapRaised(dpy, Scr.PanFrameBottom.win);
    Scr.PanFrameBottom.isMapped = True;
  }
}

/****************************************************************************
 *
 * Gotta make sure these things are on top of everything else, or they
 * don't work!
 *
 * For some reason, this seems to be unneeded.
 *
 ***************************************************************************/
void 
raisePanFrames()
{
  if (Scr.PanFrameTop.isMapped)
    XRaiseWindow(dpy, Scr.PanFrameTop.win);
  if (Scr.PanFrameLeft.isMapped)
    XRaiseWindow(dpy, Scr.PanFrameLeft.win);
  if (Scr.PanFrameRight.isMapped)
    XRaiseWindow(dpy, Scr.PanFrameRight.win);
  if (Scr.PanFrameBottom.isMapped)
    XRaiseWindow(dpy, Scr.PanFrameBottom.win);
}

/****************************************************************************
 *
 * Creates the windows for edge-scrolling 
 *
 ****************************************************************************/
void 
initPanFrames()
{
  XSetWindowAttributes attributes;	/* attributes for create */
  unsigned long valuemask;

  attributes.event_mask = (EnterWindowMask | LeaveWindowMask |
			   VisibilityChangeMask);
  valuemask = (CWEventMask | CWCursor);

  attributes.cursor = Scr.ScwmCursors[CURSOR_TOP];
  Scr.PanFrameTop.win =
    XCreateWindow(dpy, Scr.Root,
		  0, 0,
		  Scr.DisplayWidth, PAN_FRAME_THICKNESS,
		  0,		/* no border */
		  CopyFromParent, InputOnly,
		  CopyFromParent,
		  valuemask, &attributes);
  attributes.cursor = Scr.ScwmCursors[CURSOR_LEFT];
  Scr.PanFrameLeft.win =
    XCreateWindow(dpy, Scr.Root,
		  0, PAN_FRAME_THICKNESS,
		  PAN_FRAME_THICKNESS,
		  Scr.DisplayHeight - 2 * PAN_FRAME_THICKNESS,
		  0,		/* no border */
		  CopyFromParent, InputOnly, CopyFromParent,
		  valuemask, &attributes);
  attributes.cursor = Scr.ScwmCursors[CURSOR_RIGHT];
  Scr.PanFrameRight.win =
    XCreateWindow(dpy, Scr.Root,
	      Scr.DisplayWidth - PAN_FRAME_THICKNESS, PAN_FRAME_THICKNESS,
		  PAN_FRAME_THICKNESS,
		  Scr.DisplayHeight - 2 * PAN_FRAME_THICKNESS,
		  0,		/* no border */
		  CopyFromParent, InputOnly, CopyFromParent,
		  valuemask, &attributes);
  attributes.cursor = Scr.ScwmCursors[CURSOR_BOTTOM];
  Scr.PanFrameBottom.win =
    XCreateWindow(dpy, Scr.Root,
		  0, Scr.DisplayHeight - PAN_FRAME_THICKNESS,
		  Scr.DisplayWidth, PAN_FRAME_THICKNESS,
		  0,		/* no border */
		  CopyFromParent, InputOnly, CopyFromParent,
		  valuemask, &attributes);
  Scr.PanFrameTop.isMapped = Scr.PanFrameLeft.isMapped =
    Scr.PanFrameRight.isMapped = Scr.PanFrameBottom.isMapped = False;
}


/*
 *  Moves the viewport within the virtual desktop
 */
void 
MoveViewport_internal(int newx, int newy, Bool grab)
{
  ScwmWindow *psw;
  int deltax, deltay;

  /* no change? then do nothing */
  if (newx == Scr.Vx && newy == Scr.Vy)
    return;

  if (grab)
    XGrabServer_withSemaphore(dpy);

  if (newx > Scr.VxMax)
    newx = Scr.VxMax;
  if (newy > Scr.VyMax)
    newy = Scr.VyMax;
  if (newx < 0)
    newx = 0;
  if (newy < 0)
    newy = 0;

  deltay = Scr.Vy - newy;
  deltax = Scr.Vx - newx;

  Scr.Vx = newx;
  Scr.Vy = newy;
  Broadcast(M_NEW_PAGE, 5, Scr.Vx, Scr.Vy, Scr.CurrentDesk, Scr.VxMax, Scr.VyMax, 0, 0);

  if ((deltax != 0) || (deltay != 0)) {
    for (psw = Scr.ScwmRoot.next; psw != NULL; psw = psw->next) {
      /* If the window is iconified, and sticky Icons is set,
       * then the window should essentially be sticky */
      if (!(psw->fIconified && psw->fStickyIcon) && !psw->fSticky) {
	if (!psw->fStickyIcon) {
	  psw->icon_x_loc += deltax;
	  psw->icon_xl_loc += deltax;
	  psw->icon_y_loc += deltay;
	  if (psw->icon_pixmap_w != None)
	    XMoveWindow(dpy, psw->icon_pixmap_w, psw->icon_x_loc,
			psw->icon_y_loc);
	  if (psw->icon_w != None)
	    XMoveWindow(dpy, psw->icon_w, psw->icon_x_loc,
			psw->icon_y_loc + psw->icon_p_height);
	  if (!psw->fIconUnmapped) {
	    Broadcast(M_ICON_LOCATION, 7, psw->w, psw->frame,
		      (unsigned long) psw,
		      psw->icon_x_loc, psw->icon_y_loc,
		      psw->icon_w_width,
		      psw->icon_w_height + psw->icon_p_width);
	  }
	}
        /* FIXGJBNOW: this is broken with cassowary since
           the order in which the windows move around
           can ruin the position of other windows.  Instead
           I need to always position windows relative to the virtual
           desktop when I do the X11 calls, or when I store in the
           constraint solver.  the x coordinate of a window could be
           the Scr.Vx + the psw->frame_x, perhaps... or I could
           have another set of primitives, window-clv-vx, for virtual
           x coordinate, and have that return the expression.  That
           means also making Scr.V[xy] constraint variables */
	MoveTo(psw, FRAME_X(psw) + deltax, FRAME_Y(psw) + deltay);
      }
    }
    for (psw = Scr.ScwmRoot.next; psw != NULL; psw = psw->next) {
      /* If its an icon, and its sticking, autoplace it so
       * that it doesn't wind up on top a a stationary
       * icon */
      if ((psw->fSticky || psw->fStickyIcon) &&
	  psw->fIconified && !psw->fIconMoved && 
	  !psw->fIconUnmapped) {
	AutoPlace(psw);
      }
    }

  }
  checkPanFrames();

  /* do this with PanFrames too ??? HEDU */
  while (XCheckTypedEvent(dpy, MotionNotify, &Event))
    StashEventTime(&Event);
  if (grab)
    XUngrabServer_withSemaphore(dpy);
}


void 
MoveViewport(int newx, int newy, Bool grab)
{
  ChangeVirtualPosition(newx,newy,grab);
}


void 
changeDesks(int val1, int val2)
{
  int oldDesk;
  ScwmWindow *FocusWin = 0, *psw;
  static ScwmWindow *StickyWin = 0;

  oldDesk = Scr.CurrentDesk;

  if (val1 != 0) {
    Scr.CurrentDesk = Scr.CurrentDesk + val1;
  } else {
    Scr.CurrentDesk = val2;
    if (Scr.CurrentDesk == oldDesk)
      return;
  }

  Broadcast(M_NEW_DESK, 1, Scr.CurrentDesk, 0, 0, 0, 0, 0, 0);
  /* Scan the window list, mapping windows on the new Desk,
   * unmapping windows on the old Desk */
  XGrabServer_withSemaphore(dpy);
  for (psw = Scr.ScwmRoot.next; psw != NULL; psw = psw->next) {
    /* Only change mapping for non-sticky windows */
    if (!(psw->fIconified && psw->fStickyIcon) &&
	!psw->fSticky && !psw->fIconUnmapped) {
      if (psw->Desk == oldDesk) {
	if (Scr.Focus == psw)
	  psw->FocusDesk = oldDesk;
	else
	  psw->FocusDesk = -1;
	UnmapScwmWindow(psw);
      } else if (psw->Desk == Scr.CurrentDesk) {
	MapIt(psw);
	if (psw->FocusDesk == Scr.CurrentDesk) {
	  FocusWin = psw;
	}
      }
    } else {
      /* Window is sticky */
      psw->Desk = Scr.CurrentDesk;
      if (Scr.Focus == psw) {
	psw->FocusDesk = oldDesk;
	StickyWin = psw;
      }
    }
  }
  XUngrabServer_withSemaphore(dpy);
  for (psw = Scr.ScwmRoot.next; psw != NULL; psw = psw->next) {
    /* If its an icon, and its sticking, autoplace it so
     * that it doesn'psw wind up on top a a stationary
     * icon */
    if ((psw->fSticky || psw->fStickyIcon) &&
	psw->fIconified && !psw->fIconMoved && 
  	!psw->fIconUnmapped) {
      AutoPlace(psw);
    }
  }

  if (FocusWin && FocusWin->fClickToFocus) {
    /* FIXGJB: this should be a runtime option */
#ifndef NO_REMEMBER_FOCUS
    SetFocus(FocusWin->w, FocusWin, 0);
  /* OK, someone beat me up, but I don't like this. If you are a predominantly
   * focus-follows-mouse person, but put in one sticky click-to-focus window
   * (typically because you don't really want to give focus to this window),
   * then the following lines are screwed up. */
  /* FIXGJB: what's going on here? --03/25/98 gjb */
/*  else if (StickyWin && StickyWin->fSticky)
   SetFocus(StickyWin->w, StickyWin,1); */
  } else {
#endif
    SetFocus(Scr.NoFocusWin, NULL, 1);
  }
}

/* Local Variables: */
/* tab-width: 8 */
/* c-basic-offset: 2 */
/* End: */
