/* $Id: image.h,v 1.12 1998/07/27 01:07:58 gjb Exp $ */
/*
 * Copyright (C) 1997, 1998 Maciej Stachowiak and Greg J. Badros
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.GPL.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 *
 */

#ifndef IMAGE_H
#define IMAGE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <guile/gh.h>
#include <unistd.h>

#undef EXTERN
#undef EXTERN_SET
#ifdef IMAGE_IMPLEMENTATION
#define EXTERN
#define EXTERN_SET(x,y) x = y
#else
#define EXTERN extern
#define EXTERN_SET(x,y) extern x
#endif


/* MSFIX: FIXGJB: It'd be really nice to get full pathname of
   the picture into the image object for debugging of scwmrc-s;
   then this could go back in, too, though I imagine it's
   rarely used --gjb 11/28/97  */
typedef struct
{
  SCM full_name;
  Pixmap image;
  Pixmap mask;
  int foreign;
  unsigned int depth;
  unsigned int width;
  unsigned int height;
} scwm_image;


#define IMAGE_P(X) (SCM_NIMP(X) && SCM_CAR(X) == (SCM)scm_tc16_scwm_image)
#define IMAGE(X)  ((scwm_image *)SCM_CDR(X))
#define SAFE_IMAGE(X)  (IMAGE_P((X))? IMAGE((X)) : NULL)

EXTERN long scm_tc16_scwm_image;

SCM make_image_from_pixmap(char *szDescription,
			   Pixmap image, Pixmap mask, 
			   int width, int height, int depth);
SCM make_image(SCM name);

void init_image_colormap();

#endif /* IMAGE_H */

/* Local Variables: */
/* tab-width: 8 */
/* c-basic-offset: 2 */
/* End: */
