package MButtonStyle;
use ButtonStyle;

sub new {
    my $class = shift;
    my $self = {};
    bless $self, $class;
    $self->init();
    return $self
}

sub init {
    my $self=shift;   
    $self->{ButtonStyles} = [new ButtonStyle];
    $self->{ButtonStyles}->[0]->set_number(0);
}

sub number_of_styles {
    my $self = shift;
    return scalar @{$self->{ButtonStyles}};
}

sub insert_style {
    my $self=shift;   
    my $i = shift;
    $i = @{$self->{ButtonStyles}} unless defined $i;
    splice @{$self->{ButtonStyles}},$i,0, new ButtonStyle;
    $self->set_numbers();
    return $self->{ButtonStyles}->[$i];
}

sub delete_style {
    my $self=shift;   
    my $i = shift;
    $self->set_numbers();
    splice @{$self->{ButtonStyles}},$i,1;
}

sub set_numbers {
    my $self=shift;
    my $i;
    for($i=0;$i<@{$self->{ButtonStyles}};$i++) {
	$self->{ButtonStyles}->[$i]->set_number($i);
    }
}


sub style {
    my $self=shift;
    return $self->{ButtonStyles}->[shift];
}

sub get_styles {
    my $self=shift;
    return  @{$self->{ButtonStyles}};
}

sub get_command {
    my $self=shift;
    my @coms = ('ButtonStyle Reset');
    foreach (@{$self->{ButtonStyles}}) {
	push @coms, $_->get_command;
    }
    return \@coms;
}

sub reset  {
}

1;





