/* debug.h for Eterm.
 * 21 Feb 1998, vendu.
 */

#ifndef _DEBUG_H
# define _DEBUG_H

#ifdef __FILE__
#ifdef __LINE__
#define __DEBUG(s)		"%s, line %d: " s, __FILE__, __LINE__
#endif
#endif

#ifndef __DEBUG
#define __DEBUG(s)		s
#endif

#define __DEBUG_1(a)		fprintf(stderr, __DEBUG(a))
#define __DEBUG_2(a,b)		fprintf(stderr, __DEBUG(a), b)
#define __DEBUG_3(a,b,c)	fprintf(stderr, __DEBUG(a), b, c)
#define __DEBUG_4(a,b,c,d)	fprintf(stderr, __DEBUG(a), b, c, d)
#define __DEBUG_5(a,b,c,d,e)	fprintf(stderr, __DEBUG(a), b, c, d, e)

#define NOP(any)		((void)0)

/* Macros for printing debugging messages */
# ifdef DEBUG_OPTIONS
#  define D_OPTIONS		__DEBUG_1
#  define D_OPTIONS2		__DEBUG_2
#  define D_OPTIONS3		__DEBUG_3
#  define D_OPTIONS4		__DEBUG_4
# else
#  define D_OPTIONS(a) ((void)0)
#  define D_OPTIONS2(a,b) ((void)0)
#  define D_OPTIONS3(a,b,c) 	((void)0)
#  define D_OPTIONS4(a,b,c,d) ((void)0)
# endif

# ifdef DEBUG_TTY
#  define D_TTY			__DEBUG_1
#  define D_TTY2		__DEBUG_2
#  define D_TTY3		__DEBUG_3
#  define D_TTY4		__DEBUG_4
# else
#  define D_TTY(a) ((void)0)
#  define D_TTY2(a,b) ((void)0)
#  define D_TTY3(a,b,c) 	((void)0)
#  define D_TTY4(a,b,c,d) 	((void)0)
# endif

# ifdef DEBUG_TTYMODE
#  define D_TTYMODE		__DEBUG_1
#  define D_TTYMODE2		__DEBUG_2
#  define D_TTYMODE3		__DEBUG_3
#  define D_TTYMODE4		__DEBUG_4
# else
#  define D_TTYMODE(a) 		((void)0)
#  define D_TTYMODE2(a,b) 	((void)0)
#  define D_TTYMODE3(a,b,c) 	((void)0)
#  define D_TTYMODE4(a,b,c,d) 	((void)0)
# endif

# ifdef DEBUG_CMD
#  define D_CMD			__DEBUG_1
#  define D_CMD2		__DEBUG_2
#  define D_CMD3		__DEBUG_3
#  define D_CMD4		__DEBUG_4
# else
#  define D_CMD(a) 		((void)0)
#  define D_CMD2(a,b) ((void)0)
#  define D_CMD3(a,b,c) ((void)0)
#  define D_CMD4(a,b,c,d) 	((void)0)
# endif

# ifdef DEBUG_IMLIB
#  define D_IMLIB		__DEBUG_1
#  define D_IMLIB2		__DEBUG_2
#  define D_IMLIB3		__DEBUG_3
#  define D_IMLIB4		__DEBUG_4
# else
#  define D_IMLIB(a) ((void)0)
#  define D_IMLIB2(a,b) ((void)0)
#  define D_IMLIB3(a,b,c) ((void)0)
#  define D_IMLIB4(a,b,c,d) ((void)0)
# endif

# ifdef DEBUG_PIXMAP
#  define D_PIXMAP		__DEBUG_1
#  define D_PIXMAP2		__DEBUG_2
#  define D_PIXMAP3		__DEBUG_3
#  define D_PIXMAP4		__DEBUG_4
#  define D_PIXMAP5		__DEBUG_5
# else
#  define D_PIXMAP(a) 		((void)0)
#  define D_PIXMAP2(a,b) ((void)0)
#  define D_PIXMAP3(a,b,c) 	((void)0)
#  define D_PIXMAP4(a,b,c,d) 	((void)0)
#  define D_PIXMAP5(a,b,c,d,e) 	((void)0)
# endif

# ifdef DEBUG_X11
#  define D_X11			__DEBUG_1
#  define D_X112		__DEBUG_2
#  define D_X113		__DEBUG_3
#  define D_X114		__DEBUG_4
# else
#  define D_X11(a) ((void)0)
#  define D_X112(a,b)	 	((void)0)
#  define D_X113(a,b,c) 	((void)0)
#  define D_X114(a,b,c,d) 	((void)0)
# endif

# ifdef DEBUG_EVENTS
#  define D_EVENTS		__DEBUG_1
#  define D_EVENTS2		__DEBUG_2
#  define D_EVENTS3		__DEBUG_3
#  define D_EVENTS4		__DEBUG_4
# else
#  define D_EVENTS(a) 		((void)0)
#  define D_EVENTS2(a,b) ((void)0)
#  define D_EVENTS3(a,b,c) 	((void)0)
#  define D_EVENTS4(a,b,c,d) 	((void)0)
# endif

# ifdef DEBUG_SCROLLBAR
#  define D_SCROLLBAR		__DEBUG_1
#  define D_SCROLLBAR2		__DEBUG_2
#  define D_SCROLLBAR3		__DEBUG_3
#  define D_SCROLLBAR4		__DEBUG_4
# else
#  define D_SCROLLBAR(a) ((void)0)
#  define D_SCROLLBAR2(a,b) ((void)0)
#  define D_SCROLLBAR3(a,b,c) ((void)0)
#  define D_SCROLLBAR4(a,b,c,d)	((void)0)
# endif

# ifdef DEBUG_THREADS
#  define D_THREADS		__DEBUG_1
#  define D_THREADS2		__DEBUG_2
#  define D_THREADS3		__DEBUG_3
#  define D_THREADS4		__DEBUG_4
# else
#  define D_THREADS(a) ((void)0)
#  define D_THREADS2(a,b) ((void)0)
#  define D_THREADS3(a,b,c) 	((void)0)
#  define D_THREADS4(a,b,c,d) 	((void)0)
# endif

#endif /* _DEBUG_H */
