/*  main.c -- Eterm main() function
 *         -- 22 August 1998, mej
 *
 * This file is original work by Michael Jennings <mej@tcserv.com> and
 * Tuomo Venalainen <vendu@cc.hut.fi>.  This file, and any other file
 * bearing this same message or a similar one, is distributed under
 * the GNU Public License (GPL) as outlined in the COPYING file.
 *
 * Copyright (C) 1997, Michael Jennings and Tuomo Venalainen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

static const char *cvs_ident = "$Id: main.c,v 1.20 1998/10/14 17:58:51 mej Exp $";

/* includes */
#include "main.h"
#ifdef USE_ACTIVE_TAGS
# include "activetags.h"
# include "activeeterm.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <ctype.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>

#include "command.h"
#include "feature.h"
#include "../libmej/debug.h" /* from libmej */
#include "debug.h"
#include "../libmej/mem.h"
#include "../libmej/strings.h"
/* For strsep(). -vendu */
#if defined(linux)
# include <string.h>
#endif
#include "string.h"
#include "graphics.h"
#include "scrollbar.h"
#include "menubar.h"
#include "screen.h"
#include "options.h"
#include "pixmap.h"
#ifdef USE_POSIX_THREADS
# include "threads.h"
#endif

/* Global attributes */
XWindowAttributes attr;
XSetWindowAttributes Attributes;
char *orig_argv0;

#ifdef PIXMAP_SUPPORT
short bg_needs_update;
#endif

/* extern functions referenced */
#ifdef DISPLAY_IS_IP
extern char * network_display (const char * display);
#endif

extern void get_initial_options(int, char **);
extern void menubar_read(const char *filename);

#ifdef USE_POSIX_THREADS
static void **retval;
static int join_value;
static pthread_t main_loop_thr;
static pthread_attr_t main_loop_attr;
# ifdef MUTEX_SYNCH
pthread_mutex_t mutex;
# endif
#endif

#ifdef PIXMAP_SUPPORT
extern void render_pixmap(Window win, imlib_t image, pixmap_t pmap,
			  int which, renderop_t renderop);
# ifdef BACKING_STORE
extern const char *rs_saveUnder;
# endif

extern char *rs_noCursor;

# ifdef USE_IMLIB
extern ImlibData *imlib_id;
# endif
#endif

/* extern variables referenced */
extern int my_ruid, my_rgid, my_euid, my_egid;
#  ifdef IMLIB_TRANS
extern unsigned int rs_shadePct;
extern unsigned long rs_tintMask;
#  else
extern const char *rs_tintTrans;
extern unsigned short tint_color;
#  endif

/* extern variables declared here */
TermWin_t	TermWin;
Display		* Xdisplay;	/* display */

char * rs_color [NRS_COLORS];
Pixel PixColors [NRS_COLORS + NSHADOWCOLORS];

unsigned long Options = (Opt_scrollBar);

const char * display_name = NULL;
char * rs_name = NULL;	/* client instance (resource name) */

#ifndef NO_BOLDFONT
const char * rs_boldFont = NULL;
#endif
const char * rs_font [NFONTS];
#ifdef KANJI
const char * rs_kfont [NFONTS];
#endif

#ifdef PRINTPIPE
const char * rs_print_pipe = NULL;
#endif

char * rs_cutchars = NULL;

/* local variables */
Cursor TermWin_cursor;	/* cursor for vt window */
unsigned int colorfgbg;
menuBar_t menuBar;

XSizeHints szHint = {
    PMinSize | PResizeInc | PBaseSize | PWinGravity,
    0, 0, 80, 24,	/* x, y, width, height */
    1, 1,		/* Min width, height */
    0, 0,		/* Max width, height - unused*/
    1, 1,		/* increments: width, height */
    {1, 1},		/* increments: x, y */
    {0, 0},		/* Aspect ratio - unused */
    0, 0,		/* base size: width, height */
    NorthWestGravity	/* gravity */
};

char *def_colorName[] = {
    "Black", "White",		/* fg/bg */
    "Black",			/* 0: black		(#000000) */
#ifndef NO_BRIGHTCOLOR
    /* low-intensity colors */
    "Red3",			/* 1: red		(#CD0000) */
    "Green3",			/* 2: green		(#00CD00) */
    "Yellow3",			/* 3: yellow		(#CDCD00) */
    "Blue3",			/* 4: blue		(#0000CD) */
    "Magenta3",			/* 5: magenta		(#CD00CD) */
    "Cyan3",			/* 6: cyan		(#00CDCD) */
    "AntiqueWhite",		/* 7: white		(#FAEBD7) */
    /* high-intensity colors */
    "Grey25",			/* 8: bright black	(#404040) */
#endif	/* NO_BRIGHTCOLOR */
    "Red",			/* 1/9: bright red	(#FF0000) */
    "Green",			/* 2/10: bright green	(#00FF00) */
    "Yellow",			/* 3/11: bright yellow	(#FFFF00) */
    "Blue",			/* 4/12: bright blue	(#0000FF) */
    "Magenta",			/* 5/13: bright magenta	(#FF00FF) */
    "Cyan",			/* 6/14: bright cyan	(#00FFFF) */
    "White",			/* 7/15: bright white	(#FFFFFF) */
#ifndef NO_CURSORCOLOR
    NULL, NULL,			/* cursorColor, cursorColor2 */
#endif	/* NO_CURSORCOLOR */
    NULL, NULL			/* pointerColor, borderColor */
#ifndef NO_BOLDUNDERLINE
    ,NULL, NULL			/* colorBD, colorUL */
#endif	/* NO_BOLDUNDERLINE */
    ,"White"			/* menuTextColor */ 
#ifdef KEEP_SCROLLCOLOR
    ,"#B2B2B2"			/* scrollColor: match Netscape color */
# ifdef CHANGE_SCROLLCOLOR_ON_FOCUS
    ,NULL			/* unfocusedscrollColor: somebody chose black? */
# endif
#endif
};

#ifdef KANJI
/* Kanji font names, roman fonts sized to match */
static const char * def_kfontName [] = {
    KFONT0, KFONT1, KFONT2, KFONT3, KFONT4
};
#endif	/* KANJI */
static const char * def_fontName[] = {
    FONT0, FONT1, FONT2, FONT3, FONT4
};

/* extern functions referenced */
#ifdef PIXMAP_SUPPORT
/* the originally loaded pixmap and its scaling */
extern pixmap_t bgPixmap;
extern void set_bgPixmap (const char * /* file */);
# ifdef USE_IMLIB
extern imlib_t imlib_bg;
# endif
# ifdef PIXMAP_SCROLLBAR
extern pixmap_t sbPixmap;
extern pixmap_t upPixmap, up_clkPixmap;
extern pixmap_t dnPixmap, dn_clkPixmap;
extern pixmap_t saPixmap, sa_clkPixmap;
#  ifdef USE_IMLIB
extern imlib_t imlib_sb, imlib_sa, imlib_saclk;
#  endif
# endif
# ifdef PIXMAP_MENUBAR
extern pixmap_t mbPixmap, mb_selPixmap;
#  ifdef USE_IMLIB
extern imlib_t imlib_mb, imlib_ms;
#  endif
# endif

extern int scale_pixmap (const char * geom, pixmap_t * pmap);
#endif	/* PIXMAP_SUPPORT */

/* have we changed the font? Needed to avoid race conditions
 * while window resizing  */
int font_change_count = 0;

static void resize (void);

extern XErrorHandler oldXErrorHandler;
extern XErrorHandler xerror_handler(Display *, XErrorEvent *);
extern void Create_Windows(int, char **);

/* main() */
int
main(int argc, char *argv[]) {
    
    int i;
    char *val;
    /* "WINDOWID=\0" = 10 chars, UINT_MAX = 10 chars */
    static char windowid_string[20], *display_string, *term_string;

    orig_argv0 = argv[0];

#ifdef USE_POSIX_THREADS
# ifdef MUTEX_SYNCH
    pthread_atfork((void *)&prepare, (void *)&parent, (void *)&child);
# endif
#endif
    
    /* Security enhancements -- mej */
    my_ruid = getuid();
    my_euid = geteuid();
    my_rgid = getgid();
    my_egid = getegid();
    privileges(REVERT);
    
    TermWin.wm_parent = None;

#ifdef DEBUG_UTMP
    fprintf(stderr, "Saved real uid/gid = [ %d, %d ]  effective uid/gid = [ %d, %d ]\n",
	    my_ruid, my_rgid, my_euid, my_egid);
    fprintf(stderr, "Now running with real uid/gid = [ %d, %d ]  effective uid/gid = [ %d, %d ]\n",
	    getuid(), getgid(), geteuid(), getegid());
#endif
    rs_name = APL_NAME " " VERSION;
    
#ifndef NDEBUG
    memrec_init();
#endif
    
    Options = (Opt_scrollBar);
    Xdisplay = NULL;
    display_name = NULL;
    rs_term_name = NULL;
#ifdef CUTCHAR_OPTION
    rs_cutchars = NULL;
#endif
#ifndef NO_BOLDFONT
    rs_boldFont = NULL;
#endif
#ifdef PRINTPIPE
    rs_print_pipe = NULL;
#endif
    rs_title = NULL;		/* title name for window */
    rs_iconName = NULL;		/* icon name for window */
    rs_geometry = NULL;		/* window geometry */
    
#if (MENUBAR_MAX)
    rs_menu = NULL;
#endif
#ifdef PIXMAP_SUPPORT
    rs_path = NULL;
#endif
#ifndef NO_BRIGHTCOLOR
    colorfgbg = DEFAULT_RSTYLE;
#endif
    
    /* Open display, get options/resources and create the window */
    if ((display_name = getenv("DISPLAY")) == NULL) display_name = ":0";
    
    /* This MUST be called before any other Xlib functions */
    
#ifdef USE_POSIX_THREADS
    if (XInitThreads()) {
	D_THREADS("XInitThreads() succesful\n");
    } else {
	D_THREADS("XInitThreads() failed, I'm outta here\n");
    }
#endif
    
    TermWin.internalBorder = DEFAULT_BORDER_WIDTH;
#ifdef USE_THEMES
    get_initial_options(argc, argv);
#endif
#ifdef ETERM_COMMAND_MODE
    if (get_eterm_command())
      eterm_command_parser();
#endif
    read_config();
#ifdef PIXMAP_SUPPORT
    if (rs_path) {
      rs_path = REALLOC(rs_path, strlen(rs_path) + strlen(initial_dir) + 2);
      strcat(rs_path, ":");
      strcat(rs_path, initial_dir);
    }
#endif
    get_options(argc, argv);
#ifdef USE_ACTIVE_TAGS
    tag_init();
#endif

#ifdef NEED_LINUX_HACK
    privileges(INVOKE);  /* xdm in new Linux versions requires ruid != root to open the display -- mej */
#endif
    Xdisplay = XOpenDisplay(display_name);
#ifdef NEED_LINUX_HACK
    privileges(REVERT);
#endif

    if (!Xdisplay) {
	print_error("can't open display %s", display_name);
	exit(EXIT_FAILURE);
    }
    
#ifdef XTERM_SCROLLBAR
    sb_shadow = 0;
#else
    sb_shadow = (Options & Opt_scrollBar_floating) ? 0 : SHADOW;
#endif
    /* set any defaults not already set */
    if (!rs_title) rs_title = rs_name;
    if (!rs_iconName) rs_iconName = rs_name;
    if ((TermWin.saveLines = rs_saveLines) < 0) {
	TermWin.saveLines = SAVELINES;
    }
    
    /* no point having a scrollbar without having any scrollback! */
    if (!TermWin.saveLines) Options &= ~Opt_scrollBar;
    
#ifdef PRINTPIPE
    if (!rs_print_pipe) rs_print_pipe = PRINTPIPE;
#endif
#ifdef CUTCHAR_OPTION
    if (!rs_cutchars) rs_cutchars = CUTCHARS;
#endif
    
#ifndef NO_BOLDFONT
    if (rs_font[0] == NULL && rs_boldFont != NULL) {
	rs_font[0] = rs_boldFont;
	rs_boldFont = NULL;
    }
#endif
    for (i = 0; i < NFONTS; i++) {
	if (!rs_font[i]) rs_font[i]  = def_fontName[i];
#ifdef KANJI
	if (!rs_kfont[i]) rs_kfont[i] = def_kfontName[i];
#endif
    }
    
#ifdef XTERM_REVERSE_VIDEO
    /* this is how xterm implements reverseVideo */
    if (Options & Opt_reverseVideo) {
	if (!rs_color[fgColor]) rs_color[fgColor] = def_colorName[bgColor];
	if (!rs_color[bgColor]) rs_color[bgColor] = def_colorName[fgColor];
    }
#endif
    
    for (i = 0; i < NRS_COLORS; i++) {
	if (!rs_color[i]) rs_color[i] = def_colorName[i];
    }
    
#ifdef CHANGE_SCOLLCOLOR_ON_FOCUS                                                                                
    /* If they don't set the unfocused color, use the scrollbar color to "turn the option off" */
    if (!rs_color[unfocusedScrollColor]) {
      rs_color[unfocusedScrollColor] = rs_color[scrollColor];
    }
#endif

#ifndef XTERM_REVERSE_VIDEO
    /* this is how we implement reverseVideo */
    if (Options & Opt_reverseVideo) {
	char *tmp;
	/* swap foreground/background colors */
	
	tmp = rs_color[fgColor];
	rs_color[fgColor] = rs_color[bgColor];
	rs_color[bgColor] = tmp;
	
	tmp = def_colorName[fgColor];
	def_colorName[fgColor] = def_colorName[bgColor];
	def_colorName[bgColor] = tmp;
    }
#endif
    
    /* convenient aliases for setting fg/bg to colors */
    color_aliases(fgColor);
    color_aliases(bgColor);
#ifndef NO_CURSORCOLOR
    color_aliases(cursorColor);
    color_aliases(cursorColor2);
#endif	/* NO_CURSORCOLOR */
#ifndef NO_BOLDUNDERLINE
    color_aliases(colorBD);
    color_aliases(colorUL);
#endif	/* NO_BOLDUNDERLINE */
    color_aliases(pointerColor);
    color_aliases(borderColor);
    
#ifdef PREFER_24BIT
    Xdepth = DefaultDepth(Xdisplay, Xscreen);
    Xcmap = DefaultColormap(Xdisplay, Xscreen);
    Xvisual = DefaultVisual(Xdisplay, Xscreen);
    
    /*
     * If depth is not 24, look for a 24bit visual.
     */
    if (Xdepth != 24) {
	XVisualInfo vinfo;
	
	if (XMatchVisualInfo(Xdisplay, Xscreen, 24, TrueColor, &vinfo)) {
	    Xdepth = 24;
	    Xvisual = vinfo.visual;
	    Xcmap = XCreateColormap(Xdisplay, RootWindow(Xdisplay, Xscreen),
				    Xvisual, AllocNone);
	}
    }
#endif
    
    /* add startup-menu: */
#if (MENUBAR_MAX)
    delay_menu_drawing = 1;
    menubar_read(rs_menu);
    delay_menu_drawing--;
#else
    delay_menu_drawing = 0;
#endif

    /* Sanity check */
#ifdef PIXMAP_OFFSET
    if (!(Options & Opt_pixmapTrans) && ((Options & Opt_shadeTrans) ||
# ifdef IMLIB_TRANS
					 rs_tintMask != 0xffffff || rs_shadePct
# else
					 rs_tintTrans
# endif
					 )) {
      Options |= (Opt_pixmapTrans | Opt_shadeTrans);
    }

# ifdef IMLIB_TRANS
    if (rs_shadePct == 0) {
      Options &= ~(Opt_shadeTrans);
    } else {
      Options |= Opt_shadeTrans;
    }

# else
    if (rs_tintTrans) {
      if (!(Options & Opt_shadeTrans)) {
	Options |= Opt_shadeTrans;
      }
      if (!strcasecmp(rs_tintTrans, "none")) {
	tint_color = tint_none;
      } else if (!strcasecmp(rs_tintTrans, "red")) {
	tint_color = tint_red;
      } else if (!strcasecmp(rs_tintTrans, "green")) {
	tint_color = tint_green;
      } else if (!strcasecmp(rs_tintTrans, "blue")) {
	tint_color = tint_blue;
      } else if (!strcasecmp(rs_tintTrans, "magenta")) {
	tint_color = tint_magenta;
      } else if (!strcasecmp(rs_tintTrans, "yellow")) {
	tint_color = tint_yellow;
      } else if (!strcasecmp(rs_tintTrans, "cyan")) {
	tint_color = tint_cyan;
      } else {
	print_error("warning:  Tint color \"%s\" not recognized.  Choices are red, green, "
		    "blue, cyan, magenta, and yellow.  Not tinting window.\n", rs_tintTrans);
	Options &= ~(Opt_shadeTrans);
	rs_tintTrans = NULL;
      }
    }
# endif /* IMLIB_TRANS */
#endif /* PIXMAP_OFFSET */

    Create_Windows(argc, argv);
    scr_reset();		/* initialize screen */
    Gr_reset();			/* reset graphics */
    
    /* add scrollBar, do it directly to avoid resize() */
    scrollbar_mapping(Options & Opt_scrollBar);
    /* we can now add menuBar */
    if (delay_menu_drawing) {
	delay_menu_drawing = 0;
	menubar_mapping(1);
    }
    
#ifdef DEBUG_X
    XSynchronize(Xdisplay, True);
    XSetErrorHandler((XErrorHandler) abort);
#else
    oldXErrorHandler = XSetErrorHandler((XErrorHandler) xerror_handler);
#endif
    
#ifdef DISPLAY_IS_IP
    /* Fixup display_name for export over pty to any interested terminal
     * clients via "ESC[7n" (e.g. shells).  Note we use the pure IP number
     * (for the first non-loopback interface) that we get from
     * network_display().  This is more "name-resolution-portable", if you
     * will, and probably allows for faster x-client startup if your name
     * server is beyond a slow link or overloaded at client startup.  Of
     * course that only helps the shell's child processes, not us.
     *
     * Giving out the display_name also affords a potential security hole
     */

    val = display_name = network_display(display_name);
    if (val == NULL)
#endif	/* DISPLAY_IS_IP */
      val = XDisplayString(Xdisplay);
    if (display_name == NULL)
      display_name = val;	/* use broken `:0' value */
    
    i = strlen(val);
    display_string = MALLOC((i+9));
    
    sprintf(display_string, "DISPLAY=%s", val);
    sprintf(windowid_string, "WINDOWID=%u", (unsigned int) TermWin.parent);
    
    /* add entries to the environment:
     * @ DISPLAY:   in case we started with -display
     * @ WINDOWID:  X window id number of the window
     * @ COLORTERM: terminal sub-name and also indicates its color
     * @ TERM:      terminal name
     */
    putenv(display_string);
    putenv(windowid_string);
    if (Xdepth <= 2) {
	putenv ("COLORTERM=" COLORTERMENV "-mono");
	putenv ("TERM=" TERMENV);
    } else {
	if (rs_term_name != NULL) {
	    i = strlen(rs_term_name);
	    term_string = MALLOC((i + 6) * sizeof(char));
	    
	    sprintf(term_string, "TERM=%s", rs_term_name);
	    putenv(term_string);
	} else {
#ifdef DEFINE_XTERM_COLOR
	    if (Xdepth <= 2)
	      putenv("TERM=" TERMENV);
	    else
	      putenv("TERM=" TERMENV "-color");
#else
	    putenv("TERM=" TERMENV);
#endif
	}
#ifdef PIXMAP_SUPPORT
      putenv("COLORTERM=" COLORTERMENV "-pixmap");
#else
	putenv("COLORTERM=" COLORTERMENV);
#endif
    }
    
    D_CMD("init_command()\n");
    init_command(rs_execArgs);
#ifndef USE_POSIX_THREADS
    if (Options & Opt_borderless) {
	resize_window();
    }
#endif
    
#ifdef USE_POSIX_THREADS
    D_THREADS("main_thread:");
    pthread_attr_init(&main_loop_attr);
    pthread_create(&main_loop_thr, &main_loop_attr,
		   (void *)&main_thread, NULL);
    D_THREADS("done? :)\n");
    while (1)
      ;
    /*	main_loop(); */
#else
    main_loop();		/* main processing loop */
#endif
    
    return (EXIT_SUCCESS);
}
/* EOF */
