.\" t
.\" @(#)Pager.1	1/12/96
.TH Pager 1.20 "Mar 16 1996"
.UC
.SH NAME
Pager \- the Afterstep Pager module
.SH SYNOPSIS
Pager is spawned by afterstep, so no command line invocation will work.
From within the autoexec file or as a menu option, Pager is spawned as follows:
.nf
.sp
Module Pager 0 3
.sp
.fi
or from within an afterstep pop-up menu:
.nf
.sp
% cat "~/GNUstep/Library/AfterStep/start/Modules/Virtual desktop"
Pager 0 3
.sp
.fi
where "0" is the first desktop to show, and "3" is the last.

.SH DESCRIPTION
The Pager module shows a miniature view of the Afterstep desktops which
are specified in the command line. This is a useful reminder of where
your active windows are. Windows in the pager are shown in the same
color as their afterstep decorations. 

The pager can be used to change your viewport into the current
desktop, to change desktops, or to move windows around.

Pressing mouse button 1 in the pager will cause you viewport to
change to the selected page of the selected desk. If you click with
button 1 in the desk-label area, you will switch desks but not
pages within the desk.

Dragging mouse button 2 on a miniature view of a window will cause
that window to be move to the location where you release the mouse
button, but your viewport will not change. If you drag the window
out of the pager and onto your desktop, a full size image of
the window will appear for you to place. There is no way to
pick up a full size image of the window and move it into the pager,
however. Since some mice do not have button 2, I have made provisions to drag 
windows in the pager by using pressing modifier-1 (usually Alt) and dragging 
with button 3.

Clicking mouse button 3 on a location within the current desktop will
cause the viewport to move to the selected location, but will not
align the viewport to a page boundary. Dragging button 3 will
cause the viewport to move as you drag. Button 3 operations are
limited to the current desktop only.

When iconified, the pager will work as a fully functional current page
only pager. Windows and viewports can be moved within the icon of the
pager. Users will want to make sure that they have no lines similar to
.nf
.sp
Icon "Pager" whatever
.sp
.fi
in their feel files.

.SH INITIALIZATION
During initialization, \fIPager\fP will eventually search a 
configuration file which describes the time-outs and actions to take.
The configuration file is ~/GNUstep/Library/AfterStep/pager .

If the Pager executable is linked to another name, ie ln -s
Pager OtherPager, then another module called OtherPager can be
started, with a completely different configuration than Pager,
simply by changing the keyword  Pager to OtherPager. This way multiple
Pager programs can be used.

.SH KEYBOARD FOCUS CONTROL
You can direct the keyboard focus to any window on the current desktop
by clicking with button 2 on its image in the pager. The window does
not need to be visible, but it does need to be on the current page.

.SH INVOCATION
The invocation method was shown in the synopsis section

.SH CONFIGURATION OPTIONS
Pager reads ~/GNUstep/Library/AfterStep/pager file when it starts up,
and looks for certain configuration options:

.IP "*PagerGeometry \fIgeometry\fP"
Completely or partially specifies the pager windows location and
geometry, in standard X11 notation. 
In order to maintain an undistorted aspect ratio, you might
want to leave out either the width or height dimension of the
geometry specification

.IP "*PagerRows \fIrows\fP"
Tells afterstep how many rows of desks to use when laying out the pager
window.

.IP "*PagerColumns \fIcolumns\fP"
Tells afterstep how many columnss of desks to use when laying out the pager
window.

.IP "*PagerIconGeometry \fIgeometry\fP"
Specifies a size (optional) and location (optional) for the pager's icon 
window. Since there is no easy way for Pager to determine the height of the
icon's label, you will have to make an allowance for the icon  label height
when using negative y-coordinates in the icon location specification (used to
specify a location relative to the bottom instead of the top of the screen).

.IP "*PagerStartIconic"
Causes the pager to start iconified. 

.IP "*PagerFont \fIfont-name\fP"
Specified a font to use to label the desktops. If \fIfont_name\fP is
"none" then no desktop labels will be displayed.

.IP "*PagerSmallFont \fIfont-name\fP"
Specified a font to use to label the window names in the pager. If not
specified, the window labels will be omitted. Window labels seem to
be fairly useless for desktop scales of 32 or greater.

.IP "*PagerFore \fIcolor\fP"
Specifies the color to use to write the desktop labels, and
to draw the page-grid lines.

.IP "*PagerBack \fIcolor\fP"
Specifies the background color for the window.

.IP "*PagerHilight \fIcolor\fP"
The active page and desk label will be highlighted by using this
background pattern instead of the normal background.

.IP "*PagerLabel \fIdesk label\fP"
Assigns the text \fIlabel\fP to desk \fIdesk\fP in the pager window.
Useful for assigning symbolic names to desktops, ie
.nf
.sp
*PagerLabel 1 Mail
*PagerLabel 2 Maker
*PagerLabel 2 Matlab
.sp
.fi

.IP "PagerXPM \fIdesk xpm\fP"
Sets \fIxpm\fP as the root window background for desktop \fIdesk\fP. 
The XPM is also used as background for the Desktop representation in the 
Pager window.
.nf
.sp
*PagerXPM 0 ~/GNUstep/Library/AfterStep/desktop/desks/desk0/background.xpm
*PagerXPM 1 ~/GNUstep/Library/AfterStep/desktop/desks/desk1/background.xpm
*PagerXPM 2 ~/GNUstep/Library/AfterStep/desktop/desks/desk2/background.xpm
*PagerXPM 3 ~/GNUstep/Library/AfterStep/desktop/desks/desk3/background.xpm
.sp
.fi

Please don't change the default, else AfterStep will not know how to
automatically change root pixmap when you change of desktop !

.IP "PagerRedrawBg \fInumber\fP"
If 0, will not update background change, use this with xearth or xfishtank.
Default is 1, i.e. update background.


.IP "PagerAlign \fILabelPosition\fP"
Sets the alignment of the labels for the desktops. Use 0 for centered,
>0 for left, <0 for right alignment. If <>0 the absolute value of
\fILabelPosition\fP will be the distance between label text and
window border.


.IP "DeskTopScale \fInumber\fP"
If the geometry is not specified, then a desktop reduction factor is
used to calculate the pager's size. Things in the pager window
are shown at 1/\fInumber\fP of the actual size.


.SH AUTHORS
Robert Nation

Alfredo Kojima

Guylhem Aznar
