#ifndef ___ARENA_STYLE_H___
#  define ___ARENA_STYLE_H___


#include "defs.h"
#include "types.h"
#include "image_types.h"
#include "style_types.h"


/*
 * howcome 22/3/95: added strengths for Arena style sheets.
 */

#define S_LENS		3
#define S_READER        2
#define S_AUTHOR        1
#define S_FALLBACK      0

#define S_IMPORTANT     1
#define S_LEGAL         1
#define S_NORMAL        0

#define S_SPECIFIC	0
#define S_WILDCARD	1
#define S_ANY		2

#define S_BACKGROUND_COLOUR	1
#define S_BACKGROUND_IMAGE	2
#define S_BACKGROUND_FIXED	4
#define S_BACKGROUND_X_REPEAT	8
#define S_BACKGROUND_Y_REPEAT	16
#define S_BACKGROUND_ORIGIN	32



#define SV_NORMAL 			0

#define SV_FONT_FAMILY_SYMBOL		1
#define SV_FONT_FAMILY_HELVETICA	2
#define SV_FONT_FAMILY_TIMES		3
#define SV_FONT_FAMILY_COURIER		4
#define SV_FONT_FAMILY_TERMINAL		5
#define SV_FONT_FAMILY_FIXED		6
#define SV_FONT_FAMILY_CHARTER		7
#define SV_FONT_FAMILY_LUCIDA		8
#define SV_FONT_FAMILY_LUCIDABRIGHT	9
#define SV_FONT_FAMILY_NCS		10

#define SV_FONT_WEIGHT_NORMAL 	        0x0
#define SV_FONT_WEIGHT_EXTRA_LIGHT	0x1
#define SV_FONT_WEIGHT_LIGHT		0x1
#define SV_FONT_WEIGHT_DEMI_LIGHT	0x1
#define SV_FONT_WEIGHT_MEDIUM		0x2
#define SV_FONT_WEIGHT_DEMI_BOLD	0x3
#define SV_FONT_WEIGHT_BOLD		0x4
#define SV_FONT_WEIGHT_EXTRA_BOLD	0x5

#define SV_FONT_STYLE_NORMAL		0x0
#define SV_FONT_STYLE_ITALIC		0x1
#define SV_FONT_STYLE_ROMAN		0x2
#define SV_FONT_STYLE_OBLIQUE		0x3
#define SV_FONT_STYLE_SMALL_CAPS	0x5

#define SV_TEXT_DECORATION_NONE		0x1
#define SV_TEXT_DECORATION_UNDERLINE	0x2
#define SV_TEXT_DECORATION_OVERLINE	0x3
#define SV_TEXT_DECORATION_LINE_THROUGH	0x4
#define SV_TEXT_DECORATION_BLINK	0x5

#define SV_TEXT_TRANSFORM_NONE		0x0
#define SV_TEXT_TRANSFORM_CAPITALIZE	0x1
#define SV_TEXT_TRANSFORM_UPPERCASE     0x2
#define SV_TEXT_TBRANSFORM_LOWERCASE	0x3

#define SV_F_SMALLCAPS_IGNORE		0x0
#define SV_F_SMALLCAPS_OFF		0x1
#define SV_F_SMALLCAPS_ON		0x2

#define SV_F_BIGINITIAL_IGNORE		0x0
#define SV_F_BIGINITIAL_OFF		0x1
#define SV_F_BIGINITIAL_ON		0x2

#define SV_F_DROPPED_IGNORE		0x0
#define SV_F_DROPPED_OFF		0x1
#define SV_F_DROPPED_ON			0x2

#define SV_MARGIN_AUTO		1



#define S_UNSET           0x0
#define S_INITIALIZED     0x1
#define S_INHERITED       0x2
#define S_INFERRED        0x3
#define S_INITIAL_FLAG    0x4
#define S_LEADING_FLAG    0x5
#define S_INDENT_FLAG     0x6
#define S_MARGIN_TOP_FLAG 0x7


/*
 * Global variables. :(
 */

extern double lens_factor;


/*
 * Functions.
 */

extern Bool DelStyleSheet(StyleSheet* theStyleSheet);

extern Bool StyleGetFlag(Doc*, int);
extern void StyleSetFlag(Doc*, int, Bool);

extern void FreeStyleSheet(StyleSheet*);
extern Bool StyleClearDoc(Doc*);

extern char *StyleLoad(char *, int, Bool);
extern void StyleParse(Doc* doc);

extern void StyleZoomChange(Doc*, double);

extern long StyleGet(Doc*, StyleInternalProperty);
extern StyleSheet* StyleGetInit(void);

extern StyleSheet* StyleCopy(StyleSheet*);

void StyleChew(Doc* doc, StyleSheet* sheet, char *str, Byte origin);

extern void FormatElementStart(Doc* doc, int, char *, int);
extern void FormatElementEnd(Doc* doc);


#endif /* ifndef ___ARENA_STYLE_H___ */
