/*
 * Debugging tools.	QingLong.14-12-96
 */

#include <stdio.h>
#ifdef __STDC__
#  include <stdarg.h>
# else
#  include <varargs.h>
#endif

#include "defs.h"
#include "types.h"

#include "arena.h"
#include "debug.h"
#include "error.h"
#include "history.h"
#include "menu.h"

#include "style_i.h"

#include "HTAnchor.h"


unsigned long debug = 0;	/* used to control reporting of errors */


#define ARENA_PREFIX          " "BANNER"."
#define ARENA_PREFIX_LENGTH   (BANNER_LENGTH + 2)

#define ARENA_FUNCTION_NAME_LENGTH	36

/*
 * Just to ease and centralize control. QingLong.14-12-96.
 */
#ifdef __STDC__
int Arena_DebugPrint(char* output_format, ...)
# else
int Arena_DebugPrint(output_format, va_alist)
     char* output_format;
     va_dcl
#endif
{
 int ret;
 va_list args;

 va_start(args, output_format);
 ret = vfprintf(stderr, output_format, args);
 va_end(args);

 return ret;
}

/*
 * Stylization of trace printing. QingLong.14-12-96.
 */
#ifdef __STDC__
int Arena_TracePrint(char* theCallerFunction, char* output_format, ...)
# else
int Arena_TracePrint(theCallerFunction, output_format, va_alist)
     char* theCallerFunction;
     char* output_format;
     va_dcl
#endif
{
 int ret;
 va_list args;
 char theWho[ARENA_FUNCTION_NAME_LENGTH] = ARENA_PREFIX;

 strncat(theWho, theCallerFunction ? theCallerFunction : "???",
	 ARENA_FUNCTION_NAME_LENGTH-ARENA_PREFIX_LENGTH-1);
 ret = fprintf(stderr, "%s:", theWho);
 if (output_format[0] != ' ')     /* glk.3.11.97   Internationalization      */
   ret += fprintf(stderr, " ");   /* fix so DON'T have to have " " at begin  */

 va_start(args, output_format);
 ret += vfprintf(stderr, output_format, args);
 va_end(args);

 return ret;
}


/*
 * Print some info about document. QingLong.14-12-96.
 */
void debug_PrintDoc(char* theCallerFunction, Doc* thedocument)
{
 char theWho[ARENA_FUNCTION_NAME_LENGTH] = ARENA_PREFIX;
 char* doc_kind;

 strncat(theWho, theCallerFunction ? theCallerFunction : "???",
	 ARENA_FUNCTION_NAME_LENGTH - ARENA_PREFIX_LENGTH - 1);

 Arena_DebugPrint("%s:", theWho);

 if (thedocument)
   {
    doc_kind = thedocument->main_doc ? "main" : "inline" ;
    Arena_DebugPrint("\n\t\"%s\" Doc: doc = "POINTER_FORMAT", state %d,\n",
		     doc_kind, thedocument, thedocument->state);

    if (thedocument->url)
      Arena_DebugPrint("\tdoc->url = \"%s\",\n", thedocument->url);
     else
      Arena_DebugPrint("\tdoc->url ? Unspecified?\n");
    /* End ``if (thedocument->url)'' */

    if (thedocument->content_buffer)
      {
       Arena_DebugPrint("\tit has content_buffer ("POINTER_FORMAT"),\n",
			thedocument->content_buffer);

       if (thedocument->loaded_length)
	 {
	  Arena_DebugPrint("\tand it's length (loaded_length) = %ld,\n",
			   thedocument->loaded_length);
	  }
	else
	  {
	   Arena_DebugPrint("\tbut empty content (loaded_length = 0),\n");
	  }
	/* End ``if (thedocument->loaded_length)'' */
      }
     else
      {
       Arena_DebugPrint("\thas no content (content_buffer = NULL),\n");
      }
    /* End ``if (thedocument->content_buffer)'' */

    if (thedocument->image)
      {
       Arena_DebugPrint("\tis an image (image = "POINTER_FORMAT"),\n");
      }
     else
      {
       Arena_DebugPrint("\tis not an image (image = NULL),\n");
      }
    /* End ``if (thedocument->image)'' */

    if (thedocument->anchor)
      {
       void* adocument;

       Arena_DebugPrint("\tdoc->anchor = "POINTER_FORMAT",\n",
			thedocument->anchor);

       adocument = HTAnchor_document(thedocument->anchor);

       if (adocument)
	 Arena_DebugPrint("\tdoc->anchor->document = "POINTER_FORMAT",\n",
			  adocument);
        else
	 Arena_DebugPrint("\tdoc->anchor->document = NULL,\n");
       /* End ``if (adocument)'' */
      }
     else
      Arena_DebugPrint("\tdoc->anchor = NULL,\n");
    /* End ``if (thedocument->anchor)'' */

    if (thedocument->request)
      {
       Arena_DebugPrint("\tdoc->request = "POINTER_FORMAT".\n",
			thedocument->request);
      }
     else
      Arena_DebugPrint("\tdoc->request = NULL.\n");
    /* End ``if (thedocument->request)'' */
   }
  else
   {
    Arena_DebugPrint(" the document is NULL!\n");
   }
 /* End ``if (thedocument)'' */

 return;
}

/*
 * Print some info about document. QingLong.14-12-96.
 */
void debug_PrintAnchor(char* theCallerFunction, HTAnchor* theanchor)
{
 char theWho[ARENA_FUNCTION_NAME_LENGTH] = ARENA_PREFIX;

 strncat(theWho, theCallerFunction ? theCallerFunction : "???",
	 ARENA_FUNCTION_NAME_LENGTH - ARENA_PREFIX_LENGTH - 1);

 Arena_DebugPrint("%s:", theWho);

 if (theanchor)
   {
    HTParentAnchor* theparent;

    Arena_DebugPrint("\n\tanchor = "POINTER_FORMAT",\n", theanchor);

    if ((theparent = HTAnchor_parent(theanchor)) != NULL)
      {
       void* thedocument;

       Arena_DebugPrint("\tanchor->parent = "POINTER_FORMAT",\n",
			theparent);

       if ((thedocument = HTAnchor_document(theparent)) != NULL)
	 {
	  Arena_DebugPrint("\tanchor->parent->document = "POINTER_FORMAT",\n",
			   thedocument);
	  if (((Doc*)thedocument)->anchor)
	    Arena_DebugPrint("\tanchor->parent->document->anchor = "
			     POINTER_FORMAT".\n",
			     ((Doc*)thedocument)->anchor);
	   else
	    Arena_DebugPrint("\tanchor->parent->document->anchor is NULL!\n");
	 }
	 else
	   Arena_DebugPrint("\tanchor->parent->document is NULL!\n");
       /* End ``if (theanchor->parent->document)'' */
      }
    else
      Arena_DebugPrint("\tanchor->parent is NULL!\n");
    /* End ``if (theanchor->parent)'' */
   }
 else
   {
    Arena_DebugPrint(" the anchor is NULL!\n");
   }
 /* End ``if (theanchor)'' */

 return;
}


/*
 * libsane is a debuging routine that checks the state of document pointers.
 */
void libSane(void)
{
}


/*
 * debugging routine which prints out the current history stack.
 */
void HistoryList(Context* context)
{
 HTList *ll, *l = context->history;
 History *h;
 HTAnchor *a;
 char *theaddress, *thephysical;
 void* thedocument;
 HTParentAnchor* theparent;

 Arena_DebugPrint("\n------*-----------\n"
		  " Arena.HistoryList: current position %d n_ele %d\n",
		  context->history_pos, HTList_count(context->history));

 ll = l;
 while ( (h = (History *)HTList_nextObject(l)) )
   {
    a = h->anchor;
    theparent = HTAnchor_parent(a);
    theaddress = HTAnchor_address(a); /* Must be freed after all! */
    thephysical = HTAnchor_physical(theparent);
    thedocument = HTAnchor_document(theparent);

    Arena_DebugPrint(" Arena.HistoryList: the history list item:\n");
    Arena_DebugPrint("\tlist position: %d\n", HTList_indexOf(ll, h));

    if ((HTAnchor *)theparent == a)
      Arena_DebugPrint("\tPARENT\n");
     else
      Arena_DebugPrint("\tCHILD: \"%s\"\n", h->tag);

    Arena_DebugPrint("\th="POINTER_FORMAT" anchor="POINTER_FORMAT" "
		     "y=%ld state %d\n",
		     h, a, h->y, h->state);

    if (h->title) Arena_DebugPrint("\th->title = \"%s\"\n", h->title);

    if (thephysical)
      Arena_DebugPrint("\ta->parent->physical = \"%s\"\n",
		       thephysical);
     else
      {
       if (theaddress)
	 Arena_DebugPrint("\ta->parent->address = \"%s\"\n",
			  theaddress);
       else
	 if (thedocument)
	   {
	    Arena_DebugPrint("\t (Doc*)a->parent->document = \"%s\"\n",
			     ((Doc *)thedocument)->url);
	   };
      }

    Free(theaddress);   /* It has been malloc'd within `HTAnchor_address' */
   }
 Arena_DebugPrint(" Arena.HistoryList: end history list.\n"
		  "------*-----------\n\n");
}


/*
 * Arena_printMenuItems prints the list of the items of the given menu.
 */
void Arena_printMenuItems(MenuItem *theMenuItem)
{
 MenuItem *mi;

 for (mi = theMenuItem; mi != NULL; mi = mi->next)
   Arena_DebugPrint("\titem %d: %s\n", mi->item_pos, mi->label);
}


/* StyleSane is a debugging function which tries to
 * print out the content of a style sheet.
 */
void StyleSane(StyleSheet* s)
{
 StyleInternalProperty i;
 StyleRule *r;

 if (STYLE_TRACE) Arena_DebugPrint("\nstylesane:\n");

 if (s == NULL) return;

 for (i = ArenaSI_UNKNOWN; i < ArenaSI_NPROPERTY; i++)
   {
    HTList *l = s->iproperty[i];
    StyleSelector *sel;

    if (STYLE_TRACE) Arena_DebugPrint("  iproperty %d\n", i);
    while ((r = (StyleRule *)HTList_nextObject(l)))
      {
       if (STYLE_TRACE) Arena_DebugPrint("    selector (");
       sel = r->selector;
       if (STYLE_TRACE)
	 {
	  do
	    {
	     if (sel->ss.class)
	       Arena_DebugPrint("%d.%s ", sel->ss.element, sel->ss.class);
	      else
	       Arena_DebugPrint("%d ",sel->ss.element);
	    } while ((sel = sel->ancestor));

	  Arena_DebugPrint(") ");

	  Arena_DebugPrint("    property %d \tweight %d \tvalue ",
			   r->iproperty, r->weight);

	  switch (r->value_p->type)
	    {
	     case ST_UNKNOWN:
	     case ST_FLAG:
	     case ST_FLOAT:
	     case ST_PX:
	     case ST_PERCENT:
	     case ST_EM:
	       Arena_DebugPrint("%ld ", (long)r->value_p->value);
	       break;
	     case ST_RGB:
	       Arena_DebugPrint("#%x,%x,%x ",
			        (int)(((int)r->value_p->value >> 16) & 0xFF),
			        (int)(((int)r->value_p->value >>  8) & 0xFF),
			        (int)(((int)r->value_p->value >>  0) & 0xFF));
		    break;
	     case ST_STR:
	       {
		char *s = (char *)r->value_p->value;

		Arena_DebugPrint("%s+ ", s);
		break;
	       }
	    }
	 }
      }
   }

 if (STYLE_TRACE) Arena_DebugPrint("stylesane end\n");
}

#ifdef ARENA_FUNCTION_NAME_LENGTH
#  undef ARENA_FUNCTION_NAME_LENGTH
#endif
