#ifndef ___ARENA_BRIDGE_H___
#  define ___ARENA_BRIDGE_H___

#include "defs.h"
#include "types.h"


/*
 * Global variables. :(
 */

/* HTFormat's */
extern HTAtom* text_atom;
extern HTAtom* html_atom;
extern HTAtom* html3_atom;
extern HTAtom* html_level3_atom;
extern HTAtom* gif_atom;
extern HTAtom* jpeg_atom;
extern HTAtom* png_atom;
extern HTAtom* png_exp_atom;
extern HTAtom* xpm_atom;
extern HTAtom* xbm_atom;
extern HTAtom* unknown_atom;	/* QingLong.13-02-97 */
extern HTAtom* css_atom;	/* QingLong.13-02-97 */
extern HTAtom* css1_atom;	/* QingLong.10-02-97 */

extern Bool AbortFlag;


/*
 * Functions.
 */
Bool ArenaBridgeInit(void);
Bool ArenaBridgeQuit(void);

void HTList_destroy(HTList* me);

void OpenDoc(char *name);
void ReloadDoc(char *name);
void PostDoc(char *name, char *post);

Doc* GetInline(char* href, int hreflen, Bool reload);
Doc* GetStyleSheet(char* href, int hreflen, Bool reload);
Bool DocType(char* a, char* b);
Bool DocHTML(Doc* d);
Bool DocImage(Doc* d);
Bool DocRawText(Doc* d);
long Y_of_Fragment(Doc *d, const char *fragment);
Bool delete_Document_bad_flags(Doc* document);
Bool DocDel(Doc* document);

void libEntry(void);
void libExit(int pCache);
void libEventLoop(int c, char* href);

Bool HTCheckPresentation(HTList* conversions, char* content_type,
			 double quality);


char*            ExpandHref(char* href);
HTAnchor* anchorExpandnHref(char* href, size_t hreflen);

Doc* libLoadAnchor(HTAnchor* anchor, Doc* host_doc,
		   Bool main_doc, Bool nofree, Bool record,
		   Bool reload, Bool block, Bool forreal);

/*
 * pseudoLoadAnchor() "loads" the document from the memory,
 * i.e. just
 *          checks if it is already present in the history,
 *          registers (if necessary) in the history,
 *          initiates document parsing and displaying process.
 *
 * You should provide it a pointer to a buffer containing the document
 * and the length of the buffer (`content_buffer' and `loaded_length'),
 * and href/hreflen pair for the document.
 * Any other `Doc' structure parameters will be set by pseudoLoadAnchor.
 * It will allocate new Doc structure,
 * new content_buffer and copy the buffer to it's own container,
 * create HTParentAnchor structure and link it with the document.
 * `reload', `block', and `for_real' parameters would be used for children...
 */
Doc* pseudoLoadAnchor(char* thehref,
		      int   thehrefLength,
		      char* theBaseURL,
		      int   theBaseURLLength,
		      char* theDocContentsBuffer,
		      int   theDocContentsBufferLength,
		      HTFormat theDocumentFormat,
		      Bool main_doc, Bool nofree, Bool record,
		      Bool reload, Bool block, Bool forreal,
		      Doc* host_doc);

HTAnchor *libGetDocument(char *href, size_t hreflen,
			 Doc *host_doc,
			 Bool main_doc, Bool nofree, Bool record,
			 Bool reload, Bool block);

Doc* libPostDocument(char *href, size_t hreflen, char *post, size_t postlen);

/*void ConnectAnchorDocument(HTAnchor *anchor, HTRequest *request);*/
void ConnectAnchorDocument(HTAnchor *anchor, HTRequest *request,
			   Bool terminate);


#endif	/* ifndef ___ARENA_BRIDGE_H___ */
