#! /bin/bash

VERSION=$(grep AM_INIT_AUTOMAKE configure.in | 
    sed 's/AM_INIT_AUTOMAKE(console-tools,//; s/)//; s/ //g')

DISTDIR=console-tools-${VERSION}

echo "VERSION = \`$VERSION'"
diff <( find \
    -not -path "./builddir*" \
    -not -path "./debian*" \
    -not -path "./${DISTDIR}*" \
    -not -path "./working*" \
    -not -path "./attic*" \
    -not -path "./*/.deps*" \
    -not -name "Makefile" \
    -not -path "./data/Make.rules" \
    -not -path "./libtool" \
    | sort
) <( cd ${DISTDIR} && find | sort)
