#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "config.h"
#include "mswordview.h"

style *decode_stylesheet(FILE *tablefd,U32 stsh,U32 stshlen)
	{
	U16 sprm=0;
	U16 j;
	int i,upxbytes,len,nostyles,m;
	U16 thingy;
	
	U16 cb;
	style *stylelist;
	U16 pos;
	int baseistd;
	int tempistd;

	error(stderr,"the new stsh is (%x), len (%x)\n",stsh,stshlen);

	fseek(tablefd,stsh,SEEK_SET);
	error(stderr,"not really stsh size is %ld\n",read_16ubit(tablefd));
	
	nostyles = read_16ubit(tablefd);
	error(stderr,"count of styles is %d\n",nostyles);
	error(stderr,"cbSTDBaseInFile is %ld\n",read_16ubit(tablefd));
	for (i=0;i<7;i++)
		read_16ubit(tablefd);

	stylelist = (style *) malloc(sizeof(style) * nostyles);
	if (stylelist == NULL)
		{
		fprintf(stderr,"arse no mem for styles !\n");
		exit(-1);
		}
	
	for (m=0;m<nostyles;m++)
		{
		cb = read_16ubit(tablefd);
		error(stderr,"size of std %ld\n",cb);

		stylelist[m].thepap.istd = 0;
		stylelist[m].thepap.fInTable = 0;
		stylelist[m].thepap.fTtp= 0;
		stylelist[m].thepap.ilvl = -1;
		stylelist[m].thepap.ilfo = -1; /*index into hpllfo*/
		stylelist[m].thepap.list_data = NULL; /*index into hpllfo*/
		
	
		init_chp(&stylelist[m].thechp);
		
		error(stderr,"m val is %d\n",m);

		if (cb != 0)
			{
			pos=0;

			read_16ubit(tablefd);
			pos+=2;
			j = read_16ubit(tablefd);
			pos+=2;
			baseistd = j>>4;
			error(stderr,"based upon istd is %d %d",j,baseistd);
			if (baseistd < 0x0ffe)	
				{
				if (baseistd < m)
					fill_pap(stylelist,m,baseistd);
				else
					error(stderr,"how can i be based on a style that i havent seen yet?\n");
				}
			else
				error(stderr,"WARNING strange and unsupported istd base %x\n",baseistd);
			j = read_16ubit(tablefd);
			pos+=2;
			error(stderr,"# of upx is %d %d\n",j,j>>12); 
			upxbytes = j;
			for (i=0;i<2;i++)
				{
				read_16ubit(tablefd);
				pos+=2;
				}
			len = read_16ubit(tablefd);
			pos+=2;
			error(stderr,"name len is %d,\n",len);
			for(i=0;i<len+1;i++)
				{
				thingy = read_16ubit(tablefd);
				pos+=2;
				error(stderr,"thingy is %ld (%X) (-%x-) (-%c-)\n",thingy,thingy,thingy,thingy);
				}

			error(stderr,"pos is %x and %d",ftell(tablefd),pos);

			if ((pos+1)/2 != pos/2)
				{
				/*eat odd bytes*/
				error(stderr,"odd offset\n");
				fseek(tablefd,1,SEEK_CUR);
				pos++;
				}

			if (pos == cb)
				{
				error(stderr,"continuing\n");
				continue;
				}
			else if (pos > cb)
				{
				error(stderr,"rewinding & continuing\n");
				fseek(tablefd,cb-pos,SEEK_CUR);
				continue;
				}
			if ((pos+1)/2 != pos/2)
				{
				/*eat odd bytes*/
				error(stderr,"odd offset\n");
				fseek(tablefd,1,SEEK_CUR);
				pos++;
				}

			if (pos == cb)
				{
				error(stderr,"continuing\n");
				continue;
				}
			else if (pos > cb)
				{
				error(stderr,"rewinding & continuing\n");
				fseek(tablefd,cb-pos,SEEK_CUR);
				continue;
				}

			/*read some kind of len variable, hairy territory again*/
			upxbytes = read_16ubit(tablefd);
			pos+=2;
			error(stderr,"1 eat %d bytes",upxbytes);
			j=0;
			if (upxbytes > 1)
				{
				tempistd = read_16ubit(tablefd);
				pos+=2;
				j+=2;
				if (tempistd != m)
					{
					error(stderr,"istds mismatch is %x %x\n",m,tempistd);
					/*treat it as a sprm instead*/
					sprm = tempistd;
					}
				else
					{
					if (j < upxbytes)
						{
						sprm = read_16ubit(tablefd);
						j+=2;
						pos+=2;
						}
					}
				}

			while (j<upxbytes)
				{
				error(stderr," j was %d\n",j);
				pos-=j;
				decode_sprm(tablefd,sprm,&(stylelist[m].thepap),&(stylelist[m].thechp),NULL,&j,NULL,stylelist,stylelist[m].thepap.istd);
				error(stderr," j is %d\n",j);
				pos+=j;
				if (j>=upxbytes)
					break;
				sprm = read_16ubit(tablefd);
				j+=2;
				pos+=2;
				}

			if ((pos+1)/2 != pos/2)
				{
				/*eat odd bytes*/
				error(stderr,"odd offset\n");
				fseek(tablefd,1,SEEK_CUR);
				error(stderr,"were at %x\n",ftell(tablefd));
				pos++;
				}

			if (pos == cb)
				{
				error(stderr,"continuing\n");
				continue;
				}
			else if (pos > cb)
				{
				error(stderr,"rewinding & continuing\n");
				fseek(tablefd,cb-pos,SEEK_CUR);
				continue;
				}

			/*then this is the len of bytes of the next stuff*/
			upxbytes = read_16ubit(tablefd);
			pos+=2;
			error(stderr,"2 eat %d bytes",upxbytes);

			/*k this is the good stuff*/
			j=0;
			while (j < upxbytes)
				{
				sprm = read_16ubit(tablefd);
				j+=2;
				pos+=2;
				error(stderr," j was %d\n",j);
				pos-=j;
				decode_sprm(tablefd,sprm,&(stylelist[m].thepap),&(stylelist[m].thechp),NULL,&j,NULL,stylelist,stylelist[m].thepap.istd);
				error(stderr," j is %d\n",j);
				pos+=j;
				}
			
			if ((pos+1)/2 != pos/2)
				{
				/*eat odd bytes*/
				error(stderr,"odd offset\n");
				fseek(tablefd,1,SEEK_CUR);
				pos++;
				}

			error(stderr,"m val %d, ilfo is %d\n",m,stylelist[m].thepap.ilfo);
			}
		}
	return(stylelist);
	}


void fill_pap(style *stylelist,int m,int b)
	{
	stylelist[m].thepap.fInTable = stylelist[b].thepap.fInTable;
	stylelist[m].thepap.fTtp= stylelist[b].thepap.fTtp;
	stylelist[m].thepap.ilvl = stylelist[b].thepap.ilvl;
	stylelist[m].thepap.ilfo = stylelist[b].thepap.ilfo;
	stylelist[m].thepap.list_data=stylelist[b].thepap.list_data;

	stylelist[m].thechp.fBold=stylelist[b].thechp.fBold;
	stylelist[m].thechp.fItalic=stylelist[b].thechp.fItalic;
	stylelist[m].thechp.ascii_font=stylelist[b].thechp.ascii_font;
	stylelist[m].thechp.eastfont=stylelist[b].thechp.eastfont;
	stylelist[m].thechp.noneastfont=stylelist[b].thechp.noneastfont;
	stylelist[m].thechp.fontsize=stylelist[b].thechp.fontsize;
	stylelist[m].thechp.supersubscript= stylelist[b].thechp.supersubscript;
	stylelist[m].thechp.fontcode=stylelist[b].thechp.fontcode;
	stylelist[m].thechp.fontspec=stylelist[b].thechp.fontspec;
	stylelist[m].thechp.color=stylelist[b].thechp.color;
	}
