#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "config.h"
#include "mswordview.h"

void decode_sprm(FILE* in,U16 clist,pap *retpap,chp *retchp,sep *retsep,U16 *l,U8 **list,style *sheet,U16 istd)
	{
	int i;
	int sprmlen;
	U16 sprm2;
	U16 sprm3;
	U8 len;
	U16 j;
	int orig;
	chp emchp;
	

	error(stderr,"SPRM is %x\n",(int)clist);

	switch(clist)
		{
		/*sep*/
		case 0x3009:
			retsep->bkc=dgetc(in,list);
			(*l)++;
			break;
		case 0x300A:
			retsep->fTitlePage=dgetc(in,list);
			(*l)++;
			break;
		case 0x300E:
			retsep->nfcPgn=dgetc(in,list);
			error(stderr,"nfcPgn is %d\n",retsep->nfcPgn);
			(*l)++;
			break;
		case 0x3011:
			retsep->restart=dgetc(in,list);
			(*l)++;
			break;
		case 0x3012:
			retsep->fEndNote=dgetc(in,list);
			(*l)++;
			break;
		case 0x3013:
			retsep->lnc=dgetc(in,list);
			(*l)++;
			break;
		case 0x500B:
			retsep->ccolM1=dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x5015:
			retsep->nLnnMod=dgetc(in,list);
			(*l)++;
			break;
		case 0x501C:
			retsep->pgnStart=dread_16ubit(in,list);
			(*l)+=2;
			break;
		/*pap*/
		case 0xC63E:
			error(stderr,"anld here\n");
			len = dgetc(in,list);
			(*l)++;
			retpap->ouranld.nfc = dgetc(in,list);
			retpap->ouranld.cxchTextBefore = dgetc(in,list);
			retpap->ouranld.cxchTextAfter= dgetc(in,list);
			retpap->ouranld.flags1=dgetc(in,list);
			retpap->ouranld.flags2=dgetc(in,list);
			retpap->ouranld.flags3=dgetc(in,list);
			retpap->ouranld.ftc=dread_16ubit(in,list);
			retpap->ouranld.hps=dread_16ubit(in,list);
			retpap->ouranld.startat=dread_16ubit(in,list);
			dread_16ubit(in,list);
			dread_16ubit(in,list);
			dread_16ubit(in,list);
			dread_16ubit(in,list);
			for (i=0;i<32;i++)
				retpap->ouranld.rgxch[i] = dread_16ubit(in,list);
			(*l)+=84;
			break;
		case 0x2602:
		case 0x2640:
			error(stderr,"aha lvl!!!\n");
			dgetc(in,list);
			(*l)++;
			break;
		case 0xC615:
		case 0xC60D:
			error(stderr,"TABTABTAB\n");
			len = dgetc(in,list);
			error(stderr,"len is %d\n",len);
			for (i=0;i<len;i++)
				{
				dgetc(in,list);
				(*l)++;
				}
			(*l)++;
			break;
		case 0x2416:
			retpap->fInTable = dgetc(in,list);
			error(stderr,"FIntable set to %d\n",retpap->fInTable);
			(*l)++;
			break;
		case 0x2417:
			retpap->fInTable = 1;
			retpap->fTtp = dgetc(in,list);
			error(stderr,"FIntable set to %d indirectly\n",retpap->fInTable);
			(*l)++;
			break;
		case 0x260A:
			retpap->ilvl = dgetc(in,list);
			error(stderr,"ilvl set to %d\n",retpap->ilvl);
			if (retpap->ilvl > 8)
				{
				error(stderr,"hmm, strange ilvl here, setting to -1\n");
				retpap->ilvl =-1;
				}
			(*l)++;
			break;
		case 0x460B:
			retpap->ilfo = dread_16ubit(in,list);
			/*
			like Collin Park (collin@hpycla.kobe.hp.com) says
			i probably have to back through loads of code and 
			check for sign extensions and friends, oh oh
			*/
			error(stderr,"ilfo is %d\n",retpap->ilfo);
			if (retpap->ilfo == 2047)
				error(stderr,"warning, special list depth\n");
			else
				{
				if (retpap->ilfo == 0)
					error(stderr,"not numbered (bulleted ?)\n");
				retpap->ilfo--;
				}
			error(stderr,"ilfo is now %d\n",retpap->ilfo);
			(*l)+=2;
			break;
		case 0x4600:
			retpap->istd = dread_16ubit(in,list);
			error(stderr,"MAGIC: istd is %d\n",retpap->istd);
			(*l)+=2;
			break;

		/*chp*/
		case 0xCA47:
			/*
			take the embedded chp, compare to external chp
			the equal fields are set to the styles ones
			*/
			sprmlen=dgetc(in,list);
			(*l)++;
			error(stderr," the len is %d\n",sprmlen);
			j=0;
			init_chp(&emchp);
			while(j<sprmlen)
				{
				sprm2 = dread_16ubit(in,list);
				j+=2;
				error(stderr,"embedded sprm is %X\n",sprm2);
				/*
				decode_sprm(in,sprm2,retpap,&emchp,&j,list,sheet,retpap->istd);
				*/
				decode_sprm(in,sprm2,retpap,&emchp,retsep,&j,list,sheet,istd);
				error(stderr,"em j got set to %d\n",j);
				}
			error(stderr,"retpap->istd is %d\n",retpap->istd);
			*l = *l + j;
#if 0
			if (emchp.fBold == retchp->fBold)
				retchp->fBold = sheet[retpap->istd].thechp.fBold;
			if (emchp.fItalic== retchp->fItalic)
				retchp->fItalic= sheet[retpap->istd].thechp.fItalic;
			if (emchp.fontsize== retchp->fontsize)
				retchp->fontsize= sheet[retpap->istd].thechp.fontsize;
			if (emchp.underline== retchp->underline)
				retchp->underline= sheet[retpap->istd].thechp.underline;
#endif
			if (emchp.fBold == retchp->fBold)
				retchp->fBold = sheet[istd].thechp.fBold;
			if (emchp.fItalic== retchp->fItalic)
				retchp->fItalic= sheet[istd].thechp.fItalic;
			if (emchp.fontsize== retchp->fontsize)
				retchp->fontsize= sheet[istd].thechp.fontsize;
			if (emchp.underline== retchp->underline)
				retchp->underline= sheet[istd].thechp.underline;

			/*others not implemented yet*/
			break;

		case 0x486D:
		case 0x486E:
			error(stderr,"lid data is %X",dread_16ubit(in,list));
			(*l)+=2;
			break;
		case 0x0835:
			orig = retchp->fBold;
			retchp->fBold= dgetc(in,list);
			(*l)++;
			switch (retchp->fBold)
				{
				case 1:
					retchp->fBold= 1;
					break;
				case 0:
					retchp->fBold= 0;
					break;
				case 128:
					/*in this case bold value is the based upon val*/
					retchp->fBold = orig;
					break;
				case 129:
					error(stderr,"swapping around\n");
					retchp->fBold = abs(orig-1);
					break;
				}
			error(stderr,"BOLD is %d\n",retchp->fBold);
			/*not sure what each 0,127 etc mean yet*/
			error(stderr,"j here is %d\n",*l);
			break;
		case 0x0836:
			orig = retchp->fItalic;
			retchp->fItalic = dgetc(in,list);
			(*l)++;
			error(stderr,"ITALIC is %d\n",retchp->fItalic);
			switch(retchp->fItalic)
				{
				case 1:
					retchp->fItalic = 1;
					break;
				case 0:
					retchp->fItalic = 0;
					break;
				case 128:
					/*set to original*/
					retchp->fItalic = orig;
					break;
				case 129:
					retchp->fItalic = abs(orig-1);
					break;
				}
			break;
		case 0x6424:
		case 0x6425:
		case 0x6426:
		case 0x6427:
		case 0x6428:
		case 0x6429:
			dread_16ubit(in,list);
			dread_16ubit(in,list);
			(*l)+=4;
			break;
		case 0x0800:
		case 0x0838:
		case 0x0839:
		case 0x083A:
		case 0x083B:
		case 0x083C:
		case 0x2407:
		case 0x2431:
			dgetc(in,list);
			(*l)++;
			break;
		case 0x4845:
			/*how much to sub and super*/
			dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x4A43:
			retchp->fontsize = dread_16ubit(in,list);
			(*l)+=2;
			error(stderr,"font is %d\n",retchp->fontsize);
			break;
		case 0x4A30:
			sprm3 = dread_16ubit(in,list);
			error(stderr,"aha wants to set char istd to %ld ?\n",sprm3);
			*retchp = sheet[sprm3].thechp;
			(*l)+=2;
			break;
		case 0x261B:
			dgetc(in,list);
			(*l)++;
			break;
		case 0x4A4F:
			retchp->ascii_font=dread_16ubit(in,list);
			error(stderr,"font stuff for ascii text is %ld\n",retchp->ascii_font);
			(*l)+=2;
			break;
		case 0x4A50:
			retchp->eastfont=dread_16ubit(in,list);
			error(stderr,"font stuff for east text is %ld\n",retchp->eastfont);
			(*l)+=2;
			break;
		case 0x4A51:
			retchp->noneastfont=dread_16ubit(in,list);
			error(stderr,"font stuff for noneast text is %ld\n",retchp->noneastfont);
			(*l)+=2;
			break;
		case 0x486B:
		case 0x0418:
		case 0xA413:
		case 0xA414:
		case 0x484B:
		case 0x484E:
			error(stderr,"eat\n");
			dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x840F:
		case 0x840E:
			dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x9407:
		/*
			retpap->fInTable = 1;
		*/
			error(stderr,"FIntables have been set to %d indirectly ?\n",retpap->fInTable);
			dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x9602:
			error(stderr,"9602: gives %d\n",dread_16ubit(in,list));
			(*l)+=2;
			break;
		case 0x2403:
		case 0x0868:
		case 0x2A42:
		case 0x2406:
			dgetc(in,list);
			(*l)++;
			break;
		case 0x2A3E:
			retchp->underline = dgetc(in,list);
			error(stderr,"underline set to %d\n",retchp->underline);
			(*l)++;
			break;
		case 0x2A48:
			retchp->supersubscript = dgetc(in,list);
			error(stderr,"sub super is %d\n",retchp->supersubscript);
			(*l)++;
			break;
		case 0xD605:
			/*
			retpap->fInTable = 1;
			*/
			len = dgetc(in,list);
			(*l)++;
			error(stderr,"FIntable set to %d indirectly\n",retpap->fInTable);
			for(i=0;i<len;i++)
				{
				dgetc(in,list);
				(*l)++;
				}
			break;
		case 0xD608:
			/*
			retpap->fInTable = 1;
			*/
			len = dread_16ubit(in,list);
			(*l)+=2;
			error(stderr,"FIntable set to %d indirectly, val %x\n",retpap->fInTable,len);
			retpap->ourtap.cell_no = dgetc(in,list);
			(*l)++;
			error(stderr,"there are %d cells in this row\n",retpap->ourtap.cell_no);
			retpap->ourtap.tablewidth=0;
			for(i=0;i<retpap->ourtap.cell_no+1;i++)
				{
				retpap->ourtap.cellwidth[i] = (S16) dread_16ubit(in,list);
				error(stderr,"a dx is %d\n",retpap->ourtap.cellwidth[i]);
				(*l)+=2;
				}
			retpap->ourtap.tablewidth=retpap->ourtap.cellwidth[retpap->ourtap.cell_no] - retpap->ourtap.cellwidth[0];
			for(i=0;i<len-1-((retpap->ourtap.cell_no+1)*2);i++)
				{
				dgetc(in,list);
				(*l)++;
				}
			break;
		case 0x6A09:
			retchp->fontcode=dread_16ubit(in,list);
			error(stderr,"font code is %d\n", retchp->fontcode);
			retchp->fontspec=dread_16ubit(in,list);
			error(stderr,"char spec is %d\n",retchp->fontspec);
			retchp->fSpec=1;
			(*l)+=4;
			break;
		case 0x0856:
			retchp->fObj=dgetc(in,list);
			error(stderr,"is an object is %d\n",retchp->fObj);
			(*l)++;
			break;
		case 0x0854:
			dgetc(in,list);
			(*l)++;
			break;
		case 0x0855:
			retchp->fSpec=dgetc(in,list);
			error(stderr,"special set to %d\n",retchp->fSpec);
			(*l)++;
			break;
		case 0x2A53:
		case 0x8840:
			/*i think these all are lumped together and take two bytes*/
			dread_16ubit(in,list);
			(*l)+=2;
			break;
		case 0x6A03:
			retchp->fSpec=1;
			error(stderr,"fcpic is %x\n", dread_32ubit(in,list));
			(*l)+=4;
			break;
		case 0x6412:
			dread_16ubit(in,list);
			dread_16ubit(in,list);
			(*l)+=4;
			break;
		default:
			{
			error(stderr,"unsupported %x l is %d",clist,*l);
			clist = (clist & 0xe000);
			error(stderr,"val %d",clist);
			clist = clist >> 13;
			error(stderr,"val %d",clist);
			len=0;
			switch (clist)
				{
				case 0:
				case 1:
					len=1;
					break;
				case 2:
				case 4:
				case 5: 
					len=2;
					break;
				case 7:
					len=3;
					break;
				case 3:
					len=4;
					break;
				case 6:
					len=dgetc(in,list);
					(*l)++;
					break;
				default:
					error(stderr,"shouldnt see this len value!!\n");
					break;
				}
			
			for(i=0;i<len;i++)
				{
				dgetc(in,list);
				(*l)++;
				}
			error(stderr,"l is now %d\n",*l);
			}
		
		}
	}
