/* Additions to texmfmp.h for pdfTeX */

#define pdfischarused(f, c) ((boolean)(pdfcharused[f][c/8] & (1<<(c%8))))
#define pdfsetcharused(f, c) pdfcharused[f][c/8] |= (1<<(c%8))

/* writepdf() always writes by fwrite() */
#define       writepdf(a, b) \
  (void) fwrite ((char *) &pdfbuf[a], sizeof (pdfbuf[a]), \
                 (int) ((b) - (a) + 1), pdffile)

/* web2c input/output routines */
#define vfbopenin(f) \
    open_input (&(f), kpse_vf_format, FOPEN_RBIN_MODE)
#define typeonebopenin(f) \
    open_input (&(f), kpse_type1_format, FOPEN_RBIN_MODE)
#define truetypebopenin(f) \
    open_input (&(f), kpse_truetype_format, FOPEN_RBIN_MODE)
#define texpsheaderbopenin(f) \
    open_input (&(f), kpse_tex_ps_header_format, FOPEN_RBIN_MODE)

extern void writezip();
extern void writeimg();
extern void dopdffont();
extern void readconfig();
extern void adjustcfgdimens();
extern integer readimg();
extern void addimageref();
extern void deleteimageref();
extern void libpdffinish();
extern integer imagewidth();
extern integer imageheight();
extern integer imagexres();
extern integer imageyres();
extern boolean iscolorimage();
extern boolean ispdfimage();
extern integer cfgoutput();
extern integer cfgcompresslevel();
extern integer cfgdecimaldigits();
extern integer cfgpkresolution();
extern integer cfgpagewidth();
extern integer cfgpageheight();
extern integer cfghorigin();
extern integer cfgvorigin();
extern integer newvfpacket();
extern unsigned char packetbyte();
extern void pushpacketstate();
extern void poppacketstate();
extern void startpacket();
extern integer fmlookup();
extern boolean sharedsrc(int,int);
extern void storepacket(int,int,int);
