/*                                             W3C Sample Code Library libwww MIME and RFC822
                      DECLARATION OF W3C SAMPLE CODE MIME AND RFC822
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   This is the module for basic RFC822/MIME parsing that can be used together with the
   core of the W3C Sample Code Library. It contains all MIME specific modules which are
   required to compile and build the MIME DLL.
   
 */
#ifndef WWWMIME_H
#define WWWMIME_H
/*

 */
#ifdef __cplusplus
extern "C" {
#endif
/*

  System dependencies
  
   The sysdep.h file includes system-specific include files and flags for I/O to network
   and disk. The only reason for this file is that the Internet world is more complicated
   than Posix and ANSI.
   
 */
#include "sysdep.h"
/*

  MIME Entity Header Parsing
  
   The libwww MIME parsers are completely generic in that they don't know about any
   particular headers - they are all registered at run-time by the application. There are
   two parsers: the first is for parsing _MIME headers_ and the second is for parsing
   _MIME footers_. They are both converters that can be set up using the HTConverterInit
   function in the libwww setup module
   
   There is also a default set of the headers defined by the HTTP/1.1 specification which
   can be initialized using the HTMIMEInit()function in the libwww setup module.
   
 */
#include "HTMIME.h"                     /* Generic MIME parser */
#include "HTHeader.h"                   /* Header parser registration */
/*

  MIME Entity Header Generation
  
   When sending a MIME entity along with a request, for example using NNTP or HTTP, the
   entity headers are generated by the MIME generator stream. This stream will be added to
   the output stream pipe in order to decorate the outgoing request.
   
 */
#include "HTMIMERq.h"                   /* MIME request generator */
/*

  Default MIME Header Parsers
  
   The Library's MIME parser is divided into two parts: A generic MIME parser that knows
   how to unwrap all RFC822 headers and specialized header parsers that knows how to parse
   Content-Length, for example. This is the default set of the specialized MIME header
   parsers that can be registered as part of the generic MIME. Note that these functions
   are not registered by default - they must be registered by the application. This can be
   done using the HTMIMEInit() function in the WWWInit interface. Of course this can also
   be used to register new headers that are not represented below - or if you want to
   replace a default parser then this is also very easy.
   
 */
#include "HTMIMImp.h"
/*

  Multipart MIME Parsing and Generation
  
   Libwww supports MIME multipart generation and parsing using two streams. The parser
   stream is a converter that can be setup for"converting" the MIME body parts into
   separate documents. The MIME multipart stream parser can be set up by using the
   HTConverterInit function in the libwww setup module.
   
 */
#include "HTBound.h"                    /* Multipart MIME parser */
#include "HTMulpar.h"                   /* Multipart MIME generator stream */
/*

   End of MIME modules
   
 */
#ifdef __cplusplus
} /* end extern C definitions */
#endif

#endif
/*

   
   ___________________________________
   
                            @(#) $Id: WWWMIME.html,v 2.9 1997/02/16 18:43:27 frystyk Exp $
                                                                                          
    */
