/*								     HTTrace.c
**	TRACE AND DATA LOGGING UTILITIES
**
**	(c) COPYRIGHT MIT 1996.
**	Please first read the full copyright statement in the file COPYRIGH.
**	@(#) $Id: HTTrace.c,v 2.4 1997/01/03 01:03:40 eric Exp $
**
**      26 Nov 96 (EGP)	moved HTTrace stuff here from HTString.c and
**			added HTTrace_data
*/

/* Library include files */
#include "sysdep.h"

#ifndef HAVE_ABORT
#include <signal.h>
#endif

/*
**	All the tracing facilities are prototyped in
**	HTUtils.h because they are needed everywhere.
*/
#include "HTUtils.h"

#if WWWTRACE_MODE == WWWTRACE_FILE
PUBLIC FILE *WWWTrace = NULL;
#endif

#ifndef WWW_WIN_DLL
PUBLIC int WWW_TraceFlag = 0;		/* Global trace flag for ALL W3 code */
#endif

PRIVATE HTTraceCallback * PHTTraceCallback = NULL;

PUBLIC void HTTrace_setCallback (HTTraceCallback * pCall)
{
    PHTTraceCallback = pCall;
}

PUBLIC HTTraceCallback * HTTrace_getCallback (void)
{
    return PHTTraceCallback;
}

#ifdef HAVE_STDARG_H
#define PVAR1C(t1, n1,  ap) \
  (t1 n1, ...) { va_list ap; va_start (ap, n1);
#define PVAR2C(t1, n1,  t2, n2,  ap) \
  (t1 n1, t2 n2, ...) { va_list ap; va_start (ap, n2);
#define PVAR3C(t1, n1,  t2, n2,  t3, n3,  ap) \
  (t1 n1, t2 n2, t3 n3, ...) { va_list ap; va_start (ap, n3);
#else
#define PVAR1C(t1, n1,  ap) \
  (va_alist) va_dcl { t1 n1; va_list ap; va_start (ap); \
                      n1 = va_arg (ap, t1);
#define PVAR2C(t1, n1,  t2, n2,  ap) \
  (va_alist) va_dcl { t1 n1; t2 n2; va_list ap; va_start (ap); \
                      n1 = va_arg (ap, t1); n2 = va_arg (ap, t2);
#define PVAR3C(t1, n1,  t2, n2,  t3, n3,  ap) \
  (va_alist) va_dcl { t1 n1; t2 n2; t3 n3; va_list ap; va_start (ap); \
                      n1 = va_arg (ap, t1); n2 = va_arg (ap, t2); \
                      n3 = va_arg (ap, t3);
#endif

PUBLIC int
HTTrace PVAR1C (const char *, fmt, pArgs)
{
    if (PHTTraceCallback)
	return (*PHTTraceCallback)(fmt, pArgs);
#ifdef WWW_WIN_WINDOW
    return (0);
#else
    return (vfprintf(stderr, fmt, pArgs));
#endif
}}

PRIVATE HTTraceDataCallback * PHTTraceDataCallback = NULL;

PUBLIC void HTTraceData_setCallback (HTTraceDataCallback * pCall)
{
    PHTTraceDataCallback = pCall;
}

PUBLIC HTTraceDataCallback * HTTraceData_getCallback (void)
{
    return PHTTraceDataCallback;
}

PUBLIC int
HTTraceData PVAR3C(char *, data, size_t, len, char *, fmt, pArgs)
{
    if (PHTTraceDataCallback)
	return (*PHTTraceDataCallback)(data, len, fmt, pArgs);
    return (0);
}}

PUBLIC void HTDebugBreak (void)
{
#ifdef WWW_MSWINDOWS
    DebugBreak();
#else /* WWW_MSWINDOWS */
#ifdef HAVE_ABORT
    abort();
#else
    signal(SIGABRT);
#endif
#endif /* !WWW_MSWINDOWS */
}

