% File:    GB90.8pat
% Author:  Piet Tutelaers (rcpt@urc.tue.nl)
% Version: betarelease 0.9 (May 1993)
% Purpose: 8-bit hyphenation patterns for TeX
% These patterns are generated from the `Groene boekje 1990' (GB90) with
% the following goals in mind:
%   - provide 8-bit patterns
%   - allow hyphenation in first two and last three letters
%   - inhibit hyphenation before a `trema'
%   - don't hyphenate words in a changing syllable (me-nuu.tje)
%   - don't hyphenate words with different hyphenations (buur.t.je)
%
% extra symbolen          
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "a
\catcode`\=11\uccode`\=`\\lccode`\=`\ % c,
\catcode`\=11\uccode`\=`\\lccode`\=`\ % `e
\catcode`\=11\uccode`\=`\\lccode`\=`\ % 'e
\catcode`\=11\uccode`\=`\\lccode`\=`\ % ^e
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "e
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "i
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "i
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "a
\catcode`\=11\uccode`\=`\\lccode`\=`\ % ~n
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "o
\catcode`\=11\uccode`\=`\\lccode`\=`\ % "u
\catcode`\'=12\lccode`\'=`\'
%
\patterns{
.aan5
.aarts5
.a4b5l
.acht5end
.a3da
.a2f3
.af5ra
.af5s
.agent5j
.a4l3ee
.a4l3ev
.alk4
.al5ko
.al5m
.a2lo
.al3om
.ame3r
.am5p
.a3nac
.an5d4
.a4nes
.ang2
.a4nis
.an5th
.a5o
.a1p2a
.a3pl
.a1pr
.as3
.a4s5l
.a5sti
.a4su
.ave5n
.b4
.be3la
.be5l4u
.be5ra
.bijs4
.bi4l
.bli4
.boot5j
.box3
.co5kes.
.corre5s
.d4
.dan5ste.
.de2k
.dek3l
.des5p
.deu4r
.dis5
.du4w
.ede4
.edel3
.ee4s
.eest3
.eet3
.ei3l
.e2kl
.e3kw
.en5th
.e3p4
.er3a
.er2f
.e4r3in
.ert4
.erts3
.e4s3
.es5c
.es5m
.e5so
.es5pr
.e3th
.eus5
.exi5
.f4
.fes1
.g4
.gaat5
.ge5la
.ge5le
.ge3lo
.ge5n4a
.ge5ne
.ge5no
.ge5ra
.ge5re
.ge5ro
.ge3s
.ge1t
.goes5
.go4m
.goot5
.hemi5
.ho4lo
.i2
.i3d
.ij4sp
.im5p
.in3
.in5d
.in5g4
.in5ktv
.in5kw
.ins4
.int4
.in5ta
.i3re
.is3c
.is5m
.i3t
.j2
.jaar5
.k4
.kee4
.ke3ra
.ker4k5l
.kerk5u
.koot5
.kop5l
.kun2
.l4
.le4b5
.le4g3o
.le4g3r
.lemmet5j
.le2s
.lof5
.loot5
.lo4s3
.lui5tj
.m4
.ma4len
.mar5che.
.me5no
.merk5l
.mijn5i
.moot5
.mo4s
.n4
.naat5
.na5s
.ne4t3j
.noot5j
.oa5
.oe4r
.oes5
.ol3f
.o2m1
.o2n
.on3a
.on5d
.onde4
.o4n1e
.on5g
.on1o
.ons4
.on5sp
.on4t3
.on5to
.oor5t
.o5pak
.o4p3ar
.o4p3at
.o4pet
.o4p5l
.o2p3o
.o4p5r
.op1s
.o3ro
.or1t
.o4s3
.p4
.pee5tj
.pe4k3l
.per5spec
.pij5t
.poort5j
.po5te
.r4
.raads5le
.raat5
.rai2
.ran4d
.rand5a
.rens4
.re5t
.rie2
.riet3
.rijk5a
.ring5s4
.roe5t4j
.s4
.sa4p3
.see3
.seig5
.se3m
.servi5c
.se4s
.ses5t
.set3
.side3
.si4s
.slee5tj
.smids5e.
.spoor5tj
.st4
.t4
.taart5j
.te2a
.te4f
.tek2
.te5na
.tent5j
.te4ra
.ter4p5a
.te2s
.ti2n
.tri5s
.ui2
.uit1
.u3ra
.u3ro
.u3s
.vaat5j
.ve4r1
.vie2
.vrij3
.w4
.wee4
.weet3
.we4l
.wel3a
.wel5in
.wer2
.wet4s
.win4s
.y2
.zet3a
.zet3j
a4a4
aad1a
aad3o
aad3r
aaf3a
4aag
aag3a
aag5e
aag3r
aak3e
aak3r
aal5a
aal1e
4aal5k
aal1o
aal5ste
aam1a
aam3o
aam5p
aan1
3aando
3aandu
aan5g
3aanj
aan5k4
3aann
3aans4l
aan5sp
3aanv
aap3i
aap3o
aar3a
aard5as
aar4du
aar3e
aar3i
aar5k
4aarn
aar1o
aars5te.
4aart
aar4ton
aar3u
aas5c
aas5e
aas5m
4aast
aat3a
aat5e
aat3h
aat4j
aat3o
aat1r
a2b
abak4s5
a5be
abet3j
ab3ijz
ab5lu
3abon
a4b3ru
4ac.
4ace
ace3a
2ach.
a3cha
4a1che
4a3chi
a1cho
a1chr
2achs
a1chu
4ack
2acl
ac5le
2aco
2acr
4acs
4acu
ad2a
ad5aa
ad3ac
ad3ad
ad3ak
ad5al
3adap
ada2r3
ade5le
ades4
ad3ete
2adh
ad4i
a4dj
3adju
ad3oks
3adop
ad3ov
ad3ro
ad5sla
ads5tra
ad3ui
ad3un
ad1w
4ady
aege4
ae3k4
a3el
aes3
ae3u
af3aa
a3f4as
af5de
af5dw
afee4
afe4la
af3ex
3afgi
4afi
af3l
a2foe
afon4d
af3r
af5so
af5sp
aft4a
3aftr
a2f3u
ag3ad
ag3ap
agee5t
agen5a
agen4tj
ager4s
a4g3ind
a4g3ins
ag1l
ag3of
ag3ord
ag4re
ag5reg
ag5rei
ag5ret
ag3roo
ag3s2a
ag3sl
ag4sle
ag4sli
ag3spa
ag1s4t
ag3ui
ag3ur
a2g3uu
a1h
a5hi
ai5b
ai1e
ai4es
a1ij
ai5k
ai4o.
ai3s4
ai5sc
ai4s5l
aissi5
ai5sti
ai3tj
4a
an4
ans5
a1j
ak3ag
ak3am
ak3ap
a2k3ar
a3ke
ak3een
ak3etu
a4k3ez
4akh
ak3ink
3akko
a2k3l
ak3n
ak4ni
a3kof
ak3ond
ak5opl
a3kos
ak3ri
ak3ru
4aks
aks5m
ak5spe
a2k3u
ak1w
a1la
al4aa
a4l3ach
ala3d
al3afs
a3l4ag
4ald
a1le
al3eff
ales4t
ale5ste
alfs5p
al2gl
alk5ei
al4kla
alk5sa
alm4a
al4m3ac
a1lo
alo2n
alo3s
al3ou
a3loy
al3sa
als4ag
al4s5m
al2sn
als3oo
al4spr
al4stem
al5ster
al4sto
altaar5
al3tha
4a1lu
al3uit
alus3
4am.
a2m3ac
am3adr
1ambt
a3me
ament4
ame5rad
ame4u
ameus5te
4amm
a5moe
a4m3ol
am3ove
am5pe
3amp
am4pl
4ams
am2so
am4s5po
a2m3ui
a1na
a3nad
a3nap
an3arc
an3av
an4dad
an4d3ed
an4dom
an4doo
an2dr
and5rad
an5dri
an4dro
and5roo
and5sle
ands5taal
anei4
a3nen
an3est
ane3us
ang5sn
angs4t
a3ni
ani4a.
aniet3
anij4
an3ion
a4n3isl
an3iso
4anj
4ank.
an4kaa
4anken
an2kr
ank3ri
a1no
an3or
ano3s
an2sa
an2sm
an2so
an3soo
ans3or
an4sp
an4tac
5antenn
an3th
an5to
a1nu
an3ur
an3uu
a3o
a4o.
a4o5b
a4os
aos3t
a4ou
a4oz
aoze3
4ap.
4a3pa
ap1ac
a5pap
a5par
a4pas
ap3as.
ap3ass
ap3eks
ape5l4e
a4pet
ap5eten
a1pi
apijt5j
ap3ijz
ap1j
ap4l
ap5laa
ap5lad
ap5lak
ap5len
a5plu
a1po
ap3og
apo5sta
1appa
4appo
ap3ra
ap5rac
ap3re
a5p4ris
ap2s3l
a1pu
4ar.
a3ra
ar3amn
a4r3app
ara3s4
ara5st
5arctis.
4ard
ar2da
ard3ac
ard3ak
ar5de
ar4d3op
ar2d1r
ar4d5re
ard3w
a1r4e
are3st
are4t
ar5eve
ar3gh
ar2gl
ar3go
a1ri
arie4t
arij3s
ar4k3aa
ar4kla
ar2m3u
4a1ro
a3rok
ar3oli
4ar2s
ar5sch
ar5se
ars3l
ar5slie
ar3sp
ar5spe
ar4spi
ar4spr
ars5tal
ar4stek
ars3tr
ars5tra
ar4t3ak
art5ank
ar4tap
ar3tar
4arte
4ar4tj
4arto
art5oge
art5ond
art5oog
ar4t3or
ar2t3r
ar3tre
a3ru
4arw
a1ry
a2s
4asa
as3aa
as3af
as3ak
as3ap
a3sau
as3av
as4cr
as4e
a4s3ec
a4s3e3t
a5sex
a4s5h
a4sin
asi4s
as5ki
as5ku
as3l
a5s4laa
a4sm
as5me
as5mi
as5mo
as4n
as5na
as3ob
as3on
as3oo
as3os
as3p
as5pec
as5per
a4st
as3ta
as5ta.
as5taal
a5stat
as3te
as5te.
as5tee
a5steni
as5ter
as4th
as5tie
as3to
ast5rem
ast3ri
a5stu
a3su
a3sy
a1ta
at1ac
at3ade
at3af.
a4t5am
at3ank
ata5s
atent5r
ate4r5ad
ate4r5ec
a1th
a5thali
at3hu
ati5r
a2t3j
at5ja
at5jo
a1to
at3oog
a1tr
at1re
at3rib
at5ru
at5sen
at2sl
ats3le
ats3lo
ats5m
at4sna
at4sp
ats5pa
at5spi
at5spl
at5spo
at3sta
at4sti
ats5tol
at4t3u
a1tu
a2t3ui
at5w
2au
au5b
au3dr
3aug
au3ko
aun3t
aure3u
aus3t
au3sto
au3t2
auter5i
3auto
auts5
au4wij
ava3s
aver3a
ave3re
ave3r4u
4avi
a4v5l
4avot
a1w
aze3s
3b
4b.
baar5tj
babe4
ba2di
ba3gh
5bak
bak4sp
bal4ka
bal4t
ba3n2a
ban4kl
ban4kn
ban4kr
bank3w
bar3t
bart3j
ba3s4a
bassi4
4bb
bba2t
bbe4l5ee
bbe4n
bben3a
bby5
4bc
4b1d
5be.
5bed
be3d4a
bed2w
be5dwi
be5dwo
beet3
be3fl
5be3g
bei3l
bei4tj
5bej
be5kak
bek4l
5bel
be4lex
be5l4i
be3l4o
be5m
5ben
be3ne
be3n4i
5ber
be1ra
ber4g5af
ber4gl
ber4gr
be1ro
be4ron
ber4ov
be3ru
5be1s4
bes5ac
be2sj
bes5te.
bes5tig
5bet
be1tw
b3h
b2i
bi5bl
bid3
bi2du
bie4t3j
bij5d
bij3k
bij1p
bij3s
bijs5ter
bij5tr
bi4k
bi5la
bin4dr
bin4t3j
bir3
bi5sa
bis5m
bi1tr
4b1j
4bk
b4l
blad5ij
b5lap
b5leg
ble2s3
b5lid
5blie
5blim
5blo
bloot5j
4bm
4b3n
5bo.
5boe
boe4g3a
boe4ka
boek5s
boe3st
bo3fl
5bog
5boi
5bo
5bo2k
bokje5
5bol
bo2m3a
bo2m3o
bo3na
bonds3
bont3j
bo3nu
5bool
boon5
bor4sta
bor4st5r
5bos3
bo3sko
bos5p
bo2su
5bot
bot5j
bot5sw
bo2tu
bou5ta
bouw3s
5box
br4
braad5s
brei3s
5bri
bri4l
bro4n
bron3o
4b1s4
b5sc
bsi3s4
b2s5la
b2s5m
bsou4
bs5s
4bt2
bt4s5
5bu
bune5t
bu5ri
bus3a
buur4tj
4b3w
5by
bys4
4bz
4c.
3ca
caat5j
ca1ch
ca3g2
came3r
ca3na
cant4
ca5ou
ca3pr
cas3
ca5se
ca5si
cas1t
ca3t
cau3
c5c
3ce
5ced
cee4
5ceel
5cel
ce3na
cen5s4
ce3ra
ce3ro
5ces
ce3s4a
ce2sn
ce3s4t
ces4u
ce3ta
ce4t3j
cet3o
1c
4ch.
3chao
3chec
3chef
5chef.
5chefs
4cheor
2chep
3cheq
che5rin
che3us
1ch
4chn
chop4s
2chp
4cht
4chw
1chy
3ci
cier4s5
ci1eu
5cil
ci5le
ci3ne
ci5nee
cis5m
ci3t
ci5ta
c4k3l
c2k3n
c4k3r
c2ku
3c4l
cli3e
c3n
cno4
3co
co2at
co2k4
co3ka
co3kr
co3la
5com
con3g
co3no
con5t4
4coo
co3p4
5copa
corp2
cor3s
co3ru
co3sti
co3th
4cout
c3p
1cr2
3cre
3cris
croo3
crus5
csar5
c3ste
4c1t
ct3afd
c2t3h
c2t3j
c3t4o
c4t5ond
c5tor4
c5tr
ct3sl
c2tw
cty5
3cu
cu5b
cus5t
c3w
3cy3
1
4d.
1da
5da.
3daag
d4aal
d3aanw
daar5e
2d3acc
5daden
2d3af
da3fr
3dag
da2g1a
da4g3ed
da4g3et
da4g3l
da4gor
da2gr
da2gu
3dai
4dakk
da4k5r
4d3ala
d4ale
4dalm
d2ame
dam5pl
3dan
da4n3a
d3anke
dan4kl
danoot5
dan4sm
dans3p
dan4st
2d1ap
4d3ape
2dar
da4ra
4d3arb
dar4mo
dar3s
4dart
3das3
3d4at
da3ta
da2tr
5dau
2db
dboot5
dbou4w5i
2d1c
dcorre5
2d5d2
dde5la
dder5al
dde3s
3de
5de.
de3c
de3d
5deda
d4eden
dee2g3
dee4r
dee3t
de3fl
d3eg.
5dega
5dege
2d3egg
de3gl
4dei
d3ei.
d3eie
d3eig
d3eis
de4s
de3ke
4d3ekon
de4lak
4delas
del5do
del5dr
del5eek
de5ler
de4let
de4lev
del5fr
del4sp
dels5taa
del4str
4demai
4d3emm
dem4o
de3n4ac
den3ep3
4d3engt
de2no
den3oo
den5sm
dent5jes
5denvl
de3rab
de4rad
de3rak
de3ram
de3ran
de3r4ap
de3ras
de4ras.
5derb
der5ede
der5eed
de4r3ei
de4rem
de4r3ep
derep5e
de4ret
de5rij
de4r3im
der3og
der3on
5ders
der4s5om
4d3erts
de5se
de3sh
de4si
de2sn
de2so
de4sp
des3po
de5spr
de3sta
de3ste
de5stic
de3sto
de3t4
4d3euro
de3us.
de3uss
deu4tj
4dexa
4dexp
3d
2d1f
2d1g4
d3ga
d3gi
2d1h
d3he
dheer4
3dhi.
dhis5m
1di
dia3s4
die4tj
di1eu
3dig
di2ga
dij4kr
2d3ijz
di2k3o
di4k3w
di5l4e
di3na
3ding.
d5ingel
d5inh
d5inr
4dins
4d3inw
2d3inz
dip4
di4s
di5se
dis5m
dit3j
2d1j
3dji
2d1k
2d3l
2d1m
2d5n
1do
5d4o.
do5bo
3doe
4doef
doet3
5doi
2doks
5dole
3d4om
d5oml
do2m3o
dom4s
do3no
2d3on4t
dont3e
donyx3
door5tj
4d3opb
2d3opl
4dopv
d3opz
2d3org
dors5m
dot5j
2dov
2d3p
dpren4
1dr2
d3raap
3drac
d3rad.
4d3rand
4drap
d1rec
d3red
3d4ree
5dreef
5d4res
d4rev
3dreve
d3rich
5drif
dri3ga
d3rijd
d3rijk
d3rijm
d3rijs
5drijv
d4rin
5dris
d3rit
d4roe
4d5roei
d5roer
3drog
2d3rok
4drol
3d4ron
d5rond
4d3rook
4d3roz
drug4s
d3ruit
5druk
4d3rus
2ds
ds1a
dsa4d3
d4s3ed
d4s3ee
ds3h
dsi4g
dsig5a
ds3il
ds3is
ds3j
ds4jo
d4sl
d5slag
ds4lan
ds3li
ds4lim
ds3lu
ds5mal
d3smee
ds5mo
ds3na
ds3neu
ds3noo
ds3on
ds3op
ds3or
d1sp
d5spak
d4spal
ds5par
d3s4pel
d4s3pet
d4spon
d5s4pro
ds4t
d1sta
d4s5tab
d3star
d3ste
d5ste.
d4stek
d5sten
ds5th
d3sti
d1sto
ds5trem
d2su
ds3ur
ds3uu
d3sy
2dt
d1ta
dtaart5j
d1to
d1tr
d3tu
1du
du3e
2d3uil
dui4t
5duite
d3uitg
du3o
dus5
dut3j
2dv
dvee3
dve5na
2dw
d3wac
3d2wei
d3wek
5dwel
d3wez
d3wig
d1wil
4d1wo
3dy3
dys3e
dy5st
2dz
e1a
eaan5
e5ac
ea3da
eagent5j
e2ak
e3akt
e5alf
eal3s4
e3amb
eam5p
eang3
e3antw
e3a5o
e5ap
e5ard
eate4
eb3ac
e5br
3ecd
e1cha
e1che
e5chen
ech3es
e1chi
e3cho
echts5o
e3chu
e4c5le
ecorre5
3ecz
e1d
e3d4ac
e3d4am
edans5te
e5d4as
edek4l
ede5rog
ede5spe
edie5tj
4e3do
edoet4
edoe5tj
ed3opv
e4d3ov
e3dr
ed3rod
ed3rol
ed4so
ed5sp
ed1st
e4dw
e5dwan
ee3a
ee2d3a
ee5de
ee5do
eed3w
ee3ee
ee2f
eef3r
eeg1l
eeg3ou
ee5in
ee2k
ee3ka
ee5kaa
eek3ak
eek5all
eek1e
ee3ki
ee3kl
eek3lo
ee3kr
eek3ro
eek3ur
eek3uu
eek3w
ee2l
eel1a
eel4ee
eel3ei
eel5k
eel3og
ee3loo
ee3lop
eel5so
eel4su
ee3lu
eel3ur
eel3uu
4eem
ee5mo
ee2n
een3aa
een3ad
een3ar
een5dr
een3e
een5g4
een5k
eep3an
ee5pe
eep3lo
eep3ru
eep4sc
eep4st
ee2r
eer3aa
eer3al
ee3ram
ee3ran
ee3re
ee4r3ee
ee5reg
ee4r3i4
eer5k
eer2o
eer3og
eer5oom
ee3rov
eers5ag
eer3sm
ee3ru
ee2s
ee3sj
ees3lo
ee3smu
ee3sn
ee3soo
ee3sp
ees3po
ees5tek
ee3sto
ees3u
ee2t
ee3tal
eet3h
eet3og
eet3oo
eet5or
ee3tr
eet3ra
4e
e4ta
e3fas
ef3az
e3fe
ef3ei
ef3ij
ef3int
e3flu
e1fr
ef4ra
ef5raa
e3fran
ef2s
ef3sm
4ega
eg3all
egas2
eg3as.
ege4las
egel5ei.
egel5ov
ege4raa
eger5on
e4g3erv
e3gi
eg3ijz
egiste4
eg3lui
3ego.
eg3ong
e2g3os
eg3s4
eg5sn
e4g3ur
e4g3uu
e5h
ei5b
eids5e.
eids5m
ei1e
eie3s
ei3gl
e1ij
ei5kl
ei3kn
ei5kr
eik3s
ei3la
ei2lo
e4in
ei3n4ac
ein4d5oo
ein4dr
ein5k
ein5sl
ei4s3a
eis5a.
ei3sh
ei3sla
ei3s4lo
ei4so
ei4s4p
ei5spr
ei3s4ta
eis5te.
ei5s4tel
4eit
ei5te
ei3tj
ei4too
eit4s
eive4
4eiz
4e
e1j4
ek3aan
ekaart5j
ek5af.
ek3al.
ek3ang
e5kaz
eker4s
ek5eter
e4kez
ek3eze
ek5loos
ek3net
e5kni
e3ko
ekoes5
ek3oss
ek3rol
e5kru
ek3sa
ek3ske
eks5m
ek3sn
ek3sp
ek4stel
e1kw
e1la
el1ac
e2l3af
el3akk
el3al
el3art
e3las
el3as.
e2l3au
e3laz
el5azi
el4dri
e3le
e5le.
e4l3eeu
el3eff
el5eier
e5len
el4er
e4l3ert
el3eta
el1fl
el4fr
elf5sp
e3li
e5lig
e4l3ind
el5inkt
el3ins
eli3pl
3elix
el4kon
el3kr
elk3sl
el4k3ur
e1lo
e3lob
e5loep
el3oes5
e2l3ol
el3oms
el5ond
el3ont
el3oog
e5loos
el3opg
el3oph
el3ops
el3opv
e2lor
el3ord
el5ore
el3ove
e5loz
el3smi
el3sta
el3su
el5tje.
e1lu
el3uit
em4a
em5aar
em3ac
em5afs
3emai
e5man
4emb
e3me
eme4las
eme4tj
emf2
emie4tj
em3ins
em4op
em5opn
em3org
em3ov
em5po
em2sl
em1st
e1na
en3aap
e4n3aas
e2n3ab
en1ac
en3ak
e2n3al
e4nante
en3ap
e5nari
e2n4as
en5asi
en1av
e2n3az
enci4
end3ac
ender5as
5enderti
en5dro
end5sl
en4dur
e5ne.
en3ech
e3nee
en3eed
enee5t
en3eg.
en3egg
en3ei
en3eko
en3ema
e5nen.
e4n3ent
e2nep
en3epo
en3erf
e5nes
e5net.
en3ete
ene4t3j
e5nett
engs4
enier4t
enin5gr
eni4s
enk4l
en4kre
enk5tr
en5kwe
3enneg
e1no
e4n5oc
en3of
en3oli
enoot5
e4n1op
en5ops
en3ord
eno5s4
e3not
en3ov
en5sch
en3s4fe
ens3le
en4sli
en4smi
en4sna
en5spe
ens5pot
en4stij
enst5ijv
ens3uu
en4t4ac
en3tei
ente5st
en1t2h
en5tl
ent4r
ent5rol
en5tru
en3tw
e1nu
en3ui
en3ur
5enveer
3envij
3enzes
3enzev
e1o
e3oli
e3olo
e5om
eo3p4r
eo5ro
eo5t
e1pa
ep3ac
ep3app
ep3asp
ep5een
e1pi
3epid
epiet3
ep3ijs
ep3ijz
epis2
ep1j
e1pl
ep3lod
ep3lus
e1po
e4p3og
ep3oog
ep3ork
e1pr
e3pra
ep2s
eps3j
eps3l
ep4sta
eps5taa
eps5tal
e1pu
ep3uit
e3ra.
e1raa
er5aalm
er3aan
e4raap.
e4r1ac
e5raco
e3rad
er3af.
er3afv
e3rag
e1rai
e4r3all
er3ama
er3ana
e3ranc
e5rapi
er3app
e3rare
e1rat
er3atr
e3rau
e4r1av
er3azi
er5c
er3d2a
er5de
er5di
erd4o
er3d4w
e1re
e3re.
e3rec
er5editi
er5eers
er3eet
er3eff
er3eg.
er3egd
er3egg
er3egt
er3eie
er3eig
er3eil
er5eila
er5eind
er3ekw
e3rel2
e4r5emm
e3rend
ere4ne
eren5eg
er5enen.
eren5ta
er3eq
e3res.
er3esk
e3ress
erest5r
ere4t3j
e4r3ets
e2r3ex
erg2l
e3ri
e5rie
e5rif
e5rig
e5rij.
e5rije
er3ijl
e4rijz
e5rik
erim3a
er5inkt
er3ins
er3int
e5rio
e5ris
ermij5ni
e3ro.
e3rob
er3oc
e1rod
e1roe
eroe3t4
er5oev
er3of
e3rok
e3rol
er3oli
er3om
er1on
er3oog
e3rook
e3roos
er1op
e2r1or
e3ros
e5rose
e3rot
er1ov
e3roz
e3r
errie5tj
5errillat
er5tan
er5te
ert4h
er3the
er5to
erts5l
er5t4u
er1tw
e1ru
erug1
er1ui
erui5tj
e2r3ur
er3uu
3erwt
e3ry
e2sac
es3ag
es3al
es3ar
es3av
es4ch
4ese
es5emb
e4s3et
es3ex
es5hu
e5s4id
es3il
esis4
e3sjo
es5ken
e3sla
es3lak
es3lam
e3sle
es3lij
e3slu
e1sm
es3noo
e1so
es3ore
e1sp
e4spen
e3spl
es4poo
e5s4por
es4pr
e4sprie
espuit5j
essi4s
es4sn
e3staa
e3stap
es3tat
es3te
e4ste.
es5teer
est5ei.
es4tek
es5teli
es5temo
e4s5ten.
e5sterre
e4s5tes
e3s4tic
e4stig
e3stru
es3uu
e1sy
e1ta
e3ta.
et3aan
et3ac
et3ad
e3taf
3etag
e3tak
e3tan
et3art
e4t3au
e2tav
e3te
et3ein
4etel
et5emb
et3emm
et3emu
e5t4en
etens5u
eten5tj
ete3r4a
eter5sm
ete3s4t
et3hu
et3ins
e5tja
e1to
e5toc
et5oli
e3ton
e3top
et4or
e1tr
et5rec
et4rek
et3rim
e3tru
et3rui
et3sl
et4sla
ets5lap
et2s3n
ets3o
et4sp
et5spi
ets3pr
et4sta
ets5tan
et4stek
et5s4u
e1tu
et1we
eu5b
eu3c
eu5do
eu1e
eug4dr
eu2ka
eu4ler
eum3aa
eu2na
eun3tj
eu4rij
eu1ro
euro3p
eus4t
eu3ste
eu3tj
eu5tr
2euw
eu4w3e.
eu2w3i
eve5n4aa
3evenr
e1w
e5wa
e5wh
e5wi
ew3sk
1exam
3exeg
ex3in
1exp
ey3
e3ya
ey5sp
4eza
4ezen
ezen4s
eze5tj
3a
3d
dee4
3h
3r
ren4
3t
tee4
1
1
4
3c
1d
de3s
e4
en3e
3h
i1e
3k
1l
3na
nt4
nt5h
n3tw
3p
1ra
1re
3ri
1ro
ro3s
2s5
1t
ven4
ve5na
4venr
xis5
2f.
1fa
f3aanb
f3aap
f4aat
2fac
face2
f1ach
f4act
3facu
4fad
f3ang
fant2
fan4t3j
fants3
2f3ap
f3as.
fa5st
3fau
2fb
f1c
2f1d
fd4an
fdan5ste
fde5l
fde5sp
fd4i
f2d3in
fd5ins
fd3of
f3dra
fd3rek
fd3rol
f3dru
f3dw
fd2wo
1fe
fede3
f3een
5fees
feest5r
fee3tj
fel5aan
fe5laar
fel5fr
5fenda
fe3ran
fe4r3et
fe3ro
fes3
fe4t3j
2fex
3f
1f
4f1f
f5fe
ffs4
ff3sh
f1g2
fge3la
fge5n
fger4
4f3h
1fi
3fib
fi1ch
fi4e
5fig
2f3ijz
fil2m
4fint
5fir
3fi4s
fis5m
f1j
2f1k
4f3laa
f1laf
1flau
f3lene
f3ler.
fle2t
flet3j
f3lez
2flie
4flij
f4lip
f2lit
f3lok
fluit5j
2f1m
f1n
1fo
foe5d
2f3of
f3og
3fok
2f3oms
f4ona
fonds5l
fo3no
fon3t
f1oog
f3oom
2fo2p3
3f4or
fo5re
fort3j
fo3ru
fo3sk
5fot
2f3oud
f3ov
fox3e
2f5p4
fr2
f4ras
f3rek
fre4t3
frie4t
friet5j
f4rik
f4rod
2f1s
fs3an
f3sc
f5sch
f4s3cr
fsho4
f3sl
f4slap
f4s3led
fsleet5j
fs5mu
f3sn
f4so
fs3oe
fsoes5
fs3on
f3s4p
f5spe
fs4t
f3sta
fst3as
f3ste
fste4m3
f3sti
f3sto
fst3oc
f5stok
f4ston
f3stu
4ft
f1ta
ft3ac
f5tand
ft3art
ft3h
f1to
f1tr
f1tu
f5tui
f3tw
1fu
fu4ma
3f4un
fu3ro
2fv
2f1w
3fy5
2fz
4g.
1ga
3ga.
g4aal
5gaar.
gaar5tj
g4aat
2g1ac
4g3afw
2g3ah
ga3la
ga4l3ap
ga5lo
g3alt
3gam
3gan
gan5d
gan4s3t
gans5te
gans5tr
ganti4
g4ape
3gar.
g4are
3gars
4g3art
gar5tj
ga4s
ga5sko
ga5sla.
ga3sli
ga5slo
gas3o
gas3tr
gast5rol
3gat
3gaw
2gb
2g1c
2g1d
g5de
g4d3im
1ge
5ge.
ge3ad
ge3ak
ge5al
ge4ari
ge5aro
ge3au
4g3eb.
ge1c
ge3d2
ge5da
ge5de
ge5dr
ge5dw
gee4
gee5si
geest5r
geet3a
ge3f4
4g3eff
ge5g4
gege4s
g3eik
geit3j
ge5ka
ge5ke
ge5ki
ge5kl
gek4n
ge3kw
g4el
gel5as.
gel5ass
gel4d3a
gel5eg.
gel5egg
ge4leie
gel4o
gel5oor
gel3sl
ge3ma
ge3m4o
gems3
3gen
5gen.
ge3n4az
ge3ne
ge4n3ed
gen5end
gen4er
4g3engt
gen5k
4gensm
gen4tr
gent5ra
ge2ol
ge5p4
3ger
ge1ra
ger5aap.
ger4ap
ger5ape
ger5as.
ger4d3r
ge3r4e
ge5ree
ge5reg
ge5rek
ge4r5eng
ge5ri
ge1ro
ger4of
ger4on
ger5sc
ger4sp
4g3erts
ge3r2u
ge1s4
ge5sa
ge5sc
ge5se
ge3sh
2gesk
ge5sl
ge3sn
ge5so
ge5spend
ges5te.
ge5sto
ge5sw
3get
ge5t4a
gete4s
ge5t4i
ge3tj
get4r
ge3ts
ge5t2w
ge3ui
3gev
ge3x
1g
3g
2g1f
2g3g
2g1h
g4her
1g2i
gi4ee
gie4r3a
giet5s
gi1eu
gi2f
2gij
4gijz
gis5m
2g1j
2g1k
g1lam
1g4la4s5
g3lat
3g4laz
3g4le.
glee5t
g3len
2g3lep
g3les
3g2lic
g3lice
3g4li
g2lim
3gloe
g3lof
3g4lofo
3glom
4g3lon
g3lop
g2los
g4lot
3g2ly
2g1m
gmaat5j
2g1n
g3na
gne4t3j
gnie4t5j
g2nos
1go
go2a
go5b
go2do
god4s3
gods5t
2goef
2gof
4g3oh
4g3oli
go2ma
g3oml
2gong
4g1ont
2g3oor
2g3op
g5ops
4gore
gor2s
go3sk
gos3t
gou4d
goud5ee
2g3ov
2g3p
1gr2
3gra
g4rad.
5graf
gra2m
g3ramp
gras5
5grav
2g3red
gree4
greet3
2grem
g4ren
gren4s
gre4s3
3greu
grie4t5j
g5rijd
g5rijk
g5rijm
g5ring
2g3rit
2g3riv
5gron
groot5j
g3rou
g3roz
2g3rug
g3ruim
g3rup
2gs
gs1a
g5sal
g4s3ar
g3sc
gs4ch
g5scha
g2sci
g4sco
g4s3cr
g4s3ed
g4s3ei
g4s3ek
gseksa4
g4si
gs3ij
gs3in
gs3j
gs4ke.
gs4ken.
g2s4l
g3sla
g5sla.
g5slang
gs5las
gs5lec
gs5leg
gs5let
gs5leu
gs5lic
gs5lie
g3slo
g5sloe
gs5lok
g5slot
g4sma
g4sn
gs3na
gs3ne
g5s4no
g2s1o
gs3p
gs4pa
gs5pak
gs5par
g3s4pe
g5spee
g5spel
g5spet
g3s4pi
gs1pl
g3s4poo
g3s4por
g3sta
gs5taal
g4staan
gs3tab
g4st3ap
g3ste
g5stee
gs3tek
g5stel
gs4ten
gs5tend
g5ster.
gs5terr
g5sters
gs3th
gs4ti
g3stig
gs5tij
g5stof
g5stok
g4ston
g5stond
gst5ons
gs3tro
g3stu
g2s3u
gs5w
2gt
g1ta
g2t3ap
gtes4
gte3st
g1to
g1tr
g1tu
1gu
3gu.
gu5a
gu4e
2guit
gu4lu
g3uri
gus3
2gv
2g5w
1gy
2gz
2h.
haar4s
haar5tj
haf4t3u
ha2kr
hal2f
4halie
han5ga
han4sl
ha5o
hap5r
hap4sp
har4t3a
hart3j
har4t3o
hart5sl
ha2t3r
2hb
h3c
2hd
h2e
4hea
3hech
4hee.
hee4k3r
hee4lo
heeps5c
hee3tj
he4f
hef4fl
hei4tj
hei5tr
he4s
he2k3a
he2kl
he2k3w
hel5aard
he4l3an
he4l3ee
hel4m3a
hel4p3a
hemi3s4
he5ne
hen4kr
he5n4o
2heo
he2p3l
he4pr
4he3ra
her4aa
he4r3ad
he4rene
he4ri
her3ij
her3in
2herm
herm5eng
he3ron
her4p5aa
her4pr
hesis5
he2sp
2het
h3g
h3h
4hi.
hie2r3
hie4ri
hie4t5o
hie4tr
hiet5s
hij4s
hi2k3a
hi4m3ac
him4pl
him4pr
hin4t
hint3j
his4te.
hi3tr
h3j
2hl
h3lam
h3le
hlo3
h3loc
h3lok
h3lu
2hm
h4mi
2h3n
ho5bo
ho3ch
hoe4ker
hoe4s
hoe3t
ho4f
hof5d
hof3e
ho3g4
ho2ka
hon5dr
hon5g
ho1no
4hoom
hoor5tj
hoor5tr
ho2po
hop5r
hor5de
ho3ro
hort3j
4ho3ru
ho3sa
ho3sf
ho3sk
2how
2h3p
hpi4
2hr
hra4b
hri2
hris5
hroot5
4hs
h3sp
2ht
h4t3a
h4t5emb
h4t3enn
h4t3en5t
h4t3env
h4t3enz
hte2r
hter3a
hter5e.
hte4r3o
h4t3es
ht5esk
h2t5ev
ht3ex
h2t1h
h4tij
h2t1j
ht3o
h3too
ht1r
ht3ru
ht4si
hts3id
hts3in
hts3le
ht4sli
hts5m
ht4sna
ht4so
ht4spe
hts5taal
ht4s5tek
ht4sti
ht3u
ht5w
huin4s
huit5j
3huiz
hul4der
4hus
hut3j
h3w
hyl3
i3a
ia3f4
ia3g2
ia3k4l
ian3u
i5a5p
ia3t2h
i5av
i4b
i5ba
i5be
i5bi
i5bo
i5br
ica4p
i1cha
i1che
ichee4
i1chi
i1cho
i3chr
i5co
idde4r5a
id4e
ider4s
id2g
i3di
idie5t
id4o
i3dok
id3oo
id5op
id3re
id3ru
id2s
ids3e.
id4si
ids3l
ids3o
ids3p
ids5pa
ids5taa
ids5tek
id4sti
ids5tor
ids5tr
id3ui
idu3w4
id1w
ie3a
ie4d5ac
ied3w
i1ee4
i5eer
ie3fle
ie4g3al
ie4g3an
ie4gas
ie2gr
ie4k3ap
ie3ke
ieke3s
ie4kl
iek3li
ie5klu
ie4kn
iek5ond
iek4s5n
iek4sp
ie2k3u
ie4l3ei
ie5ler
iel5f
i3enc
iend5r
ien5sp
ien4sta
ien4st5o
ie4pap
ie4plo
iep5str
ie4pui
ier3al
ie3ram
ier3as
ie4rat
ier5enta
ie1ro
ier4sl
ie4sl
ie5sla
ie5slu
ie2sm
ies5me
ie2sn
ie2so
ies3oo
ie4spi
ie4spl
ie4s3po
ie3s4ta
ie5stel
ie4taa
ie4t3ak
ie5te
ie3th
ie4t3og
ie4t3oo
ie5troe
ie3twi
i3ety
ie3ui
i1eur
i1eus
ieus5te
i1euz
ieze4l5a
i4
i5t
i3
i5m
4i
i4ri
2if
if3aa
if3ad
if4r
if3ra
if4tan
ift5ang
if4tar
if3ui
i2g3aa
ig5aard
i4g5av
ig3een
igen5er
ige2s
ig3esk
ig3le
ig3lo
i4gn
i5gom
ig3ond
i5g4ro
igs4
ig3sk
ig3sl
ig5sm
ig3sp
ig3sto
i1h
i3i
4ij.
i2j5a
4ijd.
4ijdt
4ij5e
ije2n3
4ijf
ij3i
4ijli
4ijn
ij3o
i3jou
4ijsu
i4ju
ij3ui
ik3aar
ike3s4
i3ki
i4kl
ik4la
ik5lap
i5kli
ik3lo
ik3lu
i4k3n
i5k4ne
ik3og
i5kol
ik3ope
ik3ord
i4kr
ik4ri
ik3ro
ik3sj
iks5m
ik3s4p
ik5spa
ik4s5pi
ik1st
ik3wa
i4k1we
i3kwi
ik3win
i1la
il3aan
il3ac
i3lak
il3al
il3au
il2da
il2d3r
i3le
il3een
i4l3em
ile2t
ile3u
i4l3ez
i3li
il3ink
ilk4
il3kr
il5kw
illu3
i1lo
il3ond
i5loon
il3oor
il3oph
i2l3or
il3s2h
il5so
il5te
i1lu
im5alu
ima4s
imie4
im3op
im5pa
3impo
im4pri
im3so
i1na
in3aap
i4n3aar
in1ac
in5aker
in3ape
i3nas
i5nas.
in3ass
in5dac
ind5sp
1indu
in3ede
in3edi
in3eed
in3ert
3inf
in2ga
ing3aa
ing5aal
ing3ag
ing3al
5ingeni
ing3l
in4gr
ing3re
ing3ru
ing4s
ings5e
ing5ske
ings5n
i3ni
ini4
i4n3i4o
inis2
ini3sh
in4kaa
in2kn
inkt3r
inne3s
4i1no
i3noc
in3og
i2non
ino3st
1inri
in5sc
in5se
in3s4l
in3smi
ins4n
in3so
in5spo
in5ste
in5swi
in4t3ap
in5te
intes3
in5ti
in5t4r
i1nu
3inva
i4ny
i3o
io3a
io5b
ioen4s
ioes5
i5o3f4
i5o3g4
i5ol
i5om
io3no
ion4s5
io3pe
io3pr
io3ra
io3s
iot5j
io3tr
io3u
i1pa
ip3ac
ip3af
i4perw
ipe4t3j
i1pi
ip3j
i1pl
i1po
ip3og
ip3oo
ipper4s
i1pr
i4ps
ip4sle
i3pu
i3ra
i1r2e
ires4
ire3st
i3ri
i3ro
ir2s
ir4sc
ir3sp
irt4h
i3ru
i2s
i3sa
is3aa
is3af
is3ag
i5sal
is3ap
is1ar
i5sat
is3av
i4sc
i5scha
is3cr
is3ed
i4s3ei
is3ell
is3eng
is3ete
iset3j
i3s2fe
is3hi
is3id
i4sij
is3ja
i3sji
is3l
is5lag
is4lan
is4lot
is4lui
i4sm
is5ma
is5mi
is5mo
is5mu
i4s5n
i3so
i5soe
i4soo
is4oor
is3op
is3ott
is3p
is5par
is5pas
is5pl
is3t
is1ta
ist3ap
is5tas
is5ten.
is5tes
is4th
i4sti
is1to
isto3p
i3s4tr
is5tri
i3su
i5sy
4it
i1ta
itaat5
it1ac
itee4
it3een
i5ten
iten5tj
i3ter
ites4
ite3st
it1hu
it2i
i2tj
it3ja
it2je
it5jesg
i1to
it5oef
it3oog
it3red
it1ri
it1ru
it3sje
it3sle
it1sm
it1st
it5ste
i1tu
it5w
i1u
iu2m
ium3e
ive5ran
ive3re
i5w
ix3o
i3z
ize3s
ize5t
3
3a
1c
1d
en4
e5ne
llu3
3n3a
ns5m
3nu
3o
3ro
5sche
s5m
s3t
1t
ze3
4j.
jaar4s
jaars5t
1jag
jagers5
ja5mi
ja2n3o
jan4s3l
ja3pl
5jar
jart3j
5jas
j2d3aa
j4d3ee
jde4n3e
jden4s5
jdes4
jde5sp
j3di
j2d3o
j4dr
j5dra
jd3re
jd3ro
jd3ru
jd5s4l
jd4so
jd1st
j4d3u
jd3w
j3d4wa
5jeba
2j1ee
jeen3
j1en
je2n3a
je3ro
je4s3
5jesaa
5jesha
5jesho
3jeskl
3jeskn
jes5m
5jespe
je3spr
3jesr
3jess
jes5t
5jesv
5jesw
je2t3
je3to
5jeu
5jeva
j2f1a
j2f3ei
j2f3en
j4f3ij
j4f3in
jf3l
jf4la
jf5lap
j3flat
j4f3o
jf3r
jf4sc
jf4s3l
jf2sm
jg3laa
j4g3re
jg2s3
jg4se
jgs5l
jgs5m
jg5sn
jg4st
jg5s4te
j3h
3jic
jif5
j3ig
jis5m
j3j
4jk
j2k3aa
jke5ro
j2kij
j2k4l
jk5lak
jk5lap
jk5las
j3kle
j3klo
jk5lu
j2kna
j2k3of
j4k3ol
j2kr
jk3raa
jk3re
jk4si
jk2sl
jks5le
jks5m
jks5n
jk3so
jks3pr
j2k3ui
jk3w
j1la
j1le
jl3ink
j1lo
j2loe
jm3af
j5m4ar
jm3op
jn1a
j4naa
j3nag
jn5ak
jn4am
j3n4an
jne3s
jn3g4
j4n3im
jn3ink
jn1o
jn4s3am
jn2s3l
jn4sp
jn5spi
jnt4
jn5tr
job2
jol4e
jo5li
j3om
3j4on
jone2
5jonge
jonge4t
joor5t
jo3ra
j4ou
joy5
j3pa
j4p3ac
j2p3em
jpe3s4
j3pi
j4p3ij
jp3j
j3pl
jp3lam
j3po
j4p3or
jp3re
jp3ri
j3pro
j3r
js3a
j5se
j4si
j2s4l
j3sla
js5las
j3sle
j3sme
js5mi
j2s3n
j3sni
js3o
j1sp
j4spo
js3poo
jspoort5j
j5spor
j1sta
jst5aar
js3te
j3stei
j3s4tel
j4s5tem
js5tep
j4ster
js4tij
j3sto
j4stoo
js3tou
j4stra
jst5ran
jst5s
j2su
j3taal
jt3aar
jt1ac
j3tag
j3tak
j3tan
j3te
j4t1h
jt3jes
j3to
j3tr
j4t3ra
jt4rad
jt3rot
j1tu
jt3w
1ju
juit2
juits3
juli3
5jur
jus3
juve5
jve2n
jve3ra
jver4s
jve3t4
j1w
jze4r5o
2k.
1ka
3ka.
k4aat
2k1ac
3kace
5kad4
kade4t5
4k4af.
2kafr
k3agen
k4ake
4kakt
4kalb
5kalf
kalf4s
kal4k3a
5kalv
2kamb
kamen4
kam4pr
kan5d
2kang
5kani
5k4a3no
kan4t3j
5kap.
ka3pr
kap3s
kas4pe
kas3tr
kast5ra
kas5tro
ka4t3aa
ka4t5ale
ka4tan
kat1j
k3atl
ka4t3og
ka4too
ka5t4r
kat3s
4k3aut
2k3avo
5kay
2kb
2k1c
2k3d
1ke
4keen
keep3l
keers5to
kee3tj
k4ei.
k4eie
kei3s4
3ken.
ken5as
ke3ne
ke4nep
ke2n3o
5kens
kens5po
kepie5t4
5ker.
ke5rij
ker4kn
ker4kr
kerk5ra
ker4ku
ker4kw
ker4n3a
ke4r3o
5kers
ker4sla
ker4sm
4k3erts
ke2st
ke3sta
ke5s4tel
kes3tr
3k2et
5ketel
ke2t3j
ket5sp
4ketu
3k2eu
4kex
2k1f
2k1g
2k3h
1ki
4kied
4kiep
kies4t
kie4t3j
k3ijs
2k1ijz
ki5kl
ki3na
4kindu
kin3en
ki4n3es
5king
2kinr
2k3ins
kio4
ki2p
kip3l
4k5j
2k5k
kker4s
kkers5te
kke3s4
1k2l4
5klac
kla2p
5klass
k3last
4klat
3k4lau
5k4led
4kleer
4k5leg
k3lek
klemme5t
k3len
4klera
k3les
5k4leu
4k3lic
k3lij
kli4me
k4lis
4klod
k3loka
k3lone
k3lood
5kloof
k3lope
5klos
2k1loz
4kluih
k3lus
2k1m
1k2n
kna4l
knas5
2k3nem
kni2
5knol
k3noot
k3note
2knum
1ko
2k3oct
ko4e
koe4ket
koers5p
koe3tj
k4offi
koge4
5kogr
kol2e2
kolen3
2kolm
ko5lo
3kom
ko4m3a
komitee5
3kon
kon4t3r
2k3oog
koon5
koor5tj
k4o4pl
3kopt
2k1org
2k3ork
korres5
kort3o
ko3ru
ko4s
4k3os.
4koss
k4ost
kot5j
4k3ov
4kox
2k1p
kpren4
1kr4
3kra
k3raad
kra4b
4k3rad
k3rand
4krat
2k1rec
kree4
kreet3
kre2p
k3rijk
2krol
kron5t
2k3rou
3k4ru
kru4l
2ks
ks3ad
ks3af
k5sap
k4s1ar
ks3as
k5s4er
k4s3in
k3sla
k4slan
ks4le
ks5leg
ks3li
ks5mo
k2s3n
ks4no
k4snu
kso4
ks3on
k4s1op
k4s3pa
k1spe
k3spi
ks3po
ks3pru
k3spu
ks4t
k1sta
k3ste
k4st3ed
k4stele
ks5tent
kste4r
k3sti
k3sto
k4ston
k4s5tre
ks5tri
k3stue
k2su
2kt
k1ta
ktaat5
kte2n3
kter4sp
ktes4
kte3st
kt1h
k4t3in
k2t3j
3ktl
k3to
4ktpa
4k1tr
k1tu
3ktv
4ktvi
1ku
kui2f
3kul
k3up
3kus
kut3j
2kv
k1wag
5k2wam
3k4was
2kwed
kwee3s
2k5weg
k1wei
2k1wer
5kwes1
k3wijz
k4wik
2kwim
2kwin
2k1wo
3ky5
2kz
4l.
4laaf
4laand
laars5tek
laar5tj
laats5tr
2lac
3lach.
3lache
l4aci
3lact
la2d3a
la4det
2ladj
2la2dr
la2du
3l4ae
laes4
la2fa
la3fl
lafo2
4lafs
la2ga
la2g3o
la2gr
lag3ri
la4ki
la3kl
l3akti
2lal
3lald
la5lo
la4mo
lam4p3j
lamp3l
2l3ana
3land
lan4da
land5aa
lan4dr
land5ra
land5re
laneet5
la4n3ek
5lange.
lan4gr
lan4ka
lan4k3l
lank3w
lan4sl
lan4t3j
la4pa
3lapj
lap1l
lap5r
la2p3u
2l3arb
4lart
l4as
las3a
la4si
la3te
la4t3he
la4t3ro
la3un
l4auw
lava5s
l4az
4lazi
lber4
lbert3
l1c
4ld
ldaat5
ld3ac
ldak4
l3dar
ld3ari
ld3art
ld3ei
l4dom
l2d3os
ld3ov
ld3ram
l2d3re
ld3s4a
ld5sl
ld3sm
l2d3uu
ld1w
l4e.
le2a
le3ad
le3an
le3at
lee4
4leekh
leem5ac
3leen
4leep
lee5ro
lees3p
lees5tr
lee3tj
le3fl
legas5
le4g3ek
4leig
lei5sc
le5ke
2leks
le4kw
le4lim
lemme4t
l4en
5len.
len3ad
le4n5ak
len5as
3leni
len5sl
len4s3p
len4tr
len5tre
le5pe
3le5r4a
ler4e
le5rei
ler5g4
le3ro
lers4
l5erts
l5erv
les3ta
les3ur
le3t2h
le5t4i
le4t3ro
4l3etu
leu3ko
5leun
leu5ste
5leuz
leven4s5
4l3exc
lexis5
3l
lf3ac
l3fag
l4f3an
lfbe5
l2f3ei
l2f3el
l4fend
lf5ende
l4fin
lf3lak
l3flo
l4fo
l5foe
lf3ol
lf3on
lf3op
l5for
l5fou
lf4r
lf5raa
lf5ram
l3fran
l3fre
lf5rij
lf5ro
l5fru
lf2sa
lfs5ei
lf2sm
lf4spo
l2fu
l3fui
lf3uu
l1g
l5gaar
l2g3af
l3gla
lg3on
lg3re
l3gru
l1h
1li
3li.
3lid.
li3da
3lied
lie4gr
li3enn
lies3p
lie3st
lie5ta
3li4
li3g4a
lij4k3o
lij4m3a
5lijn
4lijp
3lijs
lij4st
4lijt
4l3ijz
li2ko
li5kr
lim4p3j
5lin.
lin4da
li5ne
l4ing
lin5gr
link3a
lin5ke
4linkt
4linr
4lins
lin4t3j
li2p
4lipj
li5sa
li5se
lis5m
l3isw
li1th
3liv
l1j2
lk3af
lk3alb
lk3ank
lk3een
l4kei
l2k3em
l4k3ep
lk3laa
lk3lag
l4k3lev
lk3ont
l2k4ri
lk5rij
l2k3ro
lk2s
lk4sa
lk4se
lks5m
lks5ta
lks5tel
l4k3uu
l4kw
lk3wi
2l1l
l3la
lla5t4
l3le
lle5k
lle4sp
l5li
lli4a.
llo3s
ll3ov
2l1m
lm3art
lm3ed
l4m3ind
lm3oli
lm4op
lm5opn
l3n
lni4
loe4da
loed3r
4loefe
2loes
3lo
lof5d2
lof2s
lo3go
5logr
lo4gre
log4s
lo4kar
lo2kl
lo2ko
3lol.
3lold
lom4p3l
4loms
4l3omt
l3omv
3lon.
lo4na
lon4gr
lont3j
3look
3loo4n
2loor
l4opa
2loph
2l3opn
4lops
4l3opw
l4or.
4l3org
lo3ru
lo4sc
lo4sp
lo5spe
lost4
los5tr
lo2t3h
lot5j
2love
lox3e
lo3ys
3loz
4l1p
l3pa
lpe4ni
lper5sp
lpe3s4
lp3of
lp3on
l3pot
lp5ram
4l3r
lrus5
2ls
l4s3aa
l4s3ad
ls3ag
l3sak
l3sal
ls3an
l4s3ep
ls2j
ls3ja
ls4ky
l4s3laa
l2s3le
l2s3li
ls4lin
l3smee
ls5mo
l4so
l5soe
ls3of
l5sol
l5som
ls3on
ls3or
l1sp
l5spe
lspee4
ls3pol
l5spor
l2s3pu
ls4t
l1sta
l1ste
l5ste.
l4stele
l5sten
l4s5term
l3sti
l1sto
ls5tou
l5straa
ls5trak
l5strat
l2su
4lt
l1ta
lt1ac
l4tam
l5tame
lt3h
lt4han
lt4he
l3thu
l3tj
l1to
lt5oli
l2t3ov
l5tr
lt3sl
l1tu
lt3w
lu1e
3lui.
3luid
5luih
lui5ste.
4luit
lu3ka
5lu3na
lu1o
lu3sta
lut3j
lve3s4
lvi4s
l1w
1ly
ly5st
2m.
1ma
5m4a.
5m4aat
ma4cl
mae3
2maf
m5afl
5m4ag
5maj
ma3ka
ma5l4a
mal5ent
3man
man3ac
man4se
man4sn
man4so
mans3p
man4st
mans5ta
man5ste
mant4r
ma3pl
5marc
mariet5
5mark
mar3s4h
mar4s5t
mart3j
3mas
ma3s4p
ma5str
ma5ta
m3atom
m3atoo
mazig5er
2mb
mbos4
mbo3st
m1c
2md
mdis5
md3so
1m2e
3me.
me5d
m4ede
mede5l
mede5s
mee5re
mee5r4i
5mees
meest5a
mee5str
3mega
5mei
mei2n
3mel
mel5as.
5melk
mel4kr
5melo
3men
me3na
men5k
men3sm
men4t3j
men4tu
men4t5w
me3p4j
me4r5aak
me4rad
mer3ak
mer4am
me3ran
me5re
merg4s5
meris4
5merk
mer4ka
mer4kl
mer4kw
me3roo
me2s
2me3s2h
mes5m
me3so
me3sta
mest3r
me5te
5me3t4h
me5tr
me3us.
3m
3m
3m
2m1f
mfe4r
mfi3
mfoor5
2m1g
mgaat5
mgang4
mger4
2m1h
3m2i
miaat5
5midd
mie5kl
mies4
mie3st
mi4
5mig
mij4ni
4m3ijs
4m3ijz
mi3lo
4m3inr
4mins
4mint
5misd
mis5m
mi4so
mi4st
mi5sto
mis5tr
mi1tr
2m3j
2m3k2
mkaart5j
2m3l
2m1m
mmi3sl
m1n
1mo
5moe.
5moed
moed4s
5moe
2moef
5moeh
moe2s
moe5ste.
moets5
5mog
5mole
moli5
mol4m3a
4m3omv
mo3n2a
mond3r
mo3no
mon4so
5mooi
moor5tj
2mop
m5ope
mo3ra
mo5r4e
mo3ro
mor4s3p
5mos3
mo3s4ta
mo3th
mot5j
4m3oud
5mouw
4m1p
mp3ach
m4p3af
m3pl
mp3leg
mp3lei
mp3ler
mp3lu
m4pol
mp3oli
mpo2t
mp3rec
mp3red
mp3rin
m3p4se4
mp3sh
2m3r
2ms
m3sam
ms3ap
ms3ar
ms2j
m3sje
m5sla
ms3len
m5slo
ms5nee
ms3oo
ms3or
m3s4p
ms5pot
ms4t
m3sta
m1ste
m1sti
m1sto
2mt
m1ta
m3th
m1to
m1tr
m1tu
1mu
5mun
5mur
5mus
mus5t
5mut
5muu
5muz
2mv
mvan4
2m1w
3my
2mz
mze2t
4n.
3na.
1naal
5n4aam
2n1aan
2naap
4n3aard
5naars
naar5tj
5naat
2nac
nacee5t
3naco
nad4
n4aden
5nae
na3er
2n1af
n4a3g4
5nai
5na
n4a5ke
4naker
na3k4l
3n4ale
4n3alf
3n4ali
nal5k
3nam
n4ami
na3na
na3ne
3n4ani
n5anj
n3ank
5nant.
nan4t3j
2nap
na4pa
na1pl
na3pr
nap3s
4n3ara
2n1arb
2narc
5nares
narie5t
n3ark
2n1arm
2n3art
na3s4
3na1sa
na1sp
nas5te
5nat.
2n3atl
nat2r
na3us
2naut
2nav
2nb
nboot5
n1c
ncen5
nch3tr
2nd
n3da
n5daal
nd3aas
n4dac
nd5adel
n5dale
nd3alm
n4dap
nd3art
n4d3as
n4d3az
nd3edi
n4deg
nd1ei
n5del
nde5lev
n5den.
nd4er
nder5aal
nder5al
n4d5erec
nder5in.
ndes4
n4d3ete
ndiet5j
n4d3ijs
nd3ins
nd2ji
n2d3of
nd5olie
nd5omd
nd3oog
nd5oorl
n3dov
n3dr
nd3rap
nd3rat
n4d3re
nd4ren
ndre3u
n5drev
nd3rot
nd5slo
nds5ma
nd3sme
nd3soo
nd3sp
nd4s5tal
nd3uri
nd1w
ndy5
1ne
nebe4s
2nech
ne5dw
nee4
4need
4n1een
nees3
nee3tj
neg2
nege4n
ne1gl
ne5g4r
2nei
n4ei.
n4eie
n4eig
4neis
ne4kr
4n3ela
3n4eme
2n3emm
3n4en.
4n3enc
n4end.
nen5k
n3enke
ne2n3o
ne4p3ol
5ner.
ne1ra
5n2ere
4nerf
ne4r3id
ne3ro
ner2s
3nes
ne3sta
nes4tei
ne5stek
4neter
5netj
net5sp
4neum
ne3um.
ne3ume
ne3ums
neu5ste
3n
4n3f2
2ng
ng3ad
ng3ak
n4gap
n2g3ar
nga5sl
n5ger
nge4rap
nge4ras
nger5sp
ng3ij
n4g3ins
ng3le
n3glis
ng3of
n2g3on
ng3ore
n3gr
ng3rad
ng3ram
n4g3ras
ng3rat
ng4re
n2g4ri
ng5rie
ng3rij
ng3rok
ng3roo
ng2s
ngs3e.
ngs5le
ng4slo
ngs5loop
ngs5m
ngs1p
ngs5pa
ngs3tr
ng3uit
2n1h
1n2i
nie5k4a
nie5kl
nie4tr
3nieu
ni4gee
ni4g3r
nij3k
4n3ijz
nika3
3nim
2n3in.
4n3ind
3ning
5ning.
ning3r
ning5re
nin2k
n3inkt
2n3inr
2n3ins
4nion
5nise
ni4sel
nis5m
ni3th
ni1t4r
ni5ts
5nitz
5niv
n1j4
nje5sc
nje3t4
4n1k
nk3aan
nk5aard
nkaart5j
nk4ab
n2k3af
n4k3ak
nk3ana
n4k3asp
nker5ku
n4kerw
nk3lad
nk3ler
nk3lod
n2k3na
n3kne
nk3not
n2k3of
n4kog
nk3oge
nkoot5
nk3red
nk3rek
nk3roe
nk3rol
nk3sn
nk4s5o
nk3s4p
nk1st
nk4tr
n4kw
nk3waa
nk3wez
nk1wi
2n3l
2n5m
nmazi4
n3n4
nnee5t
3no.
4n3oec
2noef
noes5te
noet3j
noet5s
n4of
2n5ofe
1nog
no4gal
4n3oge
no3ia
1nom
4n3om.
3noma
3nomi
2n3omw
2n3ond
2n1ont
4n3onz
4noof
2n1oog
n4oot
2nop
n4opa
n1opg
n3opn
no4por
n3opv
n4ora
2nord
n4ore
2norg
no3sf
no3sp
n4ot
not5j
4n3ou
2nov
2n3p
npoort5
n5r
4ns
n3saal
ns3ad
ns3af
n3sag
ns5ak
n3sal
ns3alp
n3sam
ns3an
n3sapp
n3sar
n3sas
ns3av
n3s4c
n5sca
n5sci
n4s5co
n4s5cu
n4sed
ns3edi
nsee5t
n4s3eg
nsei5
n5sen
ns4fee
ns3ja
n3sjo
n5slag
ns3lak
n5slap
ns3lat
n4sle
ns3led
ns3lie
n5s4liep
ns3lop
ns5mac
n3sme
n5smij
ns5mis
ns5moe
n3smol
ns5mu
ns3nod
ns3noo
n1so
ns3of
n4sog
n5sol
n4som
n5som.
n2son
n3sp
n4s3paa
ns3pad
n4spl
ns3por
n4spot
ns4t
n1sta
n4staak
n3ste
n4st3ei
n5sten.
ns5tent
n3sti
n1sto
nst5oef
nst5oor
n5stru
nst5uit
n4sui
ns3uil
n4suu
n5sy
4nt
n3ta
n5taal
n4t5aard
ntaar5tj
n5tab
nt3ach
nt3ad
nt3aga
n5tal
n4t3art
n5tat
n5teg
n2tei
n5tel
nte4lo
n5tem
n5t4en
nte5re
nte4st
nte5ste
n5tev
nt3ex
n3t
nt3ha
n4tho
n5thol
nt1hu
nt4i
nt5ijz
nt5inw
nt4jo
n1t4o
n5toe
nt5oge
n5to
nt5oli
nt5oms
nt5oog
ntoor5
nt5opn
n3tr
nt3rec
n5tref
nt3rei
n5trem
n4t5rij
n5troos
nt3ru
n5tsj
nt1sm
nts5pre
nts5tan
nt5ste
nt5sto
nts5tro
n1tu
nt5uit
nt3w
nt2wi
nt4wis
3nu.
nu3a
nu3en
nu3et
2nui
4n3uil
nu2lo
n3ult
3num
4n3uni
2nur
5n4uri
nu4s
nus3o
nut3sh
2n3uur
nu4wi
nu5wing
2nv
nval4s
4n1w
nx3
nx4e
3ny
n3yi
4nz
nzet5s
3
o1a
o2as
oas3t
o3av
o4b
o5ba
obalt3
o5bi
3obj
o5bl
ob3oor
ob3or
obos4
ob5ov
o5br
o3cha
o1che
o1chi
o1cho
o3chr
o3chu
ocos4
oc5t4
4od.
oda3g
ode4m5o
o5d4e2n
ode5sp
od3on
o5doo
od3op.
od3re
od5slan
od5sli
od5slo
ods5m
ods3o
od4spr
od1w
oe4d3aa
oed3ar
oe4d3on
oe4dr
oed3ri
oed3ro
oe2d3u
oed3w
oe4f3a
1oefe
oe2fi
oef3la
oef3le
oe4f5o
oe2f3r
oege3l
oei5s4
oek5erk
oe2k3l
oe2k3w
oe3l2a
oe4lac
oel4ak
oe4l3ap
oe4l3ei
oe4m5ac
oeme5tj
oe5n4e
oe2n5o
o3eo
4oep
oe4plu
oe2p3r
oe2p3u
oe3ra
oe4r3aa
oe4r3al
oe4rau
oer5ei.
oer3o
oer5om
oer4sl
oer4sn
oer4sp
oes3a
oes3li
oe4s3o
oes4t
oe3sta
oes5ter
oes5tig
oes5tin
oe3sto
oe4taa
oe4t3an
oe4tei
oet3h
oe2tj
oe4tra
oets3p
oet3w
4o
4ofa
of3ar
of4d1a
ofd3ei
of2do
ofd3on
of2dr
ofd3re
of4d1w
o3fe
o3fi
of3l
of4la
o3f4lu
of3om
o3fon
o3foo
of1r
of2sa
of4si
of4s3l
of4sp
ofs5pl
ofs5tr
oft2s
of4tu
oft3ur
oft3uu
og3al.
og3ap
4ogee
ogel5ei
ogen5t
1ogig
4og1l
4og3n
o4g5ne
og4op
ogs5e.
og4s5l
ogs5m
og3sp
ogs4pr
ogs4t
og5ste
og3sto
og4st3r
o1h
2oi
oi4a
oi2a.
oi1e
oile4
o3ing
oi3s4
oi5sc
ois5m
oist4
ois5tj
oi3tj
o1j4
oj5k
o3kaa
o4k3aas
okaat5
ok3ab
ok3ag
o3kal
ok3an
ok3ar
o4k3az
ok3een
oki2n
o3kla
ok3let
o2k3li
ok3lo
ok3lu
o2k3n
ok3ol
o2k3op
o2k3ou
o2k3r
o5k4ra
ok3sa
ok3sp
ok4spo
ok1st4
okter4s
ok3uu
ok3w
4ol.
o1la
ol3ac
ol3ap
4old
o1le
o3le.
ol1ei
ol3eks
o3len
o3ler
ole1u2
olf3l
olf4s
olf5sl
ol2gl
ol2g3o
ol2gr
olg3ri
o5ling
o3lit
ol4k3aa
ol5kaf
ol5ke
ol2kr
olks1
ol5kw
ollie4
ol3mo
o1lo
o5loc
olo3k4
ol4om
o2l3op
olos3
ol3ove
ol4p5ra
ol1sj
ol3sk
ol3sl
o1lu
ol3ui
ol3un
ol3ur
4oma
om3ac
om3af
om3eg
om3ela
o5men.
omer5k
o3me4s
ome5sp
om3ez
om3ins
om3int
4omm
om3op
om3pa
om4p3la
om3ui
4omy
o1na
on1ac
o3nag
o3nal
on3am
o3nat
on3au
2ond.
ond3ac
on4ded
ond5eng
onde5ras
onde5st
on4dij
ond5om.
on4dr
on5dra
ond5re
ond3ro
4onds
o2n3ec
on5ei
on3ekl
on3eng
one5ste
on3ga
on4gaa
ong5aap
ong5ap
4ongen
on4gri
ongs5k
o3ni
on4in
2onk
on4k3ap
on3k4i
on5kw
onne5st
on1ov
on3sm
on2s3n
on4spe
on1st
on5su
3ont1h
on5ti
on4tj
on4tog
on4too
on2tr
on5tu
on1ui
o4o2
oo3c
oo4d
ood1a
ood1e
ood1r
ood5sl
ood5ste
4oof
oo4g
oog3a
oog1e
oog1r
ook5s
ool1a
ool3e
ool5f
oo4l3i
ool5k
ool3o
ool3u
oo4m
oom1a
oom3o
4oon
oon3a
oon5tj
oop1a
oop5e
oor3a
oor4daa
oor1e
oor5i
oor5m
oor1o
oor3sm
oor5to
oo4t
oot1a
oo3te
oot1h
oot5o
oot3r
oot4sl
o1pa
op3aar
op3ac
o4p3ak
o4p3an
o2p3as
op3at.
op3atl
5opdr
o2p3ee
op5een
op5eet
o2p3ei
op3ete
op4her
o1pi
o2p3id
opie5t
op3ijz
op1j
op3l
o1po
o3poe
op3of
o4p3oo
op3ord
op3ore
op3ov
op3r
op5rak
3o4pru
ops4l
op3sme
op3sn
op5sto
4opt.
o1pu
o4py
o1ra
or3ac
or1af
or2do
or4doo
or4d3or
ord3w
o1re
or4en
oren3a
or2g3l
or3g2n
o1ri
or3ins
or4m3ac
or4n3ac
or3no
or5oe
oroes5
or1on
or1oo
or1op
or4p3ac
orp4sc
or5se
or4s5k
or4t3ak
orte5n4a
or4tev
or4tj
or4t3oo
or4tor
ort5sp
ort1w
or1u
or3ur
o3ry
os3aa
os3ap
o3sar
o3s4c
o5sch
o5sco
o5s4e
ose5st
os2f
o3s4fee
os2ko
o2s3l
os5m
o2s3n
o1s4o
os5ol
os3p
os4pe
o5spect.
o5specte
os5pek
os5per
os4po
o2st
os3taa
os5taal
os5taar
ost3ag
os3tal
o5s4tas
os4tat
os3te
os5te.
o3st
os3to
ost3ov
ost3re
ost3ri
o3stro
os5tru
os3tu
o3sy
o1ta
ot3aar
ot3ac
o2t3ak
o5tam
o4t3ap
ot3as
o5teb
ot3ed
o5tee
o5tem
o5ter
ote5ri
ote4s5ta
o1th
o3t4hi
o2tho
ot3hu
o4t4j
ot5jo
o1to
o2t5ol
oto3p
ot3ri4
o3tro
ots3a
ot5si
ot2s3l
ot5so
ot4s5pa
ot4str
o1tu
ot3ui
o3tul
ot1w
ou3a
ou5b
ou1c
ou4d1a
ouden5t
ou1e2
ou3k4
ou4re.
ou4res
ou2ta
out1j
ou2t3o
out3r
out3sp
ouw5do
4ova
o5ve
3overg
2ovi
ovi5so
o1wa
o3we
o3wi
own3
o3wo
ow3r
o4x
1oxy
oys4
o3z
oze3s4
3l
4p.
3paal
4paan
paar5du
paar5tj
2pac
pacht5s
p2aci
5pad.
pa2d3r
3pag
pag4a
pa3gh
pa2k
5pak.
pak3a
p4ake
3pakk
3pale
paling5s
pal5kl
palli5a
palm5a
pal4mo
pa3na
pa4n3ad
4pank
pan3o
pan5sp
pan4t3r
3pap
5papi
pap5l
pa3pr
4par.
3para
par3d4
4parr
par3th
3parti
part3j
pa5ru
pas3
pa3sa
pa4sc
pa3so
4pat.
pa5te
2patl
3pau
4p3aut
1pav
2pb
p1c
2p3d
1pe
pe3au
3peb
4peci
5pectu
5ped
pe5de4
pede5r
pedes3
p4ee
pee4l
2peen
3pees
peet3
peet4j
3pe
3peg
pe3gl
3peh
p4eil
pek3ee
pek3la
pe2k3n
3pekti
pe4lak
pe4l3ee
pel4i
pe3lo
2p3emm
3pen
5pen.
pe4nam
pe5nan
pen5k
5pens
pen5sm
pent4
pe4nu
3pep
4pepi
pep3s
3pe1ra
5peri
per5ijz
peri3s
pe3ron
5pers
per4sp
pers5pa
per5sti
4perwt
5pes
pe5sa
pe5se
pe3sta
pe3sto
3pet.
5peter
pe3um
3pex
3pez
1p
3p
2p1f2
2p1g
pgaat5
pgei4
2p1h
3p4his
pie4tj
pi2ga
pi3gl
5pij.
pij4li
3pijn
3pijp
pij4p3a
pij4p3l
4pijs
pij4tj
2pijz
pik3l
pi4ko
pi4nas
4p3inj
pin4k3r
pin4t
pi3sko
pis5m
pis5ta
pit3j
pit4sp
p1ja
p3ji
p1jo
2p1k
pkaart5j
p2l2
4p3la.
plaat5j
pla3di
pla4kl
4plam
p5land
4p3lang
3plant
p5lap
3p4las
pla4tr
plee5tj
2p5lep
p3les
p4lex
2p3lig
2plij
p5lood
p5lop
2p1m
2p1n
p3no
p4oe
3poei
3poe2s
poe4s5t
poe3tj
3poez
3po
2pof
po2k3i
po4ko
pol5ka
3pom
pome3
4p3oml
3ponds
3pone
pon4sm
4poog
p4ool
poo3li
4poor.
poor5s
poot5
3pop
po3pe
po3pl
4pori
2pork
po3ro
5portef
por4t5ra
3p4os
po3sf
po3sk
pos4taa
po4ta
po4tes
3poth
3poti
pot5j
4pov
2p5p
ppe5li
ppe4n
ppen5e
pr4
p4ra
3pra.
praat5
p5rad
3prakt
4pram
3prao
p5rap
3prent
prent5a
pren4t5j
3p4ret
preu5s
p3riek
3pries
4priet
pri5m
5prins
3p4rio
5prob
3proef
3proev
5p4rof
p4rog
5prop
pro5pa
pros5t
3prov
pruit5j
pru2t
prut3o
2ps
p2sa
ps3af
ps3as
ps3at
ps3au
p3sc
p5schi
p4sco
ps3le
ps5ma
ps5mi
p2s3na
p1so
ps3of
ps3on
p3sop
p1sp
ps4pe
p1s4t
p3sta
p5stat
p3ste
p5ster.
ps5term
p5sters
ps5tor
3psy
4pt
p1ta
p5ti
p4t3j
p1to
p1tr
p1tu
pu5b
pu3c
puil3o
pul4st
3pun
4pun.
5punt
punt3j
put3j
put3r
4pv
2p1w
1py
py5l
5pyleen
4pz
pzet5
1q
qu4
qui3d
4r.
r4a.
r2aa
2raan
3raar
5raar.
4r3aard
5raars
raar5tj
raat5jes
2rac
5rac.
r4aci
4ra5da
3radb
rade4r5a
ra3di
4r3adr
3rads
ra3fa
2r3afd
ra4f3on
ra3fra
ra3gn
ra3io
ra4
ra3k4l
ra4kr
ra5kru
4r3ala
ra4l3ee
4r3alf
2r3alm
r3alt
r5ameu
4ramn
4rana
r2anc
rand5sl
ran4g3o
ran4g5r
rank3w
rans3p
3r4anti
r3antw
ra5o.
ra4pl
rap3r
2r3arb
r2are
2r1arm
r3arr
4r3art
ra4sk
ras5m
ra3sth
ra5stheni
ra5str
rat5sp
r1c
r4che.
r4ches
r4chet
r5co
r1d
r4d3act
rd3ama
rdan5ste
rd3ar
r4das.
rd5elas
r4denv
rd5enve
rde5ra
rder4s
rde5sp
r3do
r4dol
rd3oli
rd5olie
r4dont
rd3oos
rd2ro
rd3rod
rd3rol
r3droo
rd5sla
rds3le
rd3so
rd3su
rd1we
rd5wo
re2am
3reda
3redd
rede4s3
4rediti
3redu
r4eed
ree4k
4r1een
ree3n4e
4reers
ree3tj
re3fa
5re1fl
4reg.
4regd
rege4s
4regg
5regi
3re1gl
4rego
4regt
reid5sta
4reie
4reil
4reind
reis4t
5reiz
re4ka
re2k3l
re4kn
re4k3ur
re4k3uu
2rek4w
4rekwi
reld3o
rel4dr
rel5ei.
re5lui
re4lur
remie5tj
2remm
5r4en.
re4naa
re4n3ar
3renb
r5endert
ren5dr
re5nek
r5e5nend
5renenk
ren3ep
renep5e
ren5erv
2r1eni
ren3ko
re3n4o
re4n5of
re4n5oo
3renti
r3entw
re5pa
4req
4r1erf
re3r2o
2r3ert
4r3erv
2rerw
re3sa
resi3
re3s4ko
re2sl
5re4s3p
re5spoo
re2st
res5tor
res3tr
re5tak
re5t4i
re4t3og
re4tri
reuk5s
5revo
4rey
3r
r4f3aa
r2f3ag
rf3al
r3fe
r4f3eng
r3fi
r4f3lag
rf3lat
r1fle
r4fli
r3flu
rf3op
rf4ov
r1fr
r2f3re
rf2s
rf3sm
r4f3ur
r4f3uu
r1g
rg4al
r3ge
rge2a
r4g3een
r4g3ei
rg4eis
rge4l5aa
r4g5erep
r5gew
rg3ij
r4g3lu
rg4ov
r5grij
rg4ro
rg1s4
rg2s5m
r3h
ridde4
r4ie
rie5kl
rie5pl
ri1eu
ri3fl
ri3fr
4rijl
rijs5l
rij5ster
rij4tr
rik4o
rik5r
ril3m
ri4maa
rim2s5
r4ing
4r3inh
rin4kl
r3inko
4rinkt
ri3no
4rinr
4rins
4rint
ri3sc
ri5sco
ris5m
ri5so
ris5ten
rist4j
ri4s5to
ri3tr
r1j
rkaart5j
rk3ang
rk3art
r3ke
r4k3ei
rke4n
rken4s
r4k3eze
rk3iep
r4k3ink
rk3lat
rk5leer
rk3let
rk3olm
rkoot5
rk3oss
rk3rat
r5kri
rk5roos
r5kru
rk1s
rks4f
rk4s3l
rks4p
rk2t3r
r1kw
rk3waa
r4kwat
rk3wet
rk3win
r3l
rlos3
r5lu
r1m
r3ma
rma3f
r4m3ap
r2m3eb
r2m3eg
rmer3a
r5mi
r5moe
rm3ont
rm3op
rm3s4a
rm4sl
2r1n
r3na
rn4aa
rn5aan
r5n4am
r4n3ap
rnee5t
r4n3ene
rne4t
rne5ta
rnet3j
rn5oof
rn3ops
rns4
rn5sp
rn5tj
r3nu
ro5be
r4och
ro3d4o
r4oe
4roeg
roe4g3r
roe4p3l
roe4rei
roes5te
roet3j
3ro
roge4s
3rogy
1ro
r4ok
3rol.
ro2l3a
rol3g4
4roli
r4ome
r4on.
ro2na
ron3ad
ron4d3o
ron4d3u
r2one
ron4ka
r2onn
r4o1no
r2ons
4ront
ron4ta
ront3j
ron4t3r
ro3nu
3roof
2r1oor
4rop.
ro4paa
ro3pe
rop4la
ro5po
rop5ra
rop3s
r2opt
ro3ro
ro3sf
ro3sn
ro4sp
ro3ta
ro5te
ro3t2h
rot5j
r1oud
3rout
4roxy
r1p
r3pa
rp3ank
r3pe
r3pi
r4p3j
rp4lo
rpoort5j
rp3rec
r3psa
rp2st
2r5r
rre4lei
rre4l3u
rre3s4p
rri3er
rrie4t
rron5k
rroot5
2rs
r1saa
rs3ad
rs4ag
r3saks
r3sal
rs3alm
rs5am
rs3ap
rs3ar
rs3ass
rs3av
rsboot5
r3sc
r4sco
r4sec
r4s3ek
rs1ex
r4s3ez
r1sja
r3skat
r3s4kie
rs5ku
r5slag
rs3lat
rs3leg
r5slep
r5sleu
r3s4lie
rs5loep
r5slui
r5smaak
rs5maal
r3sme
r3smi
r4smid
rs3nac
r5sni
rs4no
rs5noo
rs5not
r1so
r2s3op
r1sp
rs3pad
r5span
r5spel
rs3pet
r5spit
r4s4pl
r5spli
r5spog
rs3pol
r1s4t
rstaat4
rst5akk
rs5tas
r4stav
r3ste
r5stend
rs5term
r3sti
r4stit
r3sto
r4store
r5stran
r3stre
rs5trei
rst5roz
r3stu
rs2ui
r1ta
rt3ac
rt1ad
rt3af.
r4tank
rt3ape
r2t3ar
r2tav
r2t3ec
rte5la
rte4na
rt5eve
rt5ha
rt3he
rt3hi
r5t4i
r3tj
rt3ja
rt3jo
r1to
r5tof
rtoi2
r5tol
r4tom
rt3om.
rt5onr
rt3ord
r5tori
r1tr
rt4rek
r2t3ri
rt4rit
rt3ru
rt4sek
rt4s3l
rt3sle
rts5m
rt4s5n
rt4spr
rts5tan
r1tu
r4t3ui4t
rt3we
ru3a
ru5ba
rude3r
ru1e
ru2g
2rui
ru2k
ruk3i
ru2l
rul3a
ru4li
r2um
ru4m3i
r2un
runet5j
r4us
rut3j
4ruu
ru4wi
ru5wig
rvaat5
rvee3t
rvi4c
rvil4
rvloot5
r1w
r5wa
r5we
rwe3st
r3x
4rz
rzet3j
4s.
5s4a.
2s1aan5
s3aap
3saat
3sab
4s1ac
5sacr
3sae
4saf
sa3g4
3sah
3sai
3saj
3saka
3sake
s1akt
s2ala
1sali
4salm
5s4alo
4salp
4samb
samen5t
5samm
s3ank
1sant
san4t3j
5sap.
s3ape
s3apo
sa3pr
4s3arb
s4ari
4s1art
sart5se
sa3sc
s4ase
sa3s4p
1sat
s3atl
2s3att
1sau
4s3aut
4sav
4s5b
sboot5je.
1s2c
4sca
2sce
3sch
4sch.
4schao
5schap
5sche.
4schef
5schen
5schep
5scher
5scho
5schr
5schu
4sci
sci4n
4scl
2sco
s4cola
5scoo
3s4cop
5scope
5scopi
scorres5
3scout
2scu
4s1d
s3da
s5de
sdis5
s5dr
s3dw
3se
5s4e.
se4al
se4ar
s5ech
5sedo
s3eed
4seen
see4t
see5ts
4seev
4s3ei.
seig4
s4ein
5sein.
5seine
5seiz
se4l3ag
sel5eig
s3elek
sel5k
se3lo
se2ma
sem5ac
4s5emm
5sen.
se4n3em
se4net
5senh
se2n5o
sens4
sen5sl
sep3en
se1r4a
se4r5au
se5r2e
4serg
se3ro
ser4s3p
s4es
se5sa
se3s4t
ses5ten
s4et.
s4eta
4sete
set3h
5se2tj
set5w
se3um
4sex
3s
3s
s1f
s3fa
4sfi
s3fl
s3fo
4s5g
sgaat5
2s1h
s4ha.
sheids5
s4h3es
3s4hi
s5hie
s2hot
s3hote
3si
5si.
5s4i4e
sie5kl
sies4
si4
si3f
5sig
si3g4a
si5ge
si5go
s3ijv
4s1ijz
4s3inc
4s3ind
sin3g4l
s3inko
4s3inm
si3no
4sinr
4s1ins
4s3inz
s4io
sis3an
si4se
si4s3i
sis5te.
sis5tr
si3tr
sj2
3s4ja.
2sjas
s1je
s5je.
s3jeb
3sjee
1sje4r
sjer3i
s5jes
3s4jez
sj3k
3sjok
4s5jon
1sjou
2s1k4
4sk.
s3ka
skaart5j
skie3s
skiet4
s3koc
4skou
s4kul
1s2l4
s4la.
s3lad
3s4lag
s5lamp.
s5lampe
4s5land
s3las
2slat
s4lav
5slee.
5slee
s3leef
5sleep
4s5leer
2sleg
s5lei
s3leng
5slent
4s3ler
s3les
3slet
sle4t3j
3s4leu
s5leug
5sleur
4s5lev
s3lez
5slib
2s3lic
4slid
4s5lied
s5lif
s5lig
5slijp
s5lijs
5s4lik
5sling
s5lini
2sliv
slob3
2s3loc
3s4loe
s3log
s5loon
sloor5
s3loos
5sloot5
s3los
4s3lou
2sloz
2s5luc
3slui
4s5lui.
4sluid
sluis4t
5sluit
2s3lus
s4m
4smaat
2s5man
smans3
s5mas
4s5mat
3smed
4smei
4smelo
s5men
4s5mes
smeu5ste
5smid.
s5min
4smis
5smit
1smok
s5mon
1s2n4
2snam
3s4nav
5s4ned
s4nee
snee5t
sne2k
3s4nel
2snes
2sneu
s3neuz
s4ni
s5nie
s5nim
s3nit
4sniv
4snod
s3nog
2snoo
3snuf
s3nut
3s4oc
5sod
1soe
3soep
s3off
s3og
so3gl
3soi
so2k3
3sol
so3lo
3s2om
s4om.
s3oml
5somm
4s3oms
s3omz
s4on.
3sona
4s3ond
2s3ong
so3no
s4ons
4s1on2t3
4s3onv
s3onz
4s5oog
s3ook
s3oor.
s3oord
5soort
3s4op.
2s3opg
s3opn
3sopp
so3pr
2s3opv
4s3ord
2s1org
so3ro
sor4s
3s2ort
so3s4
so5st
3s4ot
so3tr
4sott
sou3t
2s1ov
s2p
4sp.
4spaal
5spaan
5spaat
4spad
4spak
2spap
5spar.
5sparr
4s3pas
4spau
5spectie.
5specties
5spectiv
5specto
speet5
2speg
s5pei
spe2k
2spen
s4pene
4spers
spers5p
spes4
spe3st
2spet
4spex
4spez
s4ph
spie5tj
4spijn
4spijp
5spil
5spio
2s3p4l
s5pla
spli4
4s5plu
2spol
4spom
s4pore
sport5r
2spos
4spoth
s5pred
3sprie
sp5riem
5spriet
4s3prij
5spron
4s3ps
4spt
4spun
5spur
2s3r
4s3s4
s5sa
s5sc
s5se
ssei3s
s5si
ssis4
ssi3st
s5sm
s5snu
s5so
ss5pas
s5su
s2t
4st.
5staan.
4staanw
staart5j
4s4t3a2c
3stad
2staf
3staf.
4stakk
st3akt
s4tap
4stas
s4tav
5stave
2stb
2std
4s5tech
3s4ted
3steek
3steem
3steen
4steka
s3teks
st5elem
3s4tem
4stema
4stemo
st4en
s4tene
s4teni
4s5tenta
s4tep
ster5ijz
ster5og
4steva
s4t3ex
s4t3ez
2stf
2stg
2st1h
st2he
st3hed
st5heer
s5them
5sthenic
5sthenis
s3ther
s4tho
s4thy
2stia
4sticu
4stie.
4stief
5stiefe
4sties
4stiev
5stigm
4stijd
5s4tijl
4st3ijs
3stils
s5tis
4stiv
4s4t1j
2stk
2stl
2stm
2stn
4stoc
4stoef
4stoej
5stoel
5stoep
4stoer
4stoes
5stoet
4stoez
3stof
st3oge
3s4tok
4stone
4stong
st3oog
3stoot
stoot5j
4st3ord
3stot
s4tov
2stp
1str
st4ra
straat5j
5straf
4strap
st3rec
s4tred
4streg
4strei
s5trein
s4trek
5stren
st3rif
st4rol
st4rom
st4roo
4stroos
st5roos.
4strou
4stroz
2st1s4
st5sc
st5se
2stt
1stu
4stub
5stuk
s4tun
st3uni
2stv
2s4t5w
3s4ty5
1styl
2stz
1su
3su3a
sub1
3suc
3sue
5suik
5suis
s1uit
5suk
3sul
2s1un
5surp
5surv
s4us
4s5v
svaat5
svoge4
4s1w
s4y
3sy.
sy4n3e
sys5
4s5z
4t.
t3aang
t3aanw
t3aanz
4t3aap
taar5st
4t3aas
3tabl
2tac
3tace
t4aci
t4act
4tad
t3ader
tad4s3
2taf.
2tafd
5tafe
4t3afs
ta2g3r
tai4l
ta3kl
ta4kle
5talent
talm5a
4talt
ta4mak
4tamb
t3amba
3tame
tament5j
4tamp
tan4dol
tan4d3r
tan4dw
tan4gr
5t4ans
3tant
5tapi
ta3pl
t4are
t4ari
t1arm
ta2r3o
3tarw
3tas
5tasj
5tass
ta5str
4tata
2t3atl
3tatr
3tau
4taut
4t1avo
2t3az
4tb
4t1c
4t5d
1te
te3a.
te2ad
te3ak
tee2
4teek
tee4k3l
teem5a
4teen
tee3ro
tee3t
tee5tjes
2t3eff
te3fl
t4e3g4
tege4n5
3teh
4t3eier
4teig
t3eind
teit2
4tek.
5teka
5tekeni
5tekens
teks2
4t3ekse
t4el
te4lap
5telef
5teleg
5telev
tel5k
te3lo
te4l3og
4telse
te4l3uu
5tema
te4mor
5temper
5tempo
4temu
3t2en
5tenbo
5tene.
te4nek
te4net
tenier5tj
5tenij
ten5k
te4nol
ten4su
t4enta
t5entac
ten4tj
3teo
t2er
teraads5
te4r5aak
ter3ab
ter3ag
te3ral
te3ran
te5rat
ter4du
te3re
te4rei
te4rem
te4r5env
ter5ge
teri4ci
5terig
te4r5in.
3term
5term.
ter5oc
te3rog
ter5om
5te3ron
te4ros
4terren
ter5sc
3t4es
5tesa
te3sap
tes4l
5tesm
test5ri
te3th
4t3euv
t4ev
5tevaa
t5evan
2tex
texi5
t4ext
1t
t1f
4t3g2
tgaat5
tge3la
2t1ha
4t3ham
3thea
t3heb
5thee.
5theen
4t5hei
t3hel
t4hen
5thene
5theo
1ther
t3here
5therm
3thes
3thet
this5m
t3hoe
t3hok
t1hoo
thoof5di
t1hou
t3houd
3thr
2thu
t4hur
3thy
3ti
5ti.
5tia
5tica
5ticu
5tie.
5tief.
5tiefs
5tiek.
tie5kla
tie4kon
5tien
5ties
tie5sl
ti1eu
5tiev
ti4
ti3fe
ti3fr
ti2ga
4tigm
ti2gu
tig3ur
5tijd
5tijn
4t1ijz
ti5kle
ti5kr
ti3kw
t4il
ti4laa
4tils
ti4m3in
5timm
tin5ade
4t3ind
4tinf
tin4g3i
ting5r
tini5
4t3inl
t3inq
4tins
5tint
4tinv
4tinw
tis4l
tis5la
ti3sli
tis5m
ti3s4p
5tite
ti3th
ti1tr
t3ivo
1tj2
4tja
t3jen
tjes5c
t3jesd
tje5spr
4tjeu
4tjo
5tjoe
5tjok
2tju
4t3k2
4t3l
t4lem
4t3m
tmo4s5
4t3n
5t4o.
3toc
3tod4
to3do
t4oe
toe5d
5toej
toe3k
4toel
toe5la
toel4tj
toemaat5
5toen
5toeri
5toe1s
toe3tj
toe5tr
5toez
to2f
4tof.
to4f5l
tof3th
to3g4n
3toj
to4ka
t4ol
2t3oli
5tolo
to2lu
3toma
tomaat5
tom4p3j
2t3oms
t4on
5ton.
5tone
5tong
5tonn
to3no
4tonr
to3nu
toom3e
5toon
toor5tj
4topd
to3pe
to3phe
to3p4le
2topn
to4por
4t3o4pr
t3opsl
t3opto
5tor.
5torens
4t3org
tor4ma
to3ro
5torr
3tors
5to3s4
to5sa
to4st
tos5te
to3tr
2t3oud
tou4re
tove5na
4toverg
tozo5a
4t5p4
tpe4t3
3tra.
4traf
5trag
3trakt
4trand
5trap.
5trapp
t3rasp
3tre.
4trec
4treda
t5redes
t4ref
2t1reg
3trein
4t3reis
4treiz
trest5r
tre2t3
3t4reu
t3rib.
tri3g2
5tril
3t4rio
3t4ris4
4tro.
4t3roed
t3roes
5trog.
5trogg
t4ro
4trol.
t2rom
3tromm
3tron.
5trone
3tronn
3trons
t5rood
5troon
t4roos
5troost
tro5sp
5t4rou
4tru
5truc.
5truf
5truie
trui3t
t4rum
4ts
ts3ad
ts3af
ts3ak
ts3al
t3sap
ts3as
t4scr
ts4cu
ts3een
t4s3ei
ts5eind
ts3eko
t5sel
ts4en
t4s3eng
ts3erg
ts4hel
tsi4ga
t4sij
t4sink
t4s3int
ts2j
ts3ja
5tsji
t5slag.
ts3lam
t2sle
ts3led
t5s4lep
ts5ma
t2s5mu
ts3neu
ts5nik
t3s4no
t4s3om
ts3on
ts1or
t1sp
ts3pad
ts4par
t5spel
ts3pet
ts1pl
ts4pli
ts3pol
t5s4por
ts4t
t1sta
t4staal
t5stap
t1ste
t5stee
ts5teks
t5sten
t4s5term
ts5th
t3sti
t5stil
t1sto
ts5toc
t4s3tol
t4s5tore
t4sty
t4su
ts3ur
ts3uu
t3sy
4t3t
t5ta
t5te
ttent5j
tte5ras
tting5ste
t5tr
tt3uu
tu1a
5tu5b
tu5d
3tue
5tuig
5tuin
4tuip
t3uitg
tui3tj
3t4us
tu3wa
4tv
tvaat5
4t1wa
4twe
5t4wijf
4t3wil
t4win
t5wind
t1wo
t1wr
1ty3
5typ
4tz
4ua
u3a.
u3ac
uae2
u1al
u1an
uar5t
u1ati
u4b
ubal5
u5be
ubes5
u5bi
4uc
u3che
u3cho
uch5ten
uch4to
uc4t3a
ud3ei
u5den
uden4tj
ud3ess
u4d3ez
u4do
ud3oo
ud3ov
u2d3r
ud5ro
ud5sla
ud4sm
ud5sme
ud5smi
ud1w
4ue
u1ee
u1el
u3er
ue4s
uet3j
uet5sp
u1eu
u3ez
u3e
u3
u3fa
u3fl
u3fr
uf2s
u3ga
u4g3ad
uge4leg
ug3ij
ug3l
ugmar5c
u2g1r
ug1s4
ug3sl
u3h
u4i
4ui.
2uid
ui2d3a
ui4d5eu
ui2do
uid5oo
ui2dr
uids5e.
uids4p
uid5spr
uids3t
ui4du
ui3e
uie3s
ui2fa
uif1l
uif5r
ui2fu
4uig
ui4go
4uik
uik3l
uik5r
2uil
uil3aa
ui4l3og
ui4loo
2uim
ui4m3a
uime3s
ui4n1a
uin5g
ui2no
uins5lo
ui2p3l
4uis
ui4sa
ui4sh
ui4sl
ui5slu
uis5m
ui4so
ui4st
ui5stene
ui2t1a
uit1h
uit3j
uit4je
3uit1r
4u
u3j
uk3al
uk3as
u3ke
uke3no
u2k3l
u2k3n
u2k3o
uko5p
u4k1r
uk3sm
uk3sn
uks3p
uk4s3te
uk1w
u1la
ul3ac
u3l4an
ul5and
uld5erk
u3le
ul3fl
ul5fo
ul3fu
ul3ij
ul3k2a
ul2lo
u1lo
u2loe
ul3op
ul2p3l
ul2po
ul4p3r
ul3sa
uls5tel
u3lu
ul3ui
um3ac
3umc
umel4
um5po
3umz
u1na
un3ac
un3ak
un2c
un3che
unch3r
une4tj
un3g4
u5ni
unst3r
4unt
un4tag
unt5een
un2tj
unt5o
u3nu
uo3i
u3on
u3oo
uo3r
u3os
u3oz
u3pa
u2pek
u3p2h
u1pi
up3j
u1pl
u1po
u3pr
u1pu
2ur
u1ra
u4r3ar
urari4
ura3st
ur3au
ur2c
urd4o
u1re
u2r3ec
uree3s
ure5lu
ur3env
ure4t3
ur2f
ur3fl
urf3s
u1ri
ur3ijz
u4r3ind
urken5
urmar4
ur2no
ur5open
ur5pr
urs5ag
ur3s4f
ur2s3l
ur2s5n
ur4sti
urs5tik
ur3ta
4urv
u3ry5
us3ar
u4sc
us3ch
u5scr
use3tj
u4s5l
us5m
u2s5n
us3on
us3op
us3os
us3p
u2st
us4ta
us5tag
ust3al
u4s3te
us4t3ei
ust5on
ust3oo
us3tor
us5tru
ust3u
u1ta
ut3aan
utaar5
ut3ac
u3tan
u4t3ees
u2t3ek
u2t3em
ut5ex
u2tj
u1to
ut3oog
uto5s
ut3ri
ut3saa
ut3sc
uts5eng
ut3sku
ut3so
ut2s3p
ut5su
u1tu
ut5w
uu2
uur3a
uur5k
uur1o
uw1a
u3wag
uw3au
u1we
uw3een
u2w3ei
uw3eko
u5wen
uwen5k
uwe3s4
u1wi
uw3ij
u3win
uw3n
uw1o
u3woe
uw1r
u3xi
u3ya
uzes4
uze5t
3v4
4v.
5va
vaar5tj
vag4
va2ko
va4kon
va2l3a
va3laa
val5m
val4s3p
vals5tek
va2n
van4ch
van4g5r
va3no
va5p
vast3r
va2t3h
vee4l
veel5e
vee3p4
vee5sta
vei3s4
vel4d3o
vel4du
vel4s3n
ve4na
ve5nare
ven5dr
ven5k
ve2n3o
ven4se
ven4sl
vens5lo
ven4s3u
vent4s
ve2r
ver1a
ver5aas
ve4rad
ver5do
ver3ed
ve3rei
ver3er
ver3et
ver5ijl
ve5ring
verk4
ver1o
ve3rom
vers4a
ver3sp
ver5sto
ver3u
ve2s3
ve3sa
ve3s4c
ve3su
ve2t3j
ve2t3o
ve3tor
ve4t3r
ve5t4ro
vet5sta
vie4r3a
vies3n
vil4t3j
vi4sa
vis3an
vis5m
vis5ot
vi3t2r
4v5j
4v5lar
vlei3s4
vlie4s3
voe4t3r
voet5sp
vo2le
vol4g3a
vo2li
vol3ij
volk4s3
voorn4
voor5na
vo3ra
vot5j
vr2
vrij3k
vrijs4
vuet4
vui2
vy5
2w.
waar5e
wa4b3
w2ad
w2ag
wa5ge
wagen5t
wal3a
4wam
wam5pl
4wana
wanei5
wan4gl
wang5sl
wa2no
wan3s
wan5sp
3wap
3warm
wart3j
war4to
wa4si
was5m
3wat
2wb
2wd
w4doo
wd3oom
we2at
we4ba
3wed
wede4
we2d3i
we4d3r
wee5kla
week3r
wee4r
weer3o
wees4t
wee5ste
wee5str
wee3tj
we2g3a
weg1l
we2go
we2g3r
3weid
wei5s
we2k3a
4weko
we4k3r
wel3ed
wel3ee
wel3sm
we4mi
we2n
we3naa
wen3ad
we3ne
we4nem
wen4ka
wen3o
wer2g
wer4g3r
wer4k3l
werk3u
wer4s
2w3erw
we2s3
3wet.
we4t3h
we2t3j
wezens5
wezen5t4
2w3f
w1g
4w1h
w4hi
wie4t
w3igd
w3igi
w3igt
3wijd
wij4ka
wij4s
wijs5m
wi2k
wik5l
3will
3wim
w4in
win4d3r
wing5st
2w5inr
winst5a
wis5m
wi4t3h
wit3j
w1j
2w1k
2w1l
w1m
2wn
wn4i
w3no
w2oe
woei2
woe3ie
woel3a
woe4s
woest5a
woes5te
wo2l
wol3a
wolf2
wolfs5
woor4d5r
wor4ge
worg5eng
4wot
w1p
wper2
wpers3
w3ru
2ws
ws3a
ws4k
ws5ke
w3s4p
w4spe
w5spel
ws4t
w1sta
w3ste
w3sto
2wt
wte5ri
w3to
w3tr
w1w
2x
x3ad
xamen5t
xan3
xan5t
x1c
xe3a
xe3ro
x3f
x1h
4xiet.
x3ing
xi4s4
xis5m
xi3st
xi5sta
x3l
xo3s
x1p
x1t
x2t3ak
xtie4
x3w
xy5
y1
y2a.
y4ah
y3au
yber4
ybert3
yce3
yd4r
ydro3
y4in
yis5m
y4l
ylar3
y5lee
yl3et
y5li
y5lo
y5lu
y2m
y3me
ym2fl
y3mo
ym5pa
y3mu
y2n
y3na
y4n3an
yn3er
y3ni
y3no
yn3t
ynx5
y5oo
y4pew
y3ph
y5r4e
y5ri
y5ro
y4s2
y5sa
y5se
y5sf
y5sh
y5si
ys5m
y5so
ys3t
ys4to
y5sy
yto3
1z
2z.
zaar5t
za2k3a
zan4d3a
zan4dr
zar5t
za5s4
2zb
3ze
zee5le
zee3n
zee3s4
zee3tj
zeg4sl
zel5dr
ze3mo
zen4d3a
zene4
zen5k
ze4nol
zen4t3j
ze4r3a
ze3ro
zer4sl
zer4sp
ze4s3e
ze2s5m
zes5tal
ze3ste
ze4tan
ze4ti
ze4tj
ze2t3r
ze3tre
zeun3
zeve2
zeven3
3z2i
ziek3l
ziel4s
zi2ga
zij5s4
zin4k3l
zin4sl
zin4sm
zis5m
zit3j
zi2t3u
4zk
2zm
zo4a.
zoet3j
zo3f2
zo4s
zome4
zo4nek
zon3sf
zo3s
zo2t
zot3h
4z3r
2zs
zus3
2zv
z4w
zwe2m
zwenk5a
4zz
}
% Exception list for GB90
\hyphenation{
aan-pers-te
acht-en-der
acht-en-ders
acht-en-der-tig
acht-en-der-tig-ste
ant-arc-tis
be-scherm-en-gel
be-scherm-en-ge-len
don-der-aal
drie-ster
gast-rol-len
ge-laats-trek-ken
han-dels-taal
ket-ting-ste-ken
lands-taal
lui-ste
mi-nis-ters-por-te-feuil-le
mi-nis-ters-por-te-feuil-les
moet-je
pa-ling-ste-ken
schel-linkje
spie-gel-ei
ti-chel-aar-de
vier-en-der-tig
vier-en-der-tig-ste
}
\endinput
