/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*                       William Moore <billy@mud.mind.net>		      *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/
#include <stdarg.h>
#include "wmsound.h"

void sBugf(const char *fmt, ...) {
  char buf[255];
  va_list  args;
	
  va_start(args,fmt);
  vsnprintf(buf,255,fmt,args);
  va_end(args);
  fprintf(stderr,"%s: %s\n",ProgName,buf);
}

char* defaultsPathForDomain(char *domain,bool fLocal)
{
  char path[1024];
  char *gspath, *tmp;

  if (!fLocal) {
    strcpy(path, GLOBAL_DIR);
    strcat(path, "/");
  } else {
    char *home;
    home = getenv("HOME");
    if (!home) {
      sBugf("could not get HOME environment variable!");
      exit(0);
    }
    strcpy(path, home);
    strcat(path, "/GNUstep/");
  }
  strcat(path, DEFAULTS_DIR);
  strcat(path, "/");
  strcat(path, domain);

  tmp = malloc(strlen(path)+2);
  strcpy(tmp, path);
  return tmp;
}

long getTimeStamp(const char *file) {
  struct stat s;
	
  if(stat(file,&s) < 0) {
    sBugf("the WindowMaker configuration file '%s' was not found",file);
    return 0;
  } else {
    return s.st_ctime;
  }
}
