# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#
#                          The Music Server Patch
#
#                    for X-DOOM & SVGA-DOOM, version 1.8
#
#
#                               version 1.1
#
#
#           Steffen Winterfeldt (wfeldt@tph100.physik.uni-leipzig.de)
#
#           last modified:  Tue Aug 8 1995, 12:53
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@xdoom
-c
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+                                                                          +
#+                           The Music Server Patch                         +
#+                                                                          +
#+                          for X-DOOM, version 1.8                         +
#+                                                                          +
#+                                 version 1.1                              +
#+                                                                          +
#+           Steffen Winterfeldt (wfeldt@tph100.physik.uni-leipzig.de)      +
#+                                                                          +
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-q -C

# name of the file to patch
-f xdoom

# some variables
{
:2c000 v0
:3c008 v1		# holds msg_id
:3c00c v2		# holds "musserver"
:4f544 v10
}

-n@common

@sdoom
-c
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+                                                                          +
#+                           The Music Server Patch                         +
#+                                                                          +
#+                         for SVGA-DOOM, version 1.8                       +
#+                                                                          +
#+                                 version 1.1                              +
#+                                                                          +
#+           Steffen Winterfeldt (wfeldt@tph100.physik.uni-leipzig.de)      +
#+                                                                          +
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-q -C

# name of the file to patch
-f sdoom

# some variables
{
:2b000 v0
:3b008 v1		# holds msg_id
:3b00c v2		# holds "musserver"
:4e50c v10
}

-n@common

@common			# relevant to both sdoom & xdoom

-m 3			# 3 passes
:0x400 o		# header

-p0x00000

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# scan for musserver in .doomrc
=0a4e8 {
e8 Jv700		# call v700
e9 Ja364		# jmp 0xa364
}

# write musserver to .doomrc
=0a260 {
e8 Jv600		# call v600
90			# nop
}

# end music server right after sound server
=28994 {
e8 Jv500		# call v500
}

# init musserver after sndserver
=03ef3 {
e8 Jv300		# call v300
}

# # grab music ressource string
# =26610 {
# e8 Jv200		# call v200
# }

# grab music ressource string
=26621 {
e8 Jv200		# call v200
}

# free a memory place for an int at v1
=0102a {
ba w80			# movl $0x80,%edx
90			# nop
}

# free a memory place for musserver command at v2
=0104a {
ba w239			# movl $0x239,%edx
90			# nop
}

# set music volume
=264ca {
90 90 90 90 90 90 90	# nop*7
=264d2
e8 Jv400		# call v400
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# init some data
-p v1 w0-1
-p v2 wv900

# begin of new code (aligned to the end of last code page)
:v0-v999+v100 v100 -p v100

# transfer ressource string to musserver
:$ v200 {
# the next lines are for debugging only...
# !!!! don't forget to uncomment v290 !!!!
# # printf("playing music \"%s\"\n", ressource);
# 53			# pushl %ebx		; ressource
# 68 wv290		# pushl $v290
# e8 J60000a00		# call <printf>
# 5b			# popl %ebx
# 5b			# popl %ebx		; ressource
# if(msq_id > 0 ) {
#   msgsnd(msq_id, (struct msgbuf *) &msg_buffer, 12, IPC_NOWAIT);
# }
a1 wv1			# movl v1,%eax		; msq_id
83 f8 0-1		# cmpl -$0x1,%eax	; == -1 ?
74 jv250		# jz v250
8b 1e			# movl (%esi),%ebx
ff 73 6			# pushl 0x6(%ebx)	; msg_text[12]
ff 73 2			# pushl 0x2(%ebx)	; dto.
66 ff 33		# pushw (%ebx)		; dto.
66 68 'd_'		# pushw 'd_'
6a 06			# pushl $0x6		; msg_type
8b dc			# movl %esp,%ebx
68 w800			# pushl $0x800		; IPC_NOWAIT
68 wc			# pushl $0xc		; 12
53			# pushl %ebx		; msg_buffer
50			# pushl %eax		; msq_id
e8 J60001fe0		# call <msgsnd>
83 c4 20		# addl $0x20,%esp
:$ v250
e9 J2012c		# jmp 0x2012c		; continue as usual...
}
# debugging !!!!
# :$ v290
# 'playing music "%s"' 10 0

# init musserver
:$ v300 {
# set real uid to effective uid, otherwise
# it will cause problems when the IPC message queue
# has to be removed at the end
e8 J60000588		# call <geteuid>
50			# pushl %eax
e8 J60000cf8		# call <setuid>
58			# pop %eax
# now, go on
e8 J2891c		# call 0x2891c		; first, the sndserver
6a 1			# pushl $0x1
ff 35 wv2		# pushl v2		; "musserver"
e8 J60000168		# call <access>
83 c4 8			# addl $0x8,%esp
09 c0			# or %eax,%eax		; NULL ?
75 jv350		# jnz v350		; --> failed
# popen(_musserver_, "w");
68 w288f3		# pushl $0x288f3	; "w"
ff 35 wv2		# pushl v2		; "musserver"
e8 J600009f8		# call <popen>
83 c4 8			# addl $0x8,%esp
# init IPC
# msq_id = msgget(53075, IPC_CREAT | 0777);	/* all permissions */
68 w3ff			# pushl $0x3ff		; IPC_CREAT | rwxrwxrwx
68 } w53075 {		# pushl $0xcf53		; 53075
e8 J60001fd0		# call <msgget>
a3 wv1			# movl %eax,v1		; msq_id
83 c4 8			# addl $0x8,%esp
c3			# ret
:$ v350
ff 35 wv2		# pushl v2		; "musserver"
68 wv390		# pushl $v390		; error message
68 w600907d4		# pushl $0x600907d4	; stderr
e8 J60000488		# call <fprintf>
83 c4 0c		# addl $0xc,%esp
c3			# ret
}
:$ v390
'Could not start music server [%s]' 10 0

# set music volume
:$ v400 {
# if(msq_id > 0 ) {
#   msgsnd(msq_id, (struct msgbuf *) &msg_buffer, 12, IPC_NOWAIT);
# }
a1 wv1			# movl v1,%eax		; msq_id
83 f8 0-1		# cmpl -$0x1,%eax	; == -1 ?
74 jv450		# jz v450
8b 5c 24 04		# movl 0x4(%esp),%ebx	; arg1
c1 e3 05		# shll 0x5,%ebx
b3 'v'			# mov 'v',%bl
6a 0			# pushl 0x0		; msg_text[12]
6a 0			# pushl 0x0		; dto.
53			# pushl %ebx		; dto.
6a 06			# pushl $0x6		; msg_type
8b dc			# movl %esp,%ebx
68 w800			# pushl $0x800		; IPC_NOWAIT
68 wc			# pushl $0xc		; 12
53			# pushl %ebx		; msg_buffer
50			# pushl %eax		; msq_id
e8 J60001fe0		# call <msgsnd>
83 c4 20		# addl $0x20,%esp
:$ v450
c3			# ret
}

# end sound & music server
:$ v500 {
e8 J288bc		# call 0x288bc		; end sound server
a1 wv1			# movl v1,%eax		; msq_id
83 f8 0-1		# cmpl -$0x1,%eax	; == -1 ?
74 jv550		# jz v550
6a 0			# pushl 0x0		; (struct msgid_ds *) NULL
6a 0			# pushl 0x0		; IPC_RMID
50			# pushl %eax		; msq_id
e8 J60001fc8		# call <msgctl>
83 c4 0c		# addl $0xc,%esp
:$ v550
c3			# ret
}

# write musserver to .doomrc (after sndserver)
:$ v600 {
83 ff 0f		# cmpl $0xf,%edi
75 jv650		# jnz v650
ff 35 wv2		# pushl v2
68 wv900		# pushl $v900
68 wa1cf		# pushl $0xa1cf
8b 55 fc		# movl 0xfffffffc(%ebp),%edx
52			# pushl %edx
e8 J60000488		# call <fprintf>
83 c4 10		# addl $0x10,%esp
:$ v650
39 3d wv10		# cmpl %edi,v10		; entries in .doomrc
c3			# ret
}

# scan for musserver in .doormc
:$ v700 {
68 wv900		# pushl $v900
8d 45 b0		# leal 0xffffffb0(%ebp),%eax
50			# pushl %eax
e8 J60000e10		# call <strcmp>
83 c4 08		# addl $0x8,%esp
09 c0			# orl %eax,%eax
75 jv750		# jnz v750
83 bd w0-c8 00		# cmpl $0x0,0xffffff38(%ebp)
74 jv750		# jz v750
8b 85 w0-c0		# movl 0xffffff40(%ebp),%eax
a3 wv2			# mov %eax,v2
:$ v750
c3			# ret
}

:$ v900
'musserver' 0

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# the end, put no code below!!!
:$ v999
