/*
 * Application interface library for the GUS driver
 * Copyright (c) 1994/95 by Jaroslav Kysela (Perex soft)
 */

#include <asm/byteorder.h>
#include "../../../include/gusfiles.h"

#ifdef DEBUG

#include <assert.h>
#define ASSERT( s ) assert( s )

void __gus_dprintf( char *, ... );
#define gus_dprintf( args... ) __gus_dprintf( ##args )

#else

#define ASSERT( s ) { ; }

#define gus_dprintf( fmt... )	/* nothing */

#endif

extern inline int _p_rint( float x )
{
  return (int)( x + (float)0.5 );
}

/*
 *
 */

extern inline void gus_put_byte( unsigned char *array, unsigned int idx, unsigned char b )
{
  *(array + idx) = b;
}

extern inline unsigned char gus_get_byte( unsigned char *array, unsigned int idx )
{
  return *(array + idx);
}

#if defined( __i386__ )

extern inline void gus_put_word( unsigned char *array, unsigned int idx, unsigned short w )
{
  *(unsigned short *)(array + idx) = w;
}

extern inline unsigned short gus_get_word( unsigned char *array, unsigned int idx )
{
  return *(unsigned short *)(array + idx);
}

extern inline void gus_put_dword( unsigned char *array, unsigned int idx, unsigned int dw )
{
  *(unsigned int *)(array + idx) = dw;
}

extern inline unsigned int gus_get_dword( unsigned char *array, unsigned int idx )
{
  return *(unsigned int *)(array + idx );
}

#else

#ifdef __LITTLE_ENDIAN

extern inline void gus_put_word( unsigned char *array, unsigned int idx, unsigned short w )
{
  *(array + idx + 0) = (unsigned char)(w >> 0);
  *(array + idx + 1) = (unsigned char)(w >> 8);
}

extern inline unsigned short gus_get_word( unsigned char *array )
{
  return ( *(array + idx + 0) << 0 ) |
         ( *(array + idx + 1) << 8 );
}

extern inline void gus_put_dword( unsigned char *array, unsigned int dw )
{
  *(array + idx + 0) = (unsigned char)(dw >>  0);
  *(array + idx + 1) = (unsigned char)(dw >>  8);
  *(array + idx + 2) = (unsigned char)(dw >> 16);
  *(array + idx + 3) = (unsigned char)(dw >> 24);
}

extern inline unsigned int gus_get_dword( unsigned char *array )
{
  return ( *(array + idx + 0) <<  0 ) |
         ( *(array + idx + 1) <<  8 ) |
         ( *(array + idx + 2) << 16 ) |
         ( *(array + idx + 3) << 24 );
}

#else

extern inline void gus_put_word( unsigned char *array, unsigned int idx, unsigned short w )
{
  *(array + idx + 0) = (unsigned char)(w >> 8);
  *(array + idx + 1) = (unsigned char)(w >> 0);
}

extern inline unsigned short gus_get_word( unsigned char *array )
{
  return ( *(array + idx + 0) << 8 ) |
         ( *(array + idx + 1) << 0 );
}

extern inline void gus_put_dword( unsigned char *array, unsigned int dw )
{
  *(array + idx + 0) = (unsigned char)(dw >> 24);
  *(array + idx + 1) = (unsigned char)(dw >> 16);
  *(array + idx + 2) = (unsigned char)(dw >>  8);
  *(array + idx + 3) = (unsigned char)(dw >>  0);
}

extern inline unsigned int gus_get_dword( unsigned char *array )
{
  return ( *(array + idx + 0) << 24 ) |
         ( *(array + idx + 1) << 16 ) |
         ( *(array + idx + 2) <<  8 ) |
         ( *(array + idx + 3) <<  0 );
}

#endif

#endif

/*
 *
 */

extern inline unsigned char get_unsigned_byte( unsigned char *ptr )
{
  return *ptr;
}

extern inline void put_unsigned_byte( unsigned char *ptr, unsigned char val )
{
  *ptr = val;
}
 
extern inline unsigned char get_signed_byte( signed char *ptr )
{
  return *ptr;
}

extern inline void put_signed_byte( signed char *ptr, signed char val )
{
  *ptr = val;
}
 
#if defined( __LITTLE_ENDIAN ) || defined( __i386__ )

extern inline signed short get_signed_word( unsigned char *ptr )
{
  return *(signed short *)ptr;
}

extern inline void put_signed_word( unsigned char *ptr, signed short val )
{
  *(signed short *)ptr = val;
}

extern inline unsigned short get_unsigned_word( unsigned char *ptr )
{
  return *(unsigned short *)ptr;
}

extern inline void put_unsigned_word( unsigned char *ptr, unsigned short val )
{
  *(unsigned short *)ptr = val;
}

extern inline unsigned int get_unsigned_dword( unsigned char *ptr )
{
  return *(unsigned int *)ptr;
}

extern inline void put_unsigned_dword( unsigned char *ptr, unsigned int val )
{
  *(unsigned int *)ptr = val;
}

#else

extern inline unsigned short get_signed_word( unsigned char *ptr )
{
  return (signed short)( *ptr + ( *( ptr + 1 ) << 8 );
}

extern inline void put_signed_word( unsigned char *ptr, signed short val )
{
  *ptr = (unsigned char)val;
  *(ptr + 1) = val >> 8;
}

extern inline unsigned short get_unsigned_word( unsigned char *ptr )
{
  return (signed short)( *ptr + ( *( ptr + 1 ) << 8 );
}

extern inline void put_unsigned_word( unsigned char *ptr, unsigned short val )
{
  *ptr = (unsigned char)val;
  *(ptr + 1) = val >> 8;
}

extern inline unsigned int get_unsigned_dword( unsigned char *ptr )
{
  return (signed int)( *ptr + ( *( ptr + 1 ) << 8 ) + 
                       ( *( ptr + 2 ) << 8 ) + ( *( ptr + 3 ) << 8 ) );
}

extern inline void put_unsigned_dword( unsigned char *ptr, unsigned int val )
{
  *ptr = (unsigned char)val;
  *(ptr + 1) = (unsigned char)val >> 8;
  *(ptr + 2) = (unsigned char)val >> 16;
  *(ptr + 3) = (unsigned char)val >> 24;
}

#endif

extern inline unsigned char gus_get_Lbyte( unsigned char *array, unsigned int idx )
{
  return *(array + idx);
}

extern inline unsigned short gus_get_Lword( unsigned char *array, unsigned int idx )
{
  return ( *(array + idx + 1) << 0 ) |
         ( *(array + idx + 0) << 8 );
}

extern inline unsigned int gus_get_Ldword( unsigned char *array, unsigned int idx )
{
  return ( *(array + idx + 3) <<  0 ) |
         ( *(array + idx + 2) <<  8 ) |
         ( *(array + idx + 1) << 16 ) |
         ( *(array + idx + 0) << 24 );
}
