#include <stdio.h>
#include <libgus.h>
#include <sys/time.h>
#include <unistd.h>
#include <assert.h>
#include <memory.h>
#include <malloc.h>

#define OUTPUT_DEVICE	GUS_MIDID_SYNTH
#define PROGRAM		GUS_MIDI_PROGRAM( 0, 98 )
#define PATCH		"/dos/c/ultrapnp/midi/crystal.pat"
#define FFFF_FFF	"/usr/local/lib/gus/interwave/gsfull4m.fff"
#define FFFF_DAT	"/usr/local/lib/gus/interwave/gsfull4m.dat"
#define ROM		"AMDGM_1_1_"
#define ICFG_FILE	"test.conf"

void play_note( void )
{
  int pgm;

  pgm = PROGRAM;
  gus_midi_timer_start();
  gus_midi_control( OUTPUT_DEVICE, 0, GUS_MCTL_MSB_BANK, GUS_MIDI_PROGRAM_BANK( pgm ) );
  gus_midi_program_change( OUTPUT_DEVICE, 0, GUS_MIDI_PROGRAM_PROG( pgm ) );
  gus_midi_note_on( OUTPUT_DEVICE, 0, 64, 127 );
  gus_midi_wait( 400 );
  gus_midi_note_off( OUTPUT_DEVICE, 0, 64, 0 );
  gus_midi_flush();
  gus_midi_timer_stop();
}

void remove_instrument( void )
{
  gus_instrument_t instr; 

  memset( &instr, 0, sizeof( instr ) );
  instr.number.instrument = PROGRAM;
  assert( !gus_midi_memory_free( OUTPUT_DEVICE, &instr ) );
}

void main()
{
  int pgm, handle;
  gus_midi_device_t *device_out;
  gus_instrument_t *instr;
  gus_rom_interwave_header_t rom_header;
  struct GUS_STRU_MEMORY_LIST list;
  gus_instrument_name_t iname;
  
  device_out = malloc( sizeof( gus_midi_device_t ) );
  assert( !gus_midi_fill_device_structure(
  			device_out,
  			GUS_MIDI_OPEN_MODE_WRITE,
  			OUTPUT_DEVICE,
  			0xffff ) );

  if ( gus_midi_open( GUS_MIDI_OUT, device_out, 2048, 0 ) < 0 )
    {
      printf( "open error: %s\n", gus_midi_error );
      return;
    }
  gus_midi_timer_tempo( 100 );
  gus_midi_emulation_set( OUTPUT_DEVICE, GUS_MIDI_EMUL_GS );

#if 1
  gus_midi_preload_bank( OUTPUT_DEVICE, "ALL" );
  list.count = 1024;
  list.info.instruments = malloc( list.count * sizeof( unsigned int ) );
  gus_midi_memory_list( OUTPUT_DEVICE, &list );
  for ( pgm = 0; pgm < 1024 && list.info.instruments[ pgm ] != -1; pgm++ )
    {
      iname.number.instrument = list.info.instruments[ pgm ];
      gus_midi_memory_get_name( OUTPUT_DEVICE, &iname );
      printf( "%i: bank %i prog %i name '%s' ", pgm, iname.number.midi.bank, iname.number.midi.prog, iname.name );
      switch ( iname.mode ) {
        case GUS_INSTR_SIMPLE:
          printf( "<simple>" );
          break;
        case GUS_INSTR_PATCH:
          printf( "<patch>" );
          break;
        case GUS_INSTR_INTERWAVE:
          printf( "<InterWave>" );
          break;
        default:
          printf( "<unknown>" );
      }
      switch ( iname.flags ) {
        case GUS_INSTR_F_NORMAL:
          printf( " [loaded]\n" );
          break;
        case GUS_INSTR_F_NOT_FOUND:
          printf( " [not found]\n" );
          break;
        case GUS_INSTR_F_ALIAS:
          printf( " [loaded-alias]\n" );
          break;
        case GUS_INSTR_F_NOT_LOADED:
          printf( " [not_loaded]\n" );
        default:
          printf( " [unknown]\n" );
      }
    }
  gus_midi_memory_reset( OUTPUT_DEVICE );

  pgm = PROGRAM;

  printf( "Preloaded instrument %i/%i (gusd).. ", GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ); fflush( stdout );
  assert( !gus_midi_preload_program( OUTPUT_DEVICE, &pgm, 1 ) );
  play_note();
  printf( "done...\n" );
  remove_instrument();

  printf( "Patch '%s'.. ", PATCH ); fflush( stdout );
  instr = gus_instr_alloc();
  assert( instr );
  assert( !gus_instr_patch_load( instr, PATCH, 0 ) );
  instr -> number.instrument = pgm;
  instr -> name = strdup( "FX 3 (crystal)" );
  assert( !gus_midi_memory_alloc( OUTPUT_DEVICE, instr ) );
  gus_instr_free( instr );
  play_note();
  remove_instrument();
  printf( "done...\n" );

  printf( "FFFF '%s' %i/%i.. ", FFFF_FFF, GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ); fflush( stdout );
  instr = gus_instr_alloc();
  assert( instr );
  assert( ( handle = gus_instr_ffff_open( FFFF_FFF, FFFF_DAT ) ) >= 0 );
  assert( !gus_instr_ffff_load( instr, handle, GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ) );
  assert( !gus_instr_ffff_close( handle ) );
  instr -> number.instrument = pgm;
  instr -> name = strdup( "FX 3 (crystal)" );
  assert( !gus_midi_memory_alloc( OUTPUT_DEVICE, instr ) );
  gus_instr_free( instr );
  play_note();
  remove_instrument();
  printf( "done...\n" );

  if ( gus_midi_output_device( OUTPUT_DEVICE ) -> cap & GUS_MIDI_CAP_SYNTH )
    {
      gus_info_t info;
           
      assert( !gus_midi_synth_info( OUTPUT_DEVICE, &info ) );
      if ( info.flags & GUS_STRU_INFO_F_ENHANCED )
        {
          printf( "FFFF ROM '%s' %i/%i.. ", ROM, GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ); fflush( stdout );
          assert( !gus_instr_ffff_get_rom_header( gus_midi_get_handle(), gus_instr_ffff_access_midi( OUTPUT_DEVICE ), 0, &rom_header ) );
          assert( !strcmp( rom_header.series_name, ROM ) );
          instr = gus_instr_alloc();
          assert( instr );
          assert( ( handle = gus_instr_ffff_open_rom( gus_midi_get_handle(), gus_instr_ffff_access_midi( OUTPUT_DEVICE ), 0, 1 ) ) >= 0 );
          assert( !gus_instr_ffff_load( instr, handle, GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ) );
          assert( !gus_instr_ffff_close( handle ) );
          instr -> number.instrument = pgm;
          instr -> name = strdup( "FX 3 (crystal)" );
          assert( !gus_midi_memory_alloc( OUTPUT_DEVICE, instr ) );
          gus_instr_free( instr );
          play_note();
          remove_instrument();
          printf( "done...\n" );
        }
    }

  printf( "icfg in " ICFG_FILE " %i/%i.. ", GUS_MIDI_PROGRAM_BANK( pgm ), GUS_MIDI_PROGRAM_PROG( pgm ) ); fflush( stdout );
  assert( !gus_midi_icfg_open( OUTPUT_DEVICE, ICFG_FILE ) );
  gus_midi_icfg_download_program( OUTPUT_DEVICE, &pgm, 1 );
  play_note();
  remove_instrument();
  assert( !gus_midi_icfg_close( OUTPUT_DEVICE ) );
  printf( "done...\n" );
#endif

#if 0
  printf( "start\n" );
  for ( pgm = 0; pgm < 1000; pgm++ )
    {
      gus_midi_emulation_set( OUTPUT_DEVICE, pgm & 1 ? GUS_MIDI_EMUL_GM : GUS_MIDI_EMUL_GS );
      assert( !gus_midi_icfg_open( OUTPUT_DEVICE, ICFG_FILE ) );
      assert( !gus_midi_icfg_close( OUTPUT_DEVICE ) );
    }
  printf( "end\n" );
  while ( 1 ) ;
#endif
 
  gus_midi_close();
}
