/*

Name:
MARCHIVE.C

Description:
These routines are used to detect different archive/compression formats and
decompress/de-archive the mods from them if necessary

Portability:
All systems - all compilers

Steve McIntyre <sam1007@cam.ac.uk>

Feel free to use/modify this code if you like, let me know if you improve
it! 

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef NEED_UNISTD
#include <unistd.h>
#endif /* NEED_UNISTD */

#include "mikmod.h"

/* 
	==================================================================
	Use similar signature idea to "file" to see what format we have...
	==================================================================
*/

int *MA_identify(char *filename, int header_location, char *header_string)
{
	FILE *fp;
	char id[16]; /* hopefully should be big enough for "signature" */

	if((fp=fopen(filename,"rb"))==NULL){
		myerr="Error opening file";
		return NULL;
	}
	modfp=fp;
	_mm_rewind(modfp);
	if(header_location)
		_mm_fseek(modfp,header_location,SEEK_SET);
	if(!fread(id,strlen(header_string),1,modfp)) return 0;
	if(!memcmp(id,(char *)header_string,strlen(header_string))) return (int *) 1;

	return 0;
}

char *MA_dearchive(char *filename)
{
	char tmp_file[256];
	char command_buff[512];
	char *vc;
	int archive=0;

	if ((vc=getenv("HOME"))) {
      		strcpy(tmp_file, vc);
	} else {
      		strcpy(tmp_file, "/tmp");
	}
 	strcat(tmp_file, "/.modXXXXX");

	if(MA_identify(filename,ZIP_HEADER_LOCATION,ZIP_HEADER_STRING)){
		sprintf(command_buff,ZIP_EXTRACT_COMMAND" %s "MOD_TYPES" >%s 2>/dev/null",filename,tmp_file);
		archive=1;
	}
	else if(MA_identify(filename,LHA_HEADER_LOCATION,LHA_HEADER_STRING)){
		sprintf(command_buff,LHA_EXTRACT_COMMAND" %s "MOD_TYPES" >%s 2>/dev/null",filename,tmp_file);
		archive=1;
	}
	else if(MA_identify(filename,ZOO_HEADER_LOCATION,ZOO_HEADER_STRING)){
		sprintf(command_buff,ZOO_EXTRACT_COMMAND" %s "MOD_TYPES" >%s 2>/dev/null",filename,tmp_file);
		archive=1;
	}
	else if(MA_identify(filename,ARJ_HEADER_LOCATION,ARJ_HEADER_STRING)){
		sprintf(command_buff,ARJ_EXTRACT_COMMAND" %s >%s 2>/dev/null",filename,tmp_file);
		archive=1;
	}
	else if(MA_identify(filename,GZIP_HEADER_LOCATION,GZIP_HEADER_STRING)){
		sprintf(command_buff,GZIP_EXTRACT_COMMAND" %s >%s 2>/dev/null",filename,tmp_file);
		archive=1;
	}			
	if(archive){
		filename=tmp_file;
		system(command_buff);
	}

	return (char *) filename;
}

