/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#ifdef GUSCFG_ESS

#ifdef __DRIVER_STRU__

struct GUS_STRU_ESS {
  unsigned int port;		/* port of ESS chip */
  unsigned short irq;		/* IRQ number of ESS chip */
  unsigned short version;	/* version of ESS chip */
  unsigned short mode;

  /* needed by codec_pcm.c */

#ifdef GUSCFG_INTERRUPTS_PROFILE
  unsigned int interrupt_stat_playback;
  unsigned int interrupt_stat_record;
#endif
  unsigned int record_overflow;
  unsigned short pflags;
  unsigned short rflags;
};
                        
#endif /* __DRIVER_STRU__ */


#ifdef __DRIVER_MAIN__

/* IO ports */

#define ESSP( card, x ) ( card -> ess.port + e_s_s_ESS##x )

#define e_s_s_ESSRESET		0x6
#define e_s_s_ESSREAD		0xa
#define e_s_s_ESSWRITE		0xc
#define e_s_s_ESSCOMMAND	0xc
#define e_s_s_ESSSTATUS		0xc
#define e_s_s_ESSDATA_AVAIL	0xe
#define e_s_s_ESSDATA_AVAIL_16	0xf
#define e_s_s_ESSMIXER_ADDR	0x4
#define e_s_s_ESSMIXER_DATA	0x5
#define e_s_s_ESSOPL3_LEFT	0x0
#define e_s_s_ESSOPL3_RIGHT	0x2
#define e_s_s_ESSOPL3_BOTH	0x8
#define e_s_s_ESSENABLE0	0x0
#define e_s_s_ESSENABLE1	0x9
#define e_s_s_ESSENABLE2	0xb
#define e_s_s_ESSINIT1		0x7

#define ESS_DSP_CMD_SPKON	0xd1
#define ESS_DSP_CMD_SPKOFF	0xd3
#define ESS_DSP_CMD_DMAON	0xd0
#define ESS_DSP_CMD_DMAOFF	0xd4

#define ESS_MIC_DEV		0x1a
#define ESS_LINE_DEV		0x3e
#define ESS_CD_DEV		0x38
#define ESS_GF1_DEV		0x3a
#define ESS_MASTER_DEV		0x32
#define ESS_FM_DEV		0x36
#define ESS_PCM_DEV		0x14 
#define ESS_SPEAKER_DEV		0x3c

#define ESS_RECORD_SOURCE	0x0c
#define ESS_MIXS_NONE		0x00
#define ESS_MIXS_MIC		0x01
#define ESS_MIXS_CD		0x03
#define ESS_MIXS_LINE		0x07

/* defines for ess.mode */

#define ESS_MODE_NONE           0x0000
#define ESS_MODE_PLAY           0x0001
#define ESS_MODE_RECORD         0x0002
#define ESS_MODE_OPEN           (ESS_MODE_PLAY|ESS_MODE_RECORD)

int ess_dsp_command( gus_card_t *card, unsigned char val );
int ess_dsp_get_byte( gus_card_t *card );
int ess_write( gus_card_t *card, unsigned char reg, unsigned char data );
int ess_read( gus_card_t *card, unsigned char reg );
void ess_mixer_write( gus_card_t *card, unsigned char reg, unsigned char data );
unsigned char ess_mixer_read( gus_card_t *card, unsigned char reg );
int ess_reset( gus_card_t *card );
int ess_detect( gus_card_t *card );
int ess_init( gus_card_t *card, int stop );
void ess_interrupt( gus_card_t *card );
void gus_init_ess_pcm( gus_pcm_t *pcm );

#endif /* __DRIVER_MAIN__ */

#endif /* GUSCFG_CODEC */
