/*
 *  @(#) obuffer.h 1.15, last edit: 13 Feb 1995 13:12:39
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OBUFFER_H
#define OBUFFER_H

#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>
#include "all.h"
#include "header.h"
extern "C" {
#include "audio_includes.h"
}

const uint32 OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
const uint32 MAXCHANNELS = 2;		// max. number of channels

// Abstract base class for audio output classes:
class Obuffer
{
public:
  virtual     ~Obuffer (void) {}		// dummy
  virtual void append (uint32 channel, int16 value) = 0;
	       // this function takes a 16 bit PCM sample
  virtual void write_buffer (int fd) = 0;
	       // this function should write the samples to the filedescriptor
	       // or directly to the audio hardware
	       // (obsolete for class which use signal handlers)
};

#include "obuffer_file.h"

#ifdef Indigo
#include "obuffer_irix.h"
#endif

#ifdef SPARC
#include "obuffer_sparc.h"
#endif

#ifdef HPUX
#include "obuffer_hp.h"
#endif

#ifdef LINUX
#include "obuffer_linux.h"
#endif

#ifdef NeXT
#include "obuffer_next.h"
#endif

#ifdef AIX
#include "obuffer_aix.h"
#endif

#endif
