struct trackinfo {
   int length;			/* Length of track in seconds or Kbytes */
   int start;			/* Starting position (f+s*75+m*60*75) */
   int volume;			/* Per-track volume (1-32, 0 to disable) */
   int track;			/* Physical track number */
   int section;			/* Section number (0 if track not split) */
   int contd;			/* Flag: continuation of previous track */
   int avoid;			/* Flag: don't play this track. */
   int data;			/* Flag: data track */
   char *name;			/* track name */
};

struct cdinfo_wm {
   int ntracks;			/* Number of tracks on the disc */
   int length;			/* Total running time in seconds */
   int autoplay;		/* Start playing CD immediately */
   int playmode;		/* How to play the CD */
   int volume;			/* Default volume (1-32, 0 for none) */
   char *name;			/* Album name */
   int tried;			/* Tried cddb info yet? */
   struct trackinfo *trk;	/* struct trackinfo[ntracks] */
   struct cdinfo *next;		/* For browsers, etc. */
};

/* The global variable "cd" points to the struct for the CD that's playing. */
extern struct cdinfo_wm *curcd;

enum cd_modes {
   UNKNOWN = -1,
   BACK = 0,
   TRACK_DONE = 0,
   PLAYING = 1,
   FORWARD = 2,
   PAUSED = 3,
   STOPPED = 4,
   EJECTED = 5
};

/*
 * Drive descriptor structure.  Used for access to low-level routines.
 */
struct wm_drive {
   int fd;			/* File descriptor, if used by platform */
   char vendor[16];		/* Vendor name */
   char model[24];		/* Drive model */
   void *aux;			/* Pointer to optional platform-specific info */
   void *daux;			/* Pointer to optional drive-specific info */

   int (*init) ();
   int (*get_trackcount) ();
   int (*get_cdlen) ();
   int (*get_trackinfo) ();
   int (*get_drive_status) ();
   int (*get_volume) ();
   int (*set_volume) ();
   int (*pause) ();
   int (*resume) ();
   int (*stop) ();
   int (*play) ();
   int (*eject) ();
};

/*
 * Each platform has to define generic functions, so may as well declare
 * them all here to save space.
 */
int gen_init(), gen_get_trackcount(), gen_get_cdlen(), gen_get_trackinfo(),
  gen_get_drive_status(), gen_get_volume(), gen_set_volume(), gen_pause(),
  gen_resume(), gen_stop(), gen_play(), gen_eject();
struct wm_drive *find_drive_struct();

extern void play_cd();
extern void stop_cd();
