
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include "../common.h"
#include "cd.h"
#include "struct.h"
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#include <pwd.h>

extern struct cdinfo_wm thiscd, *curcd;
extern int cur_cdmode;
char *cddb_host = NULL;
char *cddb_dir = NULL;
int cddb_port = 888;

int cddb_sum(int n)
{
   int ret = 0;

   while (n > 0) {
      ret += (n % 10);
      n /= 10;
   }
   return ret;
}

unsigned long cddb_discid(void)
{
   int i = 0, t = 0, n = 0;
   int min, sec;

   if ((!curcd) || (cur_cdmode == EJECTED))
      return 0;
   if (thiscd.name)
      Efree(thiscd.name);
   thiscd.name = NULL;
   while (i < thiscd.ntracks) {
      if (thiscd.trk[i].name)
	 free(thiscd.trk[i].name);
      thiscd.trk[i].name = NULL;
      min = thiscd.trk[i].start / (60 * 75);
      sec = (thiscd.trk[i].start % (60 * 75)) / 75;
      n += cddb_sum(min * 60 + sec);
      i++;
   }
   min = thiscd.trk[thiscd.ntracks].start / (60 * 75);
   sec = (thiscd.trk[thiscd.ntracks].start % (60 * 75)) / 75;
   t = min * 60 + sec;
   min = thiscd.trk[0].start / (60 * 75);
   sec = (thiscd.trk[0].start % (60 * 75)) / 75;
   t -= (min * 60 + sec);
   return ((n % 0xff) << 24 | t << 8 | thiscd.ntracks);
}

int read_cddb_file(unsigned long discid)
{
   FILE *f;
   char *filename;
   char s[256];

   if (!cddb_dir) {
      char *home = homedir(getuid());

      cddb_dir = Emalloc(strlen(home) + 20);
      sprintf(cddb_dir, "%s/.emusic/cddb", home);
      if (!exists(cddb_dir))
	 md(cddb_dir);
      Efree(home);
   }
   filename = Emalloc(strlen(cddb_dir) + 15);
   sprintf(filename, "%s/%08lx", cddb_dir, discid);
   f = fopen(filename, "r");
   Efree(filename);
   if (!f)
      return 0;
   while (fgets(s, 256, f)) {
      s[strlen(s) - 1] = '\0';
      if (s[0] != '#') {
	 if (!strncmp("DTITLE", s, 6))
	    thiscd.name = duplicate(s + 7);
	 else if (!strncmp("TTITLE", s, 6)) {
	    int track;

	    if (sscanf(s, "TTITLE%d=", &track) == 1) {
	       char *temp = strrchr(s, '=') + 1;

	       thiscd.trk[track].name = duplicate(temp);
	    }
	 }
      }
   }
   return 1;
}

void write_cddb_file(unsigned long discid)
{
   FILE *f;
   char *filename;
   int i;

   if (!thiscd.name)
      return;
   if (!cddb_dir) {
      char *home = homedir(getuid());

      cddb_dir = Emalloc(strlen(home) + 20);
      sprintf(cddb_dir, "%s/.emusic/cddb", home);
      if (!exists(cddb_dir))
	 md(cddb_dir);
      Efree(home);
   }
   filename = Emalloc(strlen(cddb_dir) + 15);
   sprintf(filename, "%s/%08lx", cddb_dir, discid);
   f = fopen(filename, "w");
   Efree(filename);
   if (!f)
      return;
   fprintf(f, "# xmcd CD Database Entry\n");
   fprintf(f, "#\n");
   fprintf(f, "# Track frame offsets:\n");
   i = 0;
   while (i < thiscd.ntracks) {
      fprintf(f, "# %u\n", thiscd.trk[i].start);
      i++;
   }
   fprintf(f, "#\n");
   fprintf(f, "# Disc length: %d seconds\n", thiscd.length);
   fprintf(f, "#\n");
   fprintf(f, "# Revision: 1\n");
   fprintf(f, "# Submitted via: eMusic %s\n", VERSION);
   fprintf(f, "#\n");
   fprintf(f, "DISCID=%08lx\n", discid);
   fprintf(f, "DTITLE=%s\n", thiscd.name);
   i = 0;
   while (i < thiscd.ntracks) {
      fprintf(f, "TTITLE%d=%s\n", i, thiscd.trk[i].name);
      i++;
   }
   fclose(f);
}

int readsock(int sockfd, char *string, int size)
{
   char c;
   int r = 0;
   int i = 0;

   while ((r = read(sockfd, &c, 1)) != 0) {
      if ((c == '\n') || (c == '\r') || (i > size))
	 break;
      string[i] = c;
      i++;
   }
   read(sockfd, &c, 1);
   string[i] = 0;
   return r;
}

void fill_cddb_data(unsigned long discid)
{
   int sockfd, len, result, i = 0;
   struct sockaddr_in address;
   struct hostent *hostinfo;
   char data[256];
   char temp[128];
   char categ[128], dtitle[128];
   char hostname[128];
   char *user;

   thiscd.tried = 1;
   discid = cddb_discid();
   if (!discid)
      return;
   if (read_cddb_file(discid))
      return;
   if (!cddb_host) {
      cddb_host = Emalloc(20);
      strcpy(cddb_host, "cddb.netwalk.com");
      cddb_port = 888;
   }
   memset(data, 0, 256);
   discid = cddb_discid();
   hostinfo = gethostbyname(cddb_host);
   if (!hostinfo) {
      fprintf(stderr, "cddb host, %s, doesn't exist\n", cddb_host);
      return;
   }
   sockfd = socket(AF_INET, SOCK_STREAM, 0);
   address.sin_family = AF_INET;
   address.sin_port = htons(cddb_port);
   address.sin_addr = *(struct in_addr *) *hostinfo->h_addr_list;
   len = sizeof(address);
   result = connect(sockfd, (struct sockaddr *) &address, len);
   if (result == -1) {
      fprintf(stderr, "Couldn't connect to cddb server\n");
      return;
   }
   readsock(sockfd, data, 128);
   if (strncmp(data, "20", 2)) {
      fprintf(stderr, "bad response..\n");
      close(sockfd);
      return;
   }
   gethostname(hostname, 128);
   if (!strcmp(hostname, ""))
      strcpy(hostname, "nowhere.com");
   user = username(getuid());
   sprintf(data, "cddb hello %s %s eMusic DR0.6-pre1\n",
	   user, hostname);
   write(sockfd, data, strlen(data));
   memset(data, 0, 256);
   readsock(sockfd, data, 128);
   if (strncmp(data, "200", 3)) {
      fprintf(stderr, "bad response from server.. %s\n", data);
      close(sockfd);
      return;
   }
   sprintf(data, "cddb query %08lx %d ", discid, thiscd.ntracks);
   while (i < thiscd.ntracks) {
      sprintf(temp, "%d ", thiscd.trk[i].start);
      strcat(data, temp);
      i++;
   }
   sprintf(temp, "%d\n", thiscd.length);
   strcat(data, temp);
   write(sockfd, data, strlen(data));
   memset(data, 0, 256);
   readsock(sockfd, data, 128);
   if (strncmp(data, "200", 3)) {
      fprintf(stderr, "no exact matches found, not setting track info..\n");
      close(sockfd);
      return;
   }
   sscanf(data, "200 %s %[^\n]", categ, temp);
   strcpy(data, temp);
   sscanf(data, "%s %[^\n]", temp, dtitle);
   thiscd.name = Emalloc(strlen(dtitle) + 2);
   strcpy(thiscd.name, dtitle);
   strcat(thiscd.name, "\0");
   sprintf(data, "cddb read %s %08lx\n", categ, discid);
   write(sockfd, data, strlen(data));
   memset(data, 0, 256);
   readsock(sockfd, data, 128);
   if (strncmp(data, "210", 3)) {
      fprintf(stderr, "odd, the server says the disc doesn't exist now\n");
      close(sockfd);
      return;
   }
   i = 0;
   while (i < thiscd.ntracks) {
      int r;
      char *badchar;

      memset(data, 0, 256);
      r = readsock(sockfd, data, 128);
      if (!r)
	 break;
      if ((badchar = strrchr(data, '\r')))
	 badchar = '\0';
      if (!strncmp(data, "TTITLE", 6)) {
	 char *temp2;
	 int temptrack;

	 sscanf(data, "TTITLE%d\n", &temptrack);
	 temp2 = strrchr(data, '=') + 1;
	 if (temptrack < i) {
	    thiscd.trk[temptrack].name = Erealloc(thiscd.trk[temptrack].name,
		      strlen(thiscd.trk[temptrack].name) + strlen(temp2) + 2);
	    strcat(thiscd.trk[temptrack].name, temp2);
	    strcat(thiscd.trk[temptrack].name, "\0");
	 }
	 else {
	    thiscd.trk[i].name = Emalloc(strlen(temp2) + 2);
	    strcpy(thiscd.trk[i].name, temp2);
	    strcat(thiscd.trk[i].name, "\0");
	    i++;
	 }
      }
   }
   close(sockfd);
   write_cddb_file(discid);
   return;
}
