
#include "../emusic.h"

char *tempskindir;

ImlibImage *LoadImlibImage(char *path)
{
   ImlibImage *im;

   EDBUG(5, "LoadImlibImage");
   if (!(im = Imlib_load_image(imlib, path))) {
      fprintf(stderr, "Something is deathly wrong..  \nI couldn't load %s\n", path);
      exit(-1);
   }
   Imlib_render(imlib, im, im->rgb_width, im->rgb_height);
   EDBUG_RETURN(im);
}

int ProcessImage(char *image, char *dest, int x, int y, int w, int h)
{
   char *orig, *temp, *s;

   EDBUG(5, "ProcessImage");
   orig = Emalloc(strlen(origskin) + strlen(image) + 256);
   s = FindFile(image, origskin);
   sprintf(orig, "%s", s);
   Efree(s);
   if (strcmp(orig, "(null)")) {
      ImlibImage *im;

      temp = Emalloc(strlen(origskin) + strlen(orig) + 2);
      sprintf(temp, "%s/%s", origskin, orig);
      im = LoadImlibImage(temp);
      Imlib_crop_image(imlib, im, x, y, w, h);
      temp = Erealloc(temp, strlen(tempskindir) + strlen(dest) + 2);
      sprintf(temp, "%s/%s", tempskindir, dest);
      Imlib_save_image_to_ppm(imlib, im, temp);
      Imlib_destroy_image(imlib, im);
      Efree(orig);
      Efree(temp);
      EDBUG_RETURN(1);
   }
   Efree(orig);
   fprintf(stderr, "No %s in skin, falling back to Base\n", image);
   EDBUG_RETURN(0);
}

void ConvertSetPath(char *temp)
{
   tempskindir = duplicate(temp);
}

void ConvertFreePath(void)
{
   Efree(tempskindir);
}
