.\" @(#)$Mu: imgvtopgm/imgvinfo.man 1.14 1998/03/27 06:20:52 $
.\"
.\" imgvinfo.man
.\"	Man page for imgvinfo.
.\"
.\" Copyright (C) 1997 Eric A. Howe
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\"   Authors:  Eric A. Howe (mu@trends.net)
.\"
.TH IMGVINFO 1 "Sept 1997"
.\"----------------------------------------------------------------------------
.SH NAME
imgvinfo \- extract and display interesting things from a Pilot Image Viewer pdb header, version @@VERSION@@.
.\"----------------------------------------------------------------------------
.SH SYNOPSIS
.B imgvinfo
.RI [ -h ]
.RI [ -v ]
.RI [ "-t fmt" ]
.RI [ "-{u|l}" ]
.RI [ "in " [ "..." ]]
.\"----------------------------------------------------------------------------
.SH DESCRIPTION
\fBimgvinfo\fR is a simple tool for extracting and displaying a couple things
from a Pilot Image Viewer pdb file; the name, creation time, last modified
time, last backup time, version, type, last position, anchor position,
image size, and the note (if present) are extracted and printed on the
standard output.
.PP
The \fIcreation time\fR and \fImod time\fR are incorrect most of the time;
all of the Image Viewer pdb files that I've come across have
\fI1907-08-16 19:38:22\fR (UTC) here and that makes no sense at all.  However,
if you've created an image pdb with \fBpgmtoimgv\fR(1) or \fBpbmtoimgv\fR(1),
these times will be correct.
.PP
This program was originally written to test some .pdb header parsing code
but it may be a usefull little tool anyway.
.\"----------------------------------------------------------------------------
.SH OPTIONS
.TP
.I -h
Display a short usage message and exit.
.TP
.I -v
Display the version and exit.
.TP
.I -t fmt
Specify the time format.  The default is "%Y-%m-%d %H:%M:%S" (the ISO8601
standard).  See \fBstrftime\fR(3) for the available format codes.
.TP
.I -u
Output times in UTC rather than the local time zone.
.TP
.I -l
Output times in the local time zone (default).
.TP
.I in
The input file.  The standard input is read by default.  A file name of
\fI-\fR means the standard input.
.\"----------------------------------------------------------------------------
.SH "SEE ALSO"
.BR imgvtopnm (1),
.BR imgvview (1),
.BR pbmtoimgv (1),
.BR pgmtoimgv (1),
.BR ppmimgvquant (1),
.BR pbm (5),
.BR pgm (5).
.\"----------------------------------------------------------------------------
.SH BUGS
Bug reports should be sent to Eric A. Howe (mu@trends.net).
.\"----------------------------------------------------------------------------
.SH LICENSE
Copyright (C) 1997 Eric A. Howe <http://www.trends.net/~mu>.
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but \fBWITHOUT ANY WARRANTY\fR; without even the implied warranty of
\fBMERCHANTABILITY\fR or \fBFITNESS FOR A PARTICULAR PURPOSE\fR.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
