/*
 * plan server data structures. Do not modify this file unless you want to
 * change the sources; user-configurable definitions are in netplan_if.h.
 *
 * The server maintains a list of files currently open for connected clients.
 * Each file keeps a list of clients (one boolean per socket fd, true means the
 * socket is connected to a client) and a list of rows. Each row is an ascii
 * string as found in the file on disk, it's the client's job to interpret it.
 * Rows have unique ID numbers, and are sorted by ID number; this allows the
 * server to identify modified rows sent by a client. ID 0 is reserved for new
 * rows created by clients; the client gets an official row ID from the server.
 */

typedef char	BOOL;			/* boolean, 0 or 1 */
#ifndef TRUE
#define FALSE	0
#define TRUE	1
#endif

struct pfile {
	char		*name;		/* file name, 0=not open */
	BOOL		readonly;	/* file is read-only */
	BOOL		modified;	/* a row has been modified */
	BOOL		error;		/* file failed to write */
	int		type;		/* file type: 0=plan, 1=grok */
	int		nclients;	/* number of connected clients */
	BOOL		*client;	/* 1=connected readonly,
					   2=connected read/write,
					   3=connected & modified */
	int		maxrows;	/* current size or rows array */
	int		nrows;		/* number of valid rows */
	struct row	*row;		/* list of rows in file or 0 */
};

struct row {
	char		*data;		/* data string, \n\0-terminated */
	unsigned int	id;		/* unique row ID (row sort criterium)*/
	int		lock_fd;	/* client that has locked row, or 0 */
	BOOL		modified;	/* row has been modified */
};

#define MSGBUFSZ	1024		/* client message buffer page */
#define MAXMSGSZ	1048576		/* reject huge messages to prevent */
					/* denial-of-service attacks, set to */
					/* 0 to allow unlimited message size */

struct buffer {
	char		*data;		/* incoming/outgoing message */
	int		enq;		/* next free byte in buf[] */
	int		deq;		/* next free byte in buf[] */
	int		max;		/* size of buf[] */
};

struct client {
	time_t		time;		/* connect time */
	char		*descr;		/* client-provided self-description */
	char            *user;          /* user name if authenticated */
	unsigned int	uid;	        /* client-provided user/group ID */
	int             gids[NGROUPS_MAX];/* group access list */
	BOOL            auth_fail;	/* required identd check failed */
	struct sockaddr_in addr;	/* contains IP addr and port */
	int		type;		/* client type: 0=plan, 1=grok */
	struct buffer	in;		/* incoming message */
	struct buffer	out;		/* outgoing message */
	BOOL		esc;		/* pending backslash */
};


/*
 * prototypes for function definitions in netplan_acl.c
 */

extern void acl_exit(void);
extern int acl_read(const char *fname);
extern int acl_write(const char *fname);
extern void acl_verify(int *r, int *w, int *d, char *name, struct client *c);
extern char *ident_id(int fd);

#ifndef S_IFDIR			/* some Linuces hide this */
#define S_IFDIR	040000		/* I'll hate myself for this */
#endif				/* in the morning... */
