/*  xxXTideRoot  XTide "root" window (control panel, top-level logic)
    Last modified 1998-06-02

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class xxXTideRoot {

  friend void RootCloseHandler (Widget w, XtPointer client_data,
    XEvent *event, Boolean *continue_dispatch);

public:
  xxXTideRoot (int in_argc, char **in_argv);
  void mainloop();
  ~xxXTideRoot ();

  void newHelpBox (const Dstr &help);
  void newGraph (Station *s, Timestamp t);
  void newGraph (StationRef *sr); // Default to now
  void newText (Station *s, Timestamp t);
  void newClock (Station *s, int nobuttonsflag = 1);
  // The grabkind here is for the title screen if one is needed.
  void newChooser (XtGrabKind in_grabkind = XtGrabExclusive);

  // Start clock, graph, or plain windows as requested on command line.
  void newWindows (CommandLineSettings *cls);

  // These are only used in xxWindow.
  // Increment count of pop-ups.
  void dup(xxWindow *child);
  // Decrement count of pop-ups, and exit when zero.
  void release (xxWindow *child);

  struct cnode {
    xxWindow *child;
    struct cnode *next;
  };

  void show();          // Make control panel visible.
  void hide();          // Make control panel invisible.
  void global_redraw(); // Redraw all windows.
  void apply (int saveflag = 0);

protected:
  void dup();
  void release(int is_title_screen);
  void release (xxContext *child, int is_title_screen);
  void addTwoButtons();
  xxXTideRoot::cnode *children;
  unsigned numpopups;
  xxContext *mycontext, *box, *dismissbutton, *helpbutton, *label,
    *applybutton, *savebutton;
  xxMultiChoice *elchoice, *nfchoice, *tlchoice, *zchoice, *uchoice,
    *glchoice;
  xxHorizDialog *colordiags[numcolors], *dfdiag, *hfdiag, *tfdiag;
  xxUnsignedChooser *gwchoice, *ghchoice, *cwchoice, *twchoice,
    *thchoice;
  xxHorizDialog *gadiag, *lwdiag;
  xxTideContext *myTideContext;
  UserDefaults *ud;
  int sancheckdouble (char *d);
};
