/* sounding.c */

/* Vis5D version 4.3 */

/*
Vis5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990 - 1997 Bill Hibbard, Johan Kellum, Brian Paul,
Dave Santek, and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * This plots temperature and dewpoint on a skew-t or
 * plots up to three vertical plots of any variable
 */





#include <math.h>
#include "../lui5/lui.h"
#include <stdlib.h>
#include <strings.h>
#include "globals.h"
#include "graphics.h"
#include "grid.h"
#include "memory.h"
#include "proj.h"
#include "gui.h"
#include "sounding.h"
#include "soundingGUI.h"
#ifdef OPENGL
#  include <GL/gl.h>
#endif
#if defined(SGI_GL) || defined(DENALI)
#  include <gl/gl.h>
#endif
#include "vis5d.h"

void make_lui_stuff( int index );

static int thtaapply_cb( LUI_NEWBUTTON *b, int state );

static int thteapply_cb( LUI_NEWBUTTON *b, int state );

static int wapply_cb( LUI_NEWBUTTON *b, int state );

static int tickapply_cb(LUI_NEWBUTTON *b, int state );

static int sndapply_cb( LUI_NEWBUTTON *b, int state );

static void read_snd_widgets( int index );

static void load_snd_widgets( int index);



    /**********************************************************************/
    /* This makes all of the fancy gui labels and widgets                 */
    /**********************************************************************/
    /* Input: index - index of context                                    */
    /**********************************************************************/


void make_lui_stuff( int index )
{
   GuiContext gtx = get_gui_gtx(index);
   LUI_NEWBUTTON *b, *sndapply, *thtaapply, *thteapply, *wapply, *tickapply;
   Window w, sm1, sm2, sm3;
   int xover;

   w = gtx->SoundCtrlWindow;
   

   LUI_BorderWidth(2);
   if ((gtx->vertsys > 0) && (gtx->oceanonly != 1)){
      LUI_NewLabelCreate(w, LUI_LEFT, LUI_TOP, 175, 20, "Temperature Variable:" );
      gtx->snd_temp = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );
      b = LUI_ToggleButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y,
                                 100, 20, "Theta Lines");
      LUI_ButtonCallback( b, thtaapply_cb);
      LUI_ButtonIndex( b, 0);
      LUI_ButtonColor( b, .8, .196, .196);
      gtx->thta_button = b;
      LUI_NewLabelCreate(w, LUI_NEXT_X, LUI_SAME_Y, 175, 20, "Vertical Plot Var 1:");
      gtx->snd_var1 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );



      LUI_NewLabelCreate(w, LUI_LEFT, LUI_NEXT_Y, 175, 20, "Dewpoint Variable:" );
      gtx->snd_dewpt = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );
      b = LUI_ToggleButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y,
                                 100, 20, "Thete Lines");
      LUI_ButtonCallback( b, thteapply_cb);
      LUI_ButtonIndex( b, 0);
      LUI_ButtonColor( b, .0392, .549, .2157);
      gtx->thte_button = b;
      LUI_NewLabelCreate(w, LUI_NEXT_X, LUI_SAME_Y, 175, 20, "Vertical Plot Var 2:");
      gtx->snd_var2 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );

 

      LUI_NewLabelCreate(w, LUI_LEFT, LUI_NEXT_Y, 175, 20, "U Wind Variable:" );
      gtx->snd_u_wind = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );
      b = LUI_ToggleButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y,
                                 100, 20, "  W Lines  ");
      LUI_ButtonCallback( b, wapply_cb);
      LUI_ButtonIndex( b, 0);
      LUI_ButtonColor( b, 1, 1, 0);
      gtx->w_button = b;
      LUI_NewLabelCreate(w, LUI_NEXT_X, LUI_SAME_Y, 175, 20, "Vertical Plot Var 3:");
      gtx->snd_var3 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );

   

      LUI_NewLabelCreate(w, LUI_LEFT, LUI_NEXT_Y, 175, 20, "V Wind Variable:" );
      gtx->snd_v_wind = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );

      /*Link the fields together for TABing */
      LUI_FieldLink( gtx->snd_temp, gtx->snd_dewpt);
      LUI_FieldLink( gtx->snd_dewpt,gtx->snd_u_wind);
      LUI_FieldLink( gtx->snd_u_wind,gtx->snd_v_wind);
      LUI_FieldLink( gtx->snd_v_wind, gtx->snd_var1);
      LUI_FieldLink( gtx->snd_var1, gtx->snd_var2);
      LUI_FieldLink( gtx->snd_var2, gtx->snd_var3);

      b = LUI_ToggleButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y,
                              145, 20, "Show Tick Marks");
      LUI_ButtonCallback( b, tickapply_cb);
      LUI_ButtonIndex( b, 0);
      LUI_ButtonColor( b, 1, 1, 1);
      gtx->tick_button = b;

      sndapply = LUI_PushButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y, 66, 20, " APPLY");
      LUI_ButtonCallback(sndapply, sndapply_cb );
   }
   else{
      LUI_NewLabelCreate(w, LUI_LEFT, LUI_TOP, 175, 20, "Vertical Plot Var 1:");
      gtx->snd_var1 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );



      LUI_NewLabelCreate(w, LUI_LEFT, LUI_NEXT_Y, 175, 20, "Vertical Plot Var 2:");
      gtx->snd_var2 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );



      LUI_NewLabelCreate(w, LUI_LEFT, LUI_NEXT_Y, 175, 20, "Vertical Plot Var 3:");
      gtx->snd_var3 = LUI_FieldCreate(w, LUI_NEXT_X, LUI_SAME_Y, 80, 20 );

  

      /*Link the fields together for TABing */
      LUI_FieldLink( gtx->snd_var1, gtx->snd_var2);
      LUI_FieldLink( gtx->snd_var2, gtx->snd_var3);

      b = LUI_ToggleButtonCreate(w, LUI_LEFT, LUI_NEXT_Y,
                              165, 20, "Vertical Plot Ticks");
      LUI_ButtonCallback( b, tickapply_cb);
      LUI_ButtonIndex( b, 0);
      LUI_ButtonColor( b, 1, 1, 1);
      gtx->tick_button = b;

      sndapply = LUI_PushButtonCreate(w, LUI_NEXT_X, LUI_SAME_Y, 66, 20, " APPLY");
      LUI_ButtonCallback(sndapply, sndapply_cb );
   }

   if ((gtx->vertsys > 0) && (gtx->oceanonly != 1)){
      xover = 0;
   }
   else {
      xover = 364;
   }
   sm1 = XCreateSimpleWindow(GuiDpy, gtx->SoundCtrlWindow, 529-xover, 4,
                       12, 15, 1, LUI_AllocateColorInt(0,0,0),
                       LUI_AllocateColorInt(0, 255, 0));
   sm3 = XCreateSimpleWindow(GuiDpy, gtx->SoundCtrlWindow, 529-xover, 50,
                       12, 15, 1, LUI_AllocateColorInt(0,0,0),
                       LUI_AllocateColorInt(255, 255, 100));
   sm2 = XCreateSimpleWindow(GuiDpy, gtx->SoundCtrlWindow, 529-xover, 27,
                       12, 15, 1, LUI_AllocateColorInt(0,0,0),
                       LUI_AllocateColorInt(100, 255, 255));
   XMapWindow(GuiDpy, sm1);
   XMapWindow(GuiDpy, sm2);
   XMapWindow(GuiDpy, sm3);

}

    /**********************************************************************/
    /* This makes the main sounding window, where the gui stuff is added  */
    /* and where the ctx->Soundwin is mapped to.                          */
    /**********************************************************************/
    /* Input: index - index of context                                    */
    /*        xpos, ypos - coordinates for where to put the screen        */
    /*        width, height - dimensions for the window                   */
    /**********************************************************************/

void make_sound_window(int index, int xpos, int ypos, int width, int height )
{
   XSetWindowAttributes attr;
   XSizeHints sizehints;
   XGCValues values;
   GuiContext gtx = get_gui_gtx(index);
   int attr_flags;
   Window w, sm1, sm2, sm3;
   XWindowAttributes xa, xa2;
   int xover;


   /* first make the Sounding Control window */
   w = LUI_CreateWindowAt( LUI_RootWindow, xpos, ypos, width, height);
   gtx->SoundCtrlWindow = w;



   sizehints.x = 50;
   sizehints.y = 50;
   sizehints.width = width;
   sizehints.height= height;
   sizehints.max_height = 5500;
   sizehints.max_width = 5500;
   sizehints.flags = USSize | USPosition;
   XSetStandardProperties( GuiDpy, gtx->SoundCtrlWindow,
                           "Skew-T and Vertical Plot Display",
                           "Skew-T and Vertical Plot Display",
                            None, (char**)NULL, 0, &sizehints);
   XSetNormalHints(GuiDpy, gtx->SoundCtrlWindow, &sizehints);
   XSelectInput( GuiDpy, gtx->SoundCtrlWindow, ExposureMask 
                | ButtonPressMask | ButtonReleaseMask
                | StructureNotifyMask
                | VisibilityChangeMask );

   /* Now add fancy options stuff at top of Sound Window  */
   make_lui_stuff(index);
   load_snd_widgets(index);
   read_snd_widgets( index );
   vis5d_draw_sounding_only( index, 1 );
}

static int thtaapply_cb( LUI_NEWBUTTON *b, int state )
{
   int index = b->context_index;
   GuiContext gtx = get_gui_gtx(index);
   int onoroff;

   vis5d_graphics_mode( index, VIS5D_SND_THTA, VIS5D_TOGGLE);
   vis5d_draw_sounding_only( index, 1 );
}

static int thteapply_cb( LUI_NEWBUTTON *b, int state )
{
   int index = b->context_index;
   GuiContext gtx = get_gui_gtx(index);
   int onoroff;

   vis5d_graphics_mode( index, VIS5D_SND_THTE, VIS5D_TOGGLE);
   vis5d_draw_sounding_only( index, 1 );
}

static int wapply_cb( LUI_NEWBUTTON *b, int state )
{
   int index = b->context_index;
   GuiContext gtx = get_gui_gtx(index);
   int onoroff;

   vis5d_graphics_mode( index, VIS5D_SND_W, VIS5D_TOGGLE);
   vis5d_draw_sounding_only( index, 1 );
}

static int tickapply_cb(LUI_NEWBUTTON *b, int state )
{
   int index = b->context_index;
   GuiContext gtx = get_gui_gtx(index);
   int onoroff;

   vis5d_graphics_mode( index, VIS5D_SND_TICKS, VIS5D_TOGGLE);
   vis5d_draw_sounding_only( index, 1 );
}




static int sndapply_cb( LUI_NEWBUTTON *b, int state )
{
   int index = b->context_index;
   GuiContext gtx = get_gui_gtx(index);

   read_snd_widgets( index );
   vis5d_draw_sounding_only( index, 1 );

   return 0;
}

static void read_snd_widgets( int index )
{
   GuiContext gtx = get_gui_gtx(index);
   char  varname[20];
   int var1, var2, var3, tmperature, uwnd, vwnd, dewpnt;
   
   LUI_FieldGetText( gtx->snd_var1, varname);
   var1 = vis5d_find_var(index, varname );
   if (var1 == VIS5D_FAIL){
      var1 = -1;
   }
   LUI_FieldGetText( gtx->snd_var2, varname);
   var2 = vis5d_find_var(index, varname );
   if (var2 == VIS5D_FAIL || var2 == var1){
      var2 = -1;
   }
   LUI_FieldGetText( gtx->snd_var3, varname);
   var3 = vis5d_find_var(index, varname );
   if (var3 == VIS5D_FAIL || var3 == var2 || var3 == var1){
      var3 = -1;
   }
   if ((gtx->vertsys != 0) && (gtx->oceanonly != 1)){
      LUI_FieldGetText( gtx->snd_temp, varname );
      tmperature = vis5d_find_var( index, varname );
      if (tmperature == VIS5D_FAIL){
         tmperature = -1;
      }
      LUI_FieldGetText( gtx->snd_u_wind, varname );
      uwnd = vis5d_find_var( index, varname );
      if ( uwnd == VIS5D_FAIL){
         uwnd; 
      }
      LUI_FieldGetText( gtx->snd_v_wind, varname );
      vwnd = vis5d_find_var( index, varname );
      if (vwnd == VIS5D_FAIL){
         vwnd = -1;
      }
      LUI_FieldGetText( gtx->snd_dewpt,varname );
      dewpnt= vis5d_find_var( index, varname );
      if (dewpnt == VIS5D_FAIL){
         dewpnt = -1;
      }
   }
   if ((gtx->vertsys == 0) || (gtx->oceanonly == 1)){
      tmperature = -1;
      dewpnt = -1;
      uwnd = -1;
      vwnd = -1;
   }
   vis5d_set_sound_vars( index, tmperature, dewpnt, uwnd, vwnd, var1, var2, var3 );
   load_snd_widgets(index);

}

static void load_snd_widgets( int index)
{
   GuiContext gtx = get_gui_gtx(index);
   char varname[20];
   int u, v, t, d, var1, var2, var3;


   vis5d_get_sound_vars( index, &t, &d, &u, &v, &var1, &var2, &var3);



   if (var1 >= 0){
      vis5d_get_var_name( index, var1, varname);
   }
   else {
      varname[0] = 0;
   }
   LUI_FieldSetText( gtx->snd_var1, varname);




   if (var2 >= 0){
      vis5d_get_var_name( index, var2, varname);
   }
   else {
      varname[0] = 0;
   }
   LUI_FieldSetText( gtx->snd_var2, varname);




   if (var3 >= 0){
      vis5d_get_var_name( index, var3, varname);
   }
   else {
      varname[0] = 0;
   }
   LUI_FieldSetText( gtx->snd_var3, varname);



   if((gtx->vertsys != 0) && (gtx->oceanonly != 1)){
      if (t >= 0){
         vis5d_get_var_name( index, t, varname);
      }
      else {
         varname[0] = 0;
      }
      LUI_FieldSetText( gtx->snd_temp, varname );
   


      if (d >= 0){
         vis5d_get_var_name( index, d, varname);
      }
      else {
         varname[0] = 0;
      }
      LUI_FieldSetText( gtx->snd_dewpt, varname);



      if (u >= 0){
         vis5d_get_var_name( index, u, varname);
      }
      else{
         varname[0] = 0;
      }
      LUI_FieldSetText( gtx->snd_u_wind, varname);


      if (v >= 0){
         vis5d_get_var_name(index, v, varname );
      }
      else{
         varname[0] = 0;
      }
      LUI_FieldSetText( gtx->snd_v_wind, varname );
   }
}
