/* $Id: gui.h,v 1.39 1996/07/23 18:34:45 billh Exp johan $ */

/* VIS-5D version 4.2 */

/*
Vis5D system for visualizing five dimensional gridded data sets
Copyright (C) 1990 - 1996 Bill Hibbard, Brian Paul, Dave Santek,
and Andre Battaiola.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef GUI_H
#define GUI_H


#include <stdio.h>
#include "../lui5/lui.h"
#include "matrix.h"
#include "vis5d.h"
#include "v5d.h"



struct gui_context {
  int context_index;           /* index of this context */
  int GoTime;          /* animate flag (0=off, -1=backward, 1=forward) */
  int AnimRate;        /* minimum time between animation steps in msec */

   /* from gui.c */
  Window  mainwin;          /* the main 3-D viewing window */

#ifdef DENALI
  Window NPGLwin;        /* Window ID of NPGL window */
#endif
  Window  CpWindow;      /* the control panel window */
  Window  fakewin;       /* fake 3-D window */
  int fakewidth, fakeheight;  /* size of fake 3-D window */
  int MouseMode;

  /* Miscellaneous windows */
  Window CloneWindow;
  int CloneWidth, CloneHeight;
  int CpHeight, cpx, cpy;
  int Columns;   /* 5 or 6 button columns, button width */
  int RGBWidth, RGBHeight;

  /* Main window */
  LUI_NEWBUTTON *hwind_button[VIS5D_WIND_SLICES];
  LUI_NEWBUTTON *vwind_button[VIS5D_WIND_SLICES];
  LUI_NEWBUTTON *hstream_button[VIS5D_WIND_SLICES];
  LUI_NEWBUTTON *vstream_button[VIS5D_WIND_SLICES];

  LUI_BUTTON *map_button;
  LUI_BUTTON *perspec_button;

  LUI_BUTTON_MATRIX *ButtonMatrix;
  int ButtonMatrixTop;
  int ButtonMatrixWidth, ButtonMatrixHeight;
  int ColorRow, ColorCol;  /* Which button in the matrix to recolor */
  LUI_LABEL *ModeInfoLabel;

  /* Isolevel window */
  Window IsoWindow;
  int IsosurfHeight, IsosurfWidth;
  LUI_NEWSLIDER *IsoSlider;

  /* Horizontal slice contour interval window */
  Window HSliceWindow;
  LUI_NEWLABEL *hslice_label;
  LUI_FIELD *hslice_field;

  /* Vertical slice contour interval window */
  Window VSliceWindow;
  LUI_NEWLABEL *vslice_label;
  LUI_FIELD *vslice_field;

  /* H/V Wind Slice scale/density Window */
  Window WindWindow;
  LUI_NEWLABEL *windscale_label, *winddensity_label;
  LUI_FIELD *windscale_field, *winddensity_field;

  /* Type-in Expression window */
  Window ExprWindow;
  LUI_FIELD *expr_field;
  char Expression[500];   /* Current expression: */

  /* Save window: */
  Window SaveWindow;
  LUI_FIELD *SaveNameField;

  /* Restore window: */
  Window RestoreWindow;
  LUI_FIELD *RestoreNameField;

  /* Save window image: */
  Window SavePicWindow;
  LUI_FIELD *SavePicField;
  LUI_RADIO *SavePicRadio;
  int SaveFormats[6];      /* image file format for each button displayed */

  /* Trajectory window */
  Window TrajWindow;
  LUI_FIELD *TrajStepField, *TrajLenField;
  LUI_BUTTON *TrajButton[VIS5D_TRAJ_SETS];
  LUI_NEWBUTTON *TrajRibbonButton;

  /* Sounding window */
  int othersnddpy;                 /* 1 if '-wdpy' swith is invoked                    */
  int vertsys;                     /* This describes the vertical coordinate system    */
                                   /* If it is 0 then it is not in kilometers          */
  int oceanonly;                   /* this say if the data is ocean data only or not   */
                                   /* if it is 0 then it is not just ocean data        */

  Window SoundCtrlWindow;          /* This is the main control window for the sounding */
  LUI_FIELD *snd_temp, *snd_dewpt,
            *snd_u_wind, *snd_v_wind,
            *snd_var1, *snd_var2,
            *snd_var3;
  LUI_NEWBUTTON *thta_button, *thte_button,
                *w_button, *tick_button;


 
  /* Verify and Alert windows */
  Window VerifyWindow, AlertWindow;
  int VerifyHeight, AlertHeight;
  LUI_NEWLABEL *VerifyLabel, *AlertLabel;

  /* RGB color sliders window */
  Window rgb_sliders_window;
  LUI_NEWLABEL *rgb_sliders_label;
  LUI_NEWSLIDER *rgb_red_slider;
  LUI_NEWSLIDER *rgb_green_slider;
  LUI_NEWSLIDER *rgb_blue_slider;
  LUI_NEWSLIDER *rgb_alpha_slider;

  /* Isosurface/Trajectory coloring window */
  Window isocolor_window;
  Window isocolor_subwin1;
  Window isocolor_subwin2;
  LUI_BUTTON_MATRIX *iso_button_matrix;
  LUI_NEWLABEL *isocolor_label;
  LUI_NEWSLIDER *iso_red_slider;
  LUI_NEWSLIDER *iso_green_slider;
  LUI_NEWSLIDER *iso_blue_slider;
  LUI_NEWSLIDER *iso_alpha_slider;
  LUI_COLORBAR *iso_colorbar;

  /* UVW widget window */
  Window uvw_window;
  LUI_FIELD *traju_field, *trajv_field, *trajw_field;
  LUI_FIELD *u1_field, *v1_field, *w1_field;
  LUI_FIELD *u2_field, *v2_field, *w2_field;
  int traju_var, trajv_var, trajw_var;
  int u1_var, v1_var, w1_var;
  int u2_var, v2_var, w2_var;

  /* Color slice, volume, topo widget: */
  LUI_COLORBAR *Colorbar;

  /* The 'current' isosurf, slice, etc. is the one whose slider window,
     color widget window, etc. is currently displayed.  This is independent
     of whether a graphic is being displayed because you can, for example,
     change the color of a slice while it's not displayed.  */
  int cur_isosurf;
  int cur_hslice;
  int cur_vslice;
  int cur_trajset;
  int cur_hwind;
  int cur_vwind;
  int cur_hstream;
  int cur_vstream;

  int edit_topo;   /* non-zero when editing topo colors */

  /* labels.c */
  int label_state;
  int label_start_x, label_start_y;

  /* from func1 */
  int widget_enable;

  /* from get_user_input */
  int  start_x, start_y, p1, p2, p3;
  MATRIX  ctm;
  float zoom;

  /* external function stuff */
  char funcpath[1000];
};


typedef struct gui_context *GuiContext;



extern Display *GuiDpy;         /* The X display for the GUI */
extern int GuiScr;              /* The X screen number for the GUI */
extern Visual *GuiVisual;       /* The X visual for the GUI */
extern Colormap GuiColormap;    /* The X colormap for the GUI */
extern int GuiDepth;            /* The depth of the GUI visual */




extern GuiContext get_gui_gtx( int index );

extern GuiContext create_gui_context( int index );

extern int make_gui( int index, char *dataset, char *wdpy_name, int volflag );

extern int get_user_input( int block );

extern void update_var( int index, int newvar );

extern void set_slice_alpha( int index, int graphic, int var, int alpha );

extern int make_new_buttons_after_interp( int index, int number_of_new_buttons );

#endif
