
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include "../siod/siod.h"
#include "../siag/types.h"
#include "../siag/calc.h"
#include "../common/cmalloc.h"
#include "../xcommon/xfonts.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/embed.h"
#include "../xcommon/plugin.h"
#include "../xcommon/filesel.h"
#include "xsiag.h"

int select_file(char *path, char *name, char *patterns[], char *fmt)
{
	char extra[1024];
	sprintf(extra, "Home=%s:Examples=%s/examples/siag",
		getenv("HOME"), siagdocs);
	return fsel_input(topLevel, path, name, patterns, fmt,
		extra);
}

int alert_box(char *text, char *buttons[], int nbuttons)
{
	return alertbox(topLevel, text, buttons, nbuttons);
}

int select_from_list(char *text, char *choices[], int nchoices)
{
	return listsel(topLevel, text, choices, nchoices);
}

void error_box(char *message)
{
	errorbox(topLevel, message);
}

#ifdef GUILE
static void execute_guile_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);

        exec_expr(name2interpreter("guile"), b);
}
#endif	/* GUILE */

static void execute_siod_action(Widget w, XEvent * event,
                           String * params, Cardinal * num_params)
{
        char b[256];
        int i;

        strcpy(b, "(");
        strncat(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        strncat(b, ")", 255);
        exec_expr(siod_interpreter, b);
}

#ifdef TCL
static void execute_tcl_action(Widget w, XEvent *event,
                           String *params, Cardinal *num_params)
{
        char b[256];
        int i;

        strncpy(b, params[0], 255);
        for (i = 1; i < *num_params; i++) {
                strncat(b, " ", 255);
                strncat(b, params[i], 255);
        }
        exec_expr(name2interpreter("tcl"), b);
}
#endif	/* TCL */

static XtActionsRec actions[] =
{
#ifdef GUILE
        {"guile", execute_guile_action},
#endif
	{"execute", execute_siod_action},
#ifdef TCL
	{"tcl", execute_tcl_action}
#endif
};

/* a wrapper around XGetGeometry */
/* returns the list (x y width height border_width depth) */
static LISP get_geometry(void)
{
        Window root, cell_win = xwindow_of_window(w_list);
        int x, y;
        unsigned int width, height, border_width, depth;
        LISP result;

        XGetGeometry(XtDisplay(topLevel), cell_win, &root, &x, &y, &width, &height,
                     &border_width, &depth);

        result = cons(flocons(depth), NIL);
        result = cons(flocons(border_width), result);
        result = cons(flocons(height), result);
        result = cons(flocons(width), result);
        result = cons(flocons(y), result);
        result = cons(flocons(x), result);

        return result;
}

static LISP fit_block_width(void)
{
        int r, c, font_index, text_width;
        char *p;

        if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
                block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
                        return NIL;

        for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
                set_width(buffer_of_window(w_list), c, 10);
                for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
                        font_index = ret_font(buffer_of_window(w_list), r, c);
                        p = ret_pvalue(NULL, buffer_of_window(w_list), r, c, -1);
                        text_width = XTextWidth(font_struct(XtDisplay(topLevel), font_index),
                                        p, strlen(p)) + 10;
                        if (text_width > cell_width(buffer_of_window(w_list), c))
                                set_width(buffer_of_window(w_list), c, text_width);
                }
        }
        pr_scr_flag = 1;
        return NIL;
}

static LISP fit_block_height(void)
{
        int r, c, font_index, text_height;
        char *p;

        if (block_upper(w_list).row < 1 || block_upper(w_list).col < 1 ||
                block_lower(w_list).row < 1 || block_lower(w_list).col < 1)
                        return NIL;

        for (r = block_upper(w_list).row; r <= block_lower(w_list).row; r++) {
                set_height(buffer_of_window(w_list), r, 10);
                for (c = block_upper(w_list).col; c <= block_lower(w_list).col; c++) {
                        font_index = ret_font(buffer_of_window(w_list), r, c);
                        p = ret_pvalue(NULL, buffer_of_window(w_list), r, c, -1);
                        text_height = font_height(XtDisplay(topLevel), font_index) + 10;
                        if (text_height > cell_height(buffer_of_window(w_list), r))
                                set_height(buffer_of_window(w_list), r, text_height);
                }
        }
        pr_scr_flag = 1;
        return NIL;
}

static LISP lembed_object(void)
{
        char file[256], *tag;
        char *i;
        unsigned int width, height;
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;
	cval value;
	value.text = NULL;

        if (ret_type(buf, row, col) == EMBED) {
                llpr("Can't overwrite embedded object");
                return NIL;
        }

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        tag = embed_load(file);
        if (tag == NULL) return NIL;

        i = tag;
        if (!i) return NIL;

        embed_size(tag, &width, &height);
        /* don't change cell width and/or height */

        undo_save(buf, row, col, row, col);
        ins_data(buf, siod_interpreter, i, value, EMBED, row, col);

        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_remove(void)
{
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;
	cval value;
	value.number = 0;

        if (ret_type(buf, row, col) == EMBED) {
                undo_save(buf, row, col, row, col);
                ins_data(buf, siod_interpreter, NULL, value, EMPTY, row, col);
        }
        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_open(void)
{
        buffer *buf = buffer_of_window(w_list);
        int row = get_point(w_list).row;
        int col = get_point(w_list).col;

        if (ret_type(buf, row, col) == EMBED) {
                embed_open(ret_text(buf, row, col));
                embed_load(ret_text(buf, row, col));
        }
        buf->change = TRUE;
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP lembed_save(void)
{
        char cmd[1024];
        char file[256];
        buffer *buf = buffer_of_window(w_list);
        Pixmap bitmap;

        file[0] = '\0';
        if (!ask_for_str("Object file:", file)) return NIL;

        bitmap = draw_snapshot();
        sprintf(cmd, "siag %s", buf->path);
        embed_save(file, cmd, bitmap);
        XFreePixmap(XtDisplay(topLevel), bitmap);
        return NIL;
}

/* start of experimental swallowing code */
/* originally from TkSteal */

#define REPARENT_LOOPS 50

static Window find_window_by_name(Display *display, Window w,
                                char *name, int depth)
{
        Window root, parent, *child, w1 = None;
        int i, d;
	Cardinal n;
        char *found;

        if (XFetchName(display, w, &found)) {
                d = strcmp(found, name);
                XFree(found);
                if (!d) return w;
        }
        if (!depth) return None;
        XQueryTree(display, w, &root, &parent, &child, &n);
        for (i = 0; i < n; i++) {
                w1 = find_window_by_name(display, child[i], name, depth-1);
                if (w1 != None) break;
        }
        XFree(child);
        return w1;
}

static void reparent_window(Display *display, Screen *screen,
                        Window w, Window to)
{
        int i;
	Cardinal n;
        XWMHints *hints;
        Window root, parent, *child;

        XSync(display, False);
        XWithdrawWindow(display, w, XScreenNumberOfScreen(screen));
        XSync(display, False);
        hints = XGetWMHints(display, w);
        hints->flags |= WindowGroupHint;
        hints->window_group = RootWindowOfScreen(screen);
        XSetWMHints(display, w, hints);
        for (i = 0; i < REPARENT_LOOPS; i++) {
                XReparentWindow(display, w, to, 0, 0);
                XQueryTree(display, w, &root, &parent, &child, &n);
                XSync(display, False);
                if (parent == to) {
                        break;
                }
        }
        XMapWindow(display, w);
        XSync(display, False);
}

static void do_swallow(char *name)
{
        int x, y;
        unsigned int width, height, border, depth;
        Window root, victim = None;
	Widget w;

        XSync(XtDisplay(topLevel), FALSE);
        while (victim == None) {
                victim = find_window_by_name(XtDisplay(topLevel),
                        RootWindowOfScreen(XtScreen(topLevel)),
                        name, 3);
        }

        XGetGeometry(XtDisplay(topLevel), victim, &root,
                        &x, &y, &width, &height, &border, &depth);
	w = XtVaCreateManagedWidget("swallow",
		coreWidgetClass, w_list->ui->grid,
		XtNwidth, width, XtNheight, height, (char *)0);
        reparent_window(XtDisplay(w), XtScreen(w), victim, XtWindow(w));
}

static LISP lswallow(void)
{
	if (fork()) {
		execlp("oclock", "oclock", "-name", "barf", (char *)0);
		exit(0);
	} else {
		do_swallow("barf");
	}
	return NIL;
}

static LISP lplugin_register(LISP desc, LISP ext, LISP cmd)
{
	plugin_register(get_c_string(desc),
			get_c_string(ext),
			get_c_string(cmd));
	return NIL;
}

#define PLUGIN_LINK 1
#define PLUGIN_COPY 2

static void insert_plugin(int mode, char *plugin_name)
{
	static char path[1024], name[1024];
	char fn[1024];
	char pn[1024];
	char cmd[1024];
	char fmt[80];
	char *p;
	buffer *buf = w_list->buf;
	int n;
	plugin_t plugin;

	/* ask for file name */
	if (path[0] == '\0') getcwd(path, 1024);
	name[0] = fn[0] = '\0';

	if (plugin_name) {
		char *q = strrchr(plugin_name, '/');
		if (q) strcpy(name, q+1);
		else strcpy(name, plugin_name);
		strcpy(fn, plugin_name);
	} else {
		if (!select_file(path, name, plugin_patterns, fmt)) return;
		sprintf(fn, "%s/%s", path, name);
	}

	plugin_unique_name(name, pn);

        plugin.row = w_list->point_pos.row;
        plugin.col = w_list->point_pos.col;
        plugin.displayed = 0;

	if (mode == PLUGIN_COPY) {
		plugin.name = cstrdup(pn);
		/* copy the file */
		p = plugin_basedir(buf, NULL);
		sprintf(pn, "%s/%s", p, plugin.name);
		sprintf(cmd, "(mkdir %s;cp %s %s)2>/dev/null", p, fn, pn);
		system(cmd);
	} else {
		strcpy(pn, fn);
		plugin.name = cstrdup(pn);
	}

	/* start the plugin */
	plugin.ph = plugin_start(pn);
	if (plugin.ph == -1) return;

	/* prepare the buffer */
	n = buf->nplugin++;
	buf->plugin = (plugin_t *)crealloc(buf->plugin,
		buf->nplugin*sizeof(plugin_t));
	buf->plugin[n] = plugin;
	buf->change = TRUE;
        pr_scr_flag = TRUE;
}

static LISP lplugin_import(LISP pn)
{
	if (NULLP(pn)) insert_plugin(PLUGIN_COPY, NULL);
	else insert_plugin(PLUGIN_COPY, get_c_string(pn));
	return NIL;
}

/* broken because it still takes the name relative to basedir */
static LISP lplugin_link(LISP pn)
{
	if (NULLP(pn)) insert_plugin(PLUGIN_LINK, NULL);
        else insert_plugin(PLUGIN_LINK, get_c_string(pn));
        return NIL;
}

/* return buffer's plug handler index or -1 for error */
static int select_plugin(buffer *b)
{
	char *plugin[20];
	int i;

	if (b->nplugin == 0) return -1;
	for (i = 0; i < 20 && i < b->nplugin; i++)
		plugin[i] = b->plugin[i].name;
	i = select_from_list("Select Plugin:", plugin, i);
	return i;
}

static LISP lplugin_export(void)
{
	int n;
	char fn[1024], pn[1024], cmd[1024], path[1024], fmt[80];
	buffer *buf = w_list->buf;

	/* pick plugin from list */
	n = select_plugin(buf);
	if (n == -1) return NIL;

	/* get description of the handler */
	/* ask for file name */
	getcwd(path, 1024);
	strcpy(fn, buf->plugin[n].name);
	if (!select_file(path, fn, NULL, fmt)) return NIL;

	/* save the file */
	sprintf(pn, "%s/%s", plugin_basedir(buf, NULL), buf->plugin[n].name);
	sprintf(cmd, "cp %s %s/%s", pn, path, fn);
	system(cmd);
	return NIL;
}

static LISP lplugin_delete(void)
{
	int n;
	buffer *buf = w_list->buf;

	/* pick plugin from list */
	n = select_plugin(buf);
	if (n == -1) return NIL;

	/* remove plugin */
	plugin_stop(buf->plugin[n].ph);
	cfree(buf->plugin[n].name);
	buf->nplugin--;
	for (; n < buf->nplugin; n++)
		buf->plugin[n] = buf->plugin[n+1];
	buf->change = pr_scr_flag = TRUE;
	return NIL;
}

static LISP lplugin_move(void)
{
	int n;
	buffer *buf = w_list->buf;

	/* pick plugin from list */
	n = select_plugin(buf);
	if (n == -1) return NIL;

	buf->plugin[n].row = w_list->point_pos.row;
	buf->plugin[n].col = w_list->point_pos.col;
	buf->change = pr_scr_flag = TRUE;
	return NIL;
}

static LISP copy_block(void)
{
	long r1 = w_list->point_pos.row;
	long c1 = w_list->point_pos.col;
	long rows = w_list->blkl.row-w_list->blku.row+1;
	long cols = w_list->blkl.col-w_list->blku.col+1;
	undo_save(w_list->buf, r1, c1, r1+rows-1, c1+cols-1);
        /* NULL is a bogus event */
        XtGetSelectionValue(grid_of_window(w_list), XA_PRIMARY, target_atom,
                requestor_callback, NULL, CurrentTime);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP set_block(void)
{
        if (get_point(w_list).row < get_mark(w_list).row) {
                set_blku_row(w_list, get_point(w_list).row);
                set_blkl_row(w_list, get_mark(w_list).row);
        } else {
                set_blku_row(w_list, get_mark(w_list).row);
                set_blkl_row(w_list, get_point(w_list).row);
        }
        if (get_point(w_list).col < get_mark(w_list).col) {
                set_blku_col(w_list, get_point(w_list).col);
                set_blkl_col(w_list, get_mark(w_list).col);
        } else {
                set_blku_col(w_list, get_mark(w_list).col);
                set_blkl_col(w_list, get_point(w_list).col);
        }

        /* Become selection owner (CurrentTime is not right, really) */
        if (XtOwnSelection(grid_of_window(w_list), XA_PRIMARY,
                CurrentTime, convert_proc,
                lose_ownership_proc, NULL) == False) {
                XtWarning("Siag: failed to become selection owner\n");
                set_blku_row(w_list, -1); set_blku_col(w_list, -1);
                set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        }

        pr_scr_flag = TRUE;
        return NIL;
}

static LISP unset_block(void)
{
        set_blku_row(w_list, -1); set_blku_col(w_list, -1);
        set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        XtDisownSelection(grid_of_window(w_list), XA_PRIMARY, CurrentTime);
        pr_scr_flag = TRUE;
        return NIL;
}

void interp_startup(void)
{
        XtAppContext app_context = XtWidgetToApplicationContext(topLevel);

        XtAppAddActions(app_context, actions, XtNumber(actions));
	init_subr_0("get-geometry", get_geometry);
	init_subr_0("fit-block-width", fit_block_width);
	init_subr_0("fit-block-height", fit_block_height);
	init_subr_0("embed-object", lembed_object);
	init_subr_0("embed-remove", lembed_remove);
	init_subr_0("embed-open", lembed_open);
	init_subr_0("embed-save", lembed_save);
	init_subr_0("copy-block", copy_block);
	init_subr_0("set-block", set_block);
	init_subr_0("unset-block", unset_block);
	init_subr_0("swallow", lswallow);
	init_subr_3("plugin-register", lplugin_register);
	init_subr_1("plugin-import", lplugin_import);
	init_subr_0("plugin-export", lplugin_export);
	init_subr_1("plugin-link", lplugin_link);
	init_subr_0("plugin-delete", lplugin_delete);
	init_subr_0("plugin-move", lplugin_move);
}

/* Postscript font handling. Metrics are taken from X */
char *ps_fontname(int index)
{
	return fonts[index].psfont;
}

int ps_text_width(int index, char *s)
{
	return XTextWidth(font_struct(XtDisplay(topLevel), index), s, strlen(s));
}

int ps_font_descent(int index)
{
	return font_descent(XtDisplay(topLevel), index);
}

int ps_font_height(long font)
{
	return font_height(XtDisplay(topLevel), font);
}

int ps_embed_print(FILE *fp, char *tag, int x_base, int y_base)
{
	return embed_print(fp, tag, x_base, y_base);
}

int ps_font_size(int index)
{
	return font_size[index];
}

/* plugin functions declared in user_interface.h */
int siag_plugin_start(char *fn)
{
	return plugin_start(fn);
}

int siag_plugin_stop(int ph)
{
	return plugin_stop(ph);
}

int siag_plugin_save(int ph, char *fn)
{
	return plugin_save(ph, fn);
}

int siag_plugin_hide(int ph)
{
	return plugin_hide(ph);
}

int siag_plugin_print(int ph, FILE *fp)
{
	return plugin_print(ph, fp);
}

int siag_plugin_size_get(int ph, unsigned long *w, unsigned long *h)
{
	return plugin_size_get(ph, w, h);
}

