/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/* 
 * Hbox.c - Hbox composite widget
 */

#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Xmu/Misc.h>
#include	<X11/Xaw/Command.h>
#include	"HboxP.h"

/****************************************************************
 *
 * Hbox Resources
 *
 ****************************************************************/

/* These are bogus; they are hand-me-downs from Box */

static XtResource resources[] = {
    { XtNhSpace, XtCHSpace, XtRDimension, sizeof(Dimension),
		XtOffsetOf(HboxRec, hbox.h_space),
		XtRImmediate, (XtPointer)4 },
    { XtNvSpace, XtCVSpace, XtRDimension, sizeof(Dimension),
		XtOffsetOf(HboxRec, hbox.v_space),
		XtRImmediate, (XtPointer)4 }
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

#if 0
static void Initialize();
#endif
static void Resize();
static Boolean SetValues();
static XtGeometryResult GeometryManager();
static void ChangeManaged();

HboxClassRec hboxClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "Hbox",
    /* widget_size        */    sizeof(HboxRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* Hbox class fields */
    /* empty		  */	0
  }
};

WidgetClass hboxWidgetClass = (WidgetClass)&hboxClassRec;


/****************************************************************
 *
 * Private Routines
 *
 ****************************************************************/

/*
 * Do a layout, actually assigning positions.
 */

static void DoLayout(HboxWidget sw)
{
	Widget selectall, rownum, colnum, grid, hscroll, vscroll;
	Dimension w1, w2, w3, h1, h2, h3;

	w3 = sw->core.width;
	h3 = sw->core.height;
	w1 = 60;
	w2 = w3-15;
	h1 = 20;
	h2 = h3-15;
	if (h1 < 2) h1 = 2;
	if (h2 < h1+2) h2 = h1+2;
	if (h3 < h2+2) h3 = h2+2;
	if (w1 < 2) w1 = 2;
	if (w2 < w1+2) w2 = w1+2;
	if (w3 < w2+2) w3 = w2+2;

	switch (sw->composite.num_children) {
	case 6:
		hscroll = sw->composite.children[5];
		XtConfigureWidget(hscroll, 0, h2, w2, h3-h2, 0);
	case 5:
		vscroll = sw->composite.children[4];
		XtConfigureWidget(vscroll, w2, 0, w3-w2, h2, 0);
	case 4:
		grid = sw->composite.children[3];
		XtConfigureWidget(grid, w1, h1, w2-w1, h2-h1, 0);
	case 3:
		rownum = sw->composite.children[2];
		XtConfigureWidget(rownum, 0, h1, w1, h2-h1, 0);
	case 2:
		colnum = sw->composite.children[1];
		XtConfigureWidget(colnum, w1, 0, w2-w1, h1, 0);
	case 1:
		selectall = sw->composite.children[0];
		XtConfigureWidget(selectall, 0, 0, w1, h1, 0);
	default:
		;
	}
}

/*
 * Actually layout hbox
 */

static void Resize(Widget w)
{
	DoLayout((HboxWidget)w);
} /* Resize */

/*
 * Geometry Manager
 *
 * 'reply' is unused; we say only yeay or nay, never almost.
 */

static XtGeometryResult GeometryManager(Widget w,
		XtWidgetGeometry request, XtWidgetGeometry reply)
{
	return XtGeometryYes;
}

static void ChangeManaged(Widget w)
{
    DoLayout((HboxWidget)w);
}

#if 0	/* testing compound widget code */
static Widget selectall;

static void Initialize(Widget request, Widget new,
		ArgList args, Cardinal *num_args)
{
	selectall = XtVaCreateManagedWidget("selectall",
		commandWidgetClass, new, (char *)0);
} /* Initialize */

Widget gross_hack(void)
{
	return selectall;
}
#endif

#if 0	/* not used yet */
static void Realize(Widget w, Mask *valueMask, XSetWindowAttributes *attributes)
{
	;
} /* Realize */
#endif

static Boolean SetValues(Widget current, Widget request, Widget new,
		ArgList args, Cardinal *num_args)
{
    return False;
}
