/*
   Egon Animator
   Copyright (C) 1997-1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Paned.h>
#include <X11/xpm.h>

#include "types.h"
#include "../xcommon/Animator.h"
#include "egon.h"
#include "user_interface.h"
#include "../common/common.h"
#include "../common/fonts.h"
#include "../xcommon/icon.h"
#include "../xcommon/embed.h"
#include "../common/cmalloc.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/xcommon.h"
#include "../xcommon/filesel.h"
#include "../xcommon/Hsep.h"

#include "../common/bitmaps/rbm.xbm"
#include "../common/bitmaps/egon_fg.xpm"

#include "../xcommon/DragAndDrop.h"

#ifdef GUILE
#include <guile/gh.h>
#endif

#ifdef TCL
#include <tcl.h>
#endif

#include "../siod/siod.h"

String fallback_resources[] = {
#include "app-defaults.h"
	NULL
};

AppData app_data;

#define XtNplugin "plugin"
#define XtCPlugin "Plugin"
#define XtNplay "play"
#define XtCPlay "Play"

static XtResource resources[] = {
	{
		XtNplugin,
		XtCPlugin,
		XtRBoolean,
		sizeof(Boolean),
		XtOffsetOf(AppData, plugin),
		XtRImmediate,
		(XtPointer)False,
	}, {
		XtNplay,
		XtCPlay,
		XtRBoolean,
		sizeof(Boolean),
		XtOffsetOf(AppData, play),
		XtRImmediate,
		(XtPointer)False,
	}
};

static XrmOptionDescRec options[] = {
	{"-plugin", "*plugin", XrmoptionNoArg, "True"},
	{"-play", "*play", XrmoptionNoArg, "True"}
};

extern int init_parser(int, char **);	/* siodi.c */
extern int init_guile_parser();
extern int init_tcl_parser();
extern void init_interpreters();

static XtAppContext app_context;

Widget topLevel, topbox, form, gridpane,
	text1, label1, label2, label3;

/* The toolbar */
Widget tbOpen, tbSave, tbView, tbPrint, tbHelp;

Widget btnFont, mnuFont, btnSize, mnuSize, btnStyle, mnuStyle, btnColor, mnuColor;
Widget cmdBold, cmdItalic, cmdHLeft, cmdHCenter, cmdHRight;
Widget shortcuts;
Widget edit_shell, stage;

char *siaghome, *siaghelp, *siagdocs, *siag_basedir;
static char *egonrc;

int ok2print = 0;

int siod_interpreter;

extern void print_cells();

#ifndef ABS
#define ABS(a) ((a)>0?(a):-(a))
#endif

static void pr_grid(Widget w, XEvent * event,
		    String * params, Cardinal * num_params)
{
	if (ok2print) {
		draw_buffer(display, find_window_by_widget(w));
		show_cur(w_list);
	}
}

static LISP ltooltip_mode(LISP newmode)
{
	tooltip_mode_set(get_c_long(newmode), label1);
	return NIL;
}

static void siaghelp_action(Widget w, XEvent *event,
	String *params, Cardinal *num_params)
{
	char b[256];

	sprintf(b, "file://localhost%s/egon/docs/%s", siagdocs, params[0]);
	if (!fork()) {
		execlp(siaghelp, "Siaghelp", b, NULL);
		exit(0);
	}
}

static void place_shortcuts(Widget w, XEvent *event,
                String *p, Cardinal *n)
{
        XButtonEvent *bev = (XButtonEvent *)event;
        int x, y;

        x = event->xbutton.x;
        y = event->xbutton.y;
        XtVaSetValues(shortcuts,
                XtNx, bev->x_root-10,
                XtNy, bev->y_root-10,
                (char *)0);
}
static void
execute_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
	char *b = (char *) client_data;

	execute(b);
}

static struct {
	char *label;
	Widget button, menu;
} *menubar;

static int menucount = 0;

static void make_menu(char *label)
{
	char button_name[80];

	if (topbox == None) return;

	sprintf(button_name, "btn%s", label);
	menubar = crealloc(menubar, (menucount+1)*(sizeof *menubar));
	menubar[menucount].label = cstrdup(label);
	menubar[menucount].button = XtVaCreateManagedWidget(button_name,
		menuButtonWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop, NULL);
	label_set(menubar[menucount].button, label);
	if (menucount) {
		XtVaSetValues(menubar[menucount].button,
			XtNfromHoriz, menubar[menucount-1].button, NULL);
	}
	menubar[menucount].menu = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, menubar[menucount].button, NULL);

	menucount++;
}

static void init_menu()
{
	make_menu("File");
	make_menu("Edit");
#if 0	/* not yet implemented */
	make_menu("Block");
	make_menu("Format");
#endif
	make_menu("Plugin");
	make_menu("Window");
	make_menu("Tools");
	make_menu("Help");
}

static Widget find_menu_by_name(char *label)
{
	int i;

	if (!cstrcasecmp("Shortcuts", label))
		return shortcuts;

	for (i = 0; i < menucount; i++) {
		if (!cstrcasecmp(menubar[i].label, label))
			return menubar[i].menu;
	}
	return NULL;
}

static LISP add_menu_entry(LISP menu, LISP label, LISP function)
{
	Widget entry, menuw;

	menuw = find_menu_by_name(get_c_string(menu));
	if (!menuw) {
#if 0
		fprintf(stderr, "No menu! Bailing out.\n");
#endif
		return NIL;
	}

	if (!strcmp(get_c_string(label), "-"))	/* line pane */
		entry = XtCreateManagedWidget("-",
				smeLineObjectClass,
				menuw,
				NULL, 0);
	else {
		entry = XtCreateManagedWidget(get_c_string(function),
				smeBSBObjectClass, menuw,
				NULL, 0);
		XtAddCallback(entry,
			XtNcallback, execute_callback,	
				cstrdup(get_c_string(function)));
		label_set(entry, get_c_string(label));
	}
	return NIL;
}

static struct {
        char *label, *sublabel;
        Widget entry, menu;
} *submenus;

static int submenucount = 0;

static Widget find_submenu_by_name(char *label, char *sublabel)
{
        int i;

        for (i = 0; i < submenucount; i++) {
                if (!cstrcasecmp(submenus[i].label, label) &&
                                !cstrcasecmp(submenus[i].sublabel, sublabel))
                        return submenus[i].menu;
        }
        return None;
}

static Widget find_submenu_by_entry(Widget entry)
{
        int i;

        for (i = 0; i < submenucount; i++) {
                if (entry == submenus[i].entry)
                        return submenus[i].menu;
        }
        return None;
}

static LISP add_submenu(LISP label, LISP sublabel)
{
        Widget menuw;
        static Pixmap rbm = None;

        menuw = find_menu_by_name(get_c_string(label));

        if (!menuw) {
#if 0
                fprintf(stderr, "add_submenu: No menu! Bailing out.\n");
#endif
                return NIL;
        }
        if (rbm == None) {
                rbm = XCreatePixmapFromBitmapData(XtDisplay(menuw),
                        XDefaultRootWindow(XtDisplay(menuw)),
                        rbm_bits, rbm_width, rbm_height, 1, 0, 1);
        }
        submenus = crealloc(submenus, (submenucount+1)*(sizeof *submenus));
        submenus[submenucount].label = cstrdup(get_c_string(label));
        submenus[submenucount].sublabel = cstrdup(get_c_string(sublabel));
        submenus[submenucount].entry =
                XtVaCreateManagedWidget(get_c_string(sublabel),
                        smeBSBObjectClass, menuw,
                        XtNlabel, translate(get_c_string(sublabel)),
                        XtNrightBitmap, rbm,
                        (char *)0);
        submenus[submenucount].menu = XtVaCreatePopupShell("submenu",
                simpleMenuWidgetClass, menuw, (char *)0);
        submenucount++;
        return NIL;
}

static LISP add_submenu_entry(LISP menu, LISP submenu,
                                LISP label, LISP function)
{
        Widget entry, menuw;

#if 0
        if (app_data.grid_only) return NIL;
#endif

        menuw = find_submenu_by_name(get_c_string(menu),
                                get_c_string(submenu));
        if (!menuw) {
#if 0
                fprintf(stderr, "add_submenu_entry: No menu! Bailing out.\n");
#endif
                return NIL;
        }

        if (!strcmp(get_c_string(label), "-")) {        /* line pane */
                entry = XtCreateManagedWidget("-",
                        smeLineObjectClass,
                        menuw,
                        NULL, 0);
        } else {
                entry = XtVaCreateManagedWidget(get_c_string(function),
                        smeBSBObjectClass, menuw,
                        XtNlabel, translate(get_c_string(label)),
                        (char *)NULL);
                XtAddCallback(entry,
                        XtNcallback, execute_callback,
                        cstrdup(get_c_string(function)));
        }
        return NIL;
}

static void menu_motion(Widget w, XEvent *event,
                String *p, Cardinal *n)
{
        int fromright;
        Dimension width;
        XMotionEvent *mev = (XMotionEvent *)event;
        Widget menu, submenu;

        menu = XawSimpleMenuGetActiveEntry(w);
        if (menu == None) return;
        submenu = find_submenu_by_entry(menu);
        if (submenu == None) return;
        XtVaGetValues(w, XtNwidth, &width, (char *)0);
        fromright = width-mev->x;
        if (fromright > 0 && fromright < 10) {
                Position x, y, x_root, y_root;
                XtVaGetValues(menu,
                        XtNx, &x,
                        XtNy, &y,
                        (char *)0);
                XtTranslateCoords(w,
                        x+width-20, y, &x_root, &y_root);
                XtVaSetValues(submenu,
                        XtNx, x_root,
                        XtNy, y_root,
                        (char *)0);
                XtPopup(submenu, XtGrabNonexclusive);
        }
}

static void popdown_submenu(Widget w, XEvent *event,
                String *p, Cardinal *n)
{
        XtPopdown(w);
        XtPopdown(XtParent(w));
}


static XtActionsRec actions[] =
{
	{"pr-grid", pr_grid},
	{"siaghelp", siaghelp_action},
	{"place-shortcuts", place_shortcuts},
	{"menu-motion", menu_motion},
        {"popdown-submenu", popdown_submenu}
};


static Widget tbNew, tbCopy;	/* needed as fromVert and fromHoriz */

static Widget make_toggle(char *name, char *cmd, Widget pw, 
        Widget below, Widget after, char *pm)
{
        Widget w;
        XpmAttributes xa;
        Pixmap pm_return;
        int result;
        XpmColorSymbol symbol;
        Pixel color;
        char fn[1024];

        if (pm[0] == '/') strcpy(fn, pm);
        else sprintf(fn, "%s/common/bitmaps/%s", siaghome, pm);

        XtVaGetValues(pw, XtNbackground, &color, (char *)0);
        xa.closeness = 40000;
        xa.exactColors = False;
        xa.valuemask = XpmCloseness | XpmExactColors;

        if (pw == None) return None;

        w = XtVaCreateManagedWidget(name,
                toggleWidgetClass, pw, (char *)NULL);
        symbol.name = NULL;
        symbol.value = "none";
        symbol.pixel = color;
        xa.colorsymbols = &symbol;
        xa.numsymbols = 1;
        xa.valuemask |= XpmColorSymbols;

        result = XpmReadFileToPixmap(XtDisplay(w),
                XRootWindowOfScreen(XtScreen(w)),
                fn, &pm_return, NULL, &xa);

        if (result != XpmSuccess) {
                fprintf(stderr, "XpmReadFileToPixmap returns %s for %s\n",
                        XpmGetErrorString(result), fn);
                return NULL;
        }

        XtVaSetValues(w,
                XtNfromVert, below,
                XtNtop, XawChainTop,
                XtNleft, XawChainLeft,
                XtNright, XawChainLeft,
                XtNbottom, XawChainTop,
                XtNbitmap, pm_return,
                (char *)0);
        if (after) {
                XtVaSetValues(w,
                        XtNfromHoriz, after, (char *)NULL);
        }
        XtAddCallback(w,
                XtNcallback, execute_callback, (XtPointer)cmd);
        return w;
}

static Widget make_command(char *name, char *cmd, Widget pw, 
        Widget below, Widget after, char *pm)
{
        Widget w;
        XpmAttributes xa;
        Pixmap pm_return;
        int result;
        XpmColorSymbol symbol;
        Pixel color;
        char fn[1024];

        if (pm[0] == '/') strcpy(fn, pm);
        else sprintf(fn, "%s/common/bitmaps/%s", siaghome, pm);

        XtVaGetValues(pw, XtNbackground, &color, (char *)0);
        xa.closeness = 40000;
        xa.exactColors = False;
        xa.valuemask = XpmCloseness | XpmExactColors;
        if (pw == None) return None;

        w = XtVaCreateManagedWidget(name,
                commandWidgetClass, pw, (char *)NULL);
        symbol.name = NULL;
        symbol.value = "none";
        symbol.pixel = color;
        xa.colorsymbols = &symbol;
        xa.numsymbols = 1;
        xa.valuemask |= XpmColorSymbols;

        result = XpmReadFileToPixmap(XtDisplay(w),
                XRootWindowOfScreen(XtScreen(w)),
                fn, &pm_return, NULL, &xa);

        if (result != XpmSuccess) {
                fprintf(stderr, "XpmReadFileToPixmap returns %s for %s\n",
                        XpmGetErrorString(result), fn);
                return NULL;
        }

        XtVaSetValues(w,
                XtNfromVert, below,
                XtNtop, XawChainTop,
                XtNleft, XawChainLeft,
                XtNright, XawChainLeft,
                XtNbottom, XawChainTop,
                XtNbitmap, pm_return,
                (char *)0);

        if (after) {
                XtVaSetValues(w,
                        XtNfromHoriz, after, (char *)NULL);
        }
        XtAddCallback(w,
                XtNcallback, execute_callback, (XtPointer)cmd);
        return w;
}


#define BELOW_WIDGET1 hsep1
#define BELOW_WIDGET2 hsep2
static Widget hsep1, hsep2, hsep3;

/* The toolbar */
static void init_toolbar()
{
	Widget tbOpen, tbSave, tbView, tbPrint,
		tbStop, tbPrev, tbPlay, tbNext, tbHelp;

        hsep1 = XtVaCreateManagedWidget("hsep1",
                hsepWidgetClass, topbox,
                XtNfromVert, menubar[0].button,
                XtNtop, XawChainTop,
                XtNleft, XawChainLeft,
                XtNright, XawChainRight,
                XtNbottom, XawChainTop,
                XtNwidth, 600,
                (char *)0);

	tbNew = make_command("tbNew", "(new-egon)", topbox,
		BELOW_WIDGET1, NULL, "new.xpm");

        hsep2 = XtVaCreateManagedWidget("hsep2",
                hsepWidgetClass, topbox,
                XtNfromVert, tbNew,
                XtNtop, XawChainTop,
                XtNleft, XawChainLeft,
                XtNright, XawChainRight,
                XtNbottom, XawChainTop,
                XtNwidth, 600,
                (char *)0);

	tbOpen = make_command("tbOpen", "(load-buffer)", topbox,
		BELOW_WIDGET1, tbNew, "fld_open.xpm");
	tbSave = make_command("tbSave", "(save-buffer-as)", topbox,
		BELOW_WIDGET1, tbOpen, "floppy3.xpm");
	tbView = make_command("tbView", "(preview)", topbox,
		BELOW_WIDGET1, tbSave, "preview.xpm");
	tbPrint = make_command("tbPrint", "(print)", topbox,
		BELOW_WIDGET1, tbView, "printer.xpm");
	tbStop = make_command("tbStop", "(ani-ctl ANI_STOP 0)", topbox,
		BELOW_WIDGET1, tbPrint, "stop.xpm");
	tbPrev = make_command("tbPrev", "(ani-ctl ANI_PREVIOUS 0)", topbox,
		BELOW_WIDGET1, tbStop, "previous.xpm");
	tbPlay = make_command("tbPlay", "(ani-ctl ANI_CONTINUE 0)", topbox,
		BELOW_WIDGET1, tbPrev, "play.xpm");
	tbNext = make_command("tbNext", "(ani-ctl ANI_NEXT 0)", topbox,
		BELOW_WIDGET1, tbPlay, "next.xpm");
	tbHelp = make_command("tbHelp", "(help-contents)", topbox,
		BELOW_WIDGET1, tbNext, "info.xpm");
	tbCopy = make_command("tbCopy", "(help-copyright)", topbox,
		BELOW_WIDGET1, tbHelp, "copyright.xpm");
}

static void init_toggle()
{
	cmdBold = make_toggle("cmdBold", "(toggle-fontflag BOLD)", topbox,
		BELOW_WIDGET2, btnColor, "bold.xpm");
	cmdItalic = make_toggle("cmdItalic", "(toggle-fontflag ITALIC)", topbox,
		BELOW_WIDGET2, cmdBold, "italic.xpm");
}

void font_menu(Widget w, char *label, char *cmd)
{
	Widget entry;

	if (w == None) return;

	entry = XtCreateManagedWidget(cmd,
			smeBSBObjectClass, w,
			NULL, 0);
	XtAddCallback(entry,
		XtNcallback, execute_callback, cmd);
	label_set(entry, label);
}

void setup_buttons()
{
	if (topbox == None) return;

	btnFont = XtVaCreateManagedWidget("btnFont",
		menuButtonWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNfromVert, BELOW_WIDGET2,
		XtNwidth, 160,
		(char *)0);
	label_set(btnFont, "Font");

	mnuFont = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnFont, NULL);

	font_menu(mnuFont, "Courier",
		"(change-font COURIER FONT_MASK)");
	font_menu(mnuFont, "Helvetica",
		"(change-font HELVETICA FONT_MASK)");
	font_menu(mnuFont, "New Century Schoolbook",
		"(change-font NEW_CENTURY FONT_MASK)");
	font_menu(mnuFont, "Times",
		"(change-font TIMES FONT_MASK)");

	btnSize = XtVaCreateManagedWidget("btnSize",
		menuButtonWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNfromVert, BELOW_WIDGET2,
		XtNfromHoriz, btnFont,
		XtNwidth, 40,
		(char *)0);
	label_set(btnSize, "Size");

	mnuSize = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnSize, NULL);

	font_menu(mnuSize, "8",
		"(change-font SIZE_8 SIZE_MASK)");
	font_menu(mnuSize, "10",
		"(change-font SIZE_10 SIZE_MASK)");
	font_menu(mnuSize, "12",
		"(change-font SIZE_12 SIZE_MASK)");
	font_menu(mnuSize, "14",
		"(change-font SIZE_14 SIZE_MASK)");
	font_menu(mnuSize, "18",
		"(change-font SIZE_18 SIZE_MASK)");
	font_menu(mnuSize, "20",
		"(change-font SIZE_20 SIZE_MASK)");
	font_menu(mnuSize, "24",
		"(change-font SIZE_24 SIZE_MASK)");
	font_menu(mnuSize, "30",
		"(change-font SIZE_30 SIZE_MASK)");

	btnStyle = XtVaCreateManagedWidget("btnStyle",
		menuButtonWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNfromVert, BELOW_WIDGET2,
		XtNfromHoriz, btnSize,
		XtNwidth, 100,
		(char *)0);
	label_set(btnStyle, "Style");

	mnuStyle = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnStyle, NULL);

	font_menu(mnuStyle, "Line", "(set-type ANI_LINE)");
	font_menu(mnuStyle, "Rectangle", "(set-type ANI_RECTANGLE)");
	font_menu(mnuStyle, "Arc", "(set-type ANI_ARC)");
	font_menu(mnuStyle, "Ellipse", "(set-type ANI_ELLIPSE)");
	font_menu(mnuStyle, "Pixmap", "(set-type ANI_PIXMAP)");
	font_menu(mnuStyle, "String", "(set-type ANI_STRING)");
	font_menu(mnuStyle, "Point", "(set-type ANI_POINT)");
	font_menu(mnuStyle, "Filled Rectangle", "(set-type ANI_FILLRECT)");
	font_menu(mnuStyle, "Filled Arc", "(set-type ANI_FILLARC)");
	font_menu(mnuStyle, "Filled Ellipse", "(set-type ANI_FILLELLIPSE)");

	btnColor = XtVaCreateManagedWidget("btnColor",
		menuButtonWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainLeft,
		XtNbottom, XawChainTop,
		XtNfromVert, BELOW_WIDGET2,
		XtNfromHoriz, btnStyle,
		XtNwidth, 80,
		(char *)0);
	label_set(btnColor, "Color");

	mnuColor = XtVaCreatePopupShell("menu",
		simpleMenuWidgetClass, btnColor, NULL);

	font_menu(mnuColor, "Black",
		"(change-font COLOR_BLACK COLOR_MASK)");
	font_menu(mnuColor, "Red",
		"(change-font COLOR_RED COLOR_MASK)");
	font_menu(mnuColor, "Green",
		"(change-font COLOR_GREEN COLOR_MASK)");
	font_menu(mnuColor, "Blue",
		"(change-font COLOR_BLUE COLOR_MASK)");
	font_menu(mnuColor, "Yellow",
		"(change-font COLOR_YELLOW COLOR_MASK)");
	font_menu(mnuColor, "Magenta",
		"(change-font COLOR_MAGENTA COLOR_MASK)");
	font_menu(mnuColor, "Cyan",
		"(change-font COLOR_CYAN COLOR_MASK)");
	font_menu(mnuColor, "White",
		"(change-font COLOR_WHITE COLOR_MASK)");
}

static LISP popup_editor(void)
{
	/* for some incomprehensable reason, the widgets will
	   allow themselves to be resized here, and only here */
	XtVaSetValues(label1, XtNwidth, 600, (char *)0);
	XtVaSetValues(label2, XtNwidth, 496, (char *)0);
	XtVaSetValues(label3, XtNwidth, 100, (char *)0);
	XtVaSetValues(btnFont, XtNwidth, 160, (char *)0);
	XtVaSetValues(btnSize, XtNwidth, 40, (char *)0);
	XtVaSetValues(btnStyle, XtNwidth, 100, (char *)0);
	XtVaSetValues(btnColor, XtNwidth, 80, (char *)0);
	XtPopup(edit_shell, XtGrabNone);
	return NIL;
}

static LISP popdown_editor(void)
{
	XtPopdown(edit_shell);
	return NIL;
}

static void editor_init(void)
{
	edit_shell = XtVaCreatePopupShell("edit_shell",
		topLevelShellWidgetClass, topLevel,
		XtNtitle, translate("Egon Editor"),
		(char *)0);
	topbox = XtCreateManagedWidget("topbox",
		formWidgetClass, edit_shell, NULL, 0);

}

void drop_handler(Widget w, XtPointer data,
		XEvent *event, Boolean *b)
{
	unsigned char *Data, *filename;
	unsigned long DataSize;
	int DataType = DndDataType(event);

	if (DataType == DndNotDnd) return;
	DndGetData(&Data, &DataSize);
	switch (DataType) {
	case DndFile:
		filename = Data;
		if (!fork()) {
			execlp("egon", "Egon", filename, NULL);
			exit(1);
		}
	default:
		;
	}
}

#ifdef TCL
int Tcl_AppInit(Tcl_Interp *interp)
{
	init_tcl_parser(interp);
	mainloop();
	return TCL_OK;
}
#endif

void realmain(int argc, char **argv)
{
	char b[256], *home, *p;
	struct stat statbuf;
	/* vars from oldmain */
	buffer *buf = NULL;
	char path[1024];
	int i;
        unsigned long highlight_color, unhighlight_color;

	if ((siaghome = getenv("SIAGHOME")) == NULL) {
		char env[256];
		sprintf(env, "SIAGHOME=%s", SIAGHOME);
		putenv(env);
		siaghome = SIAGHOME;
	}
	if ((siaghelp = getenv("SIAGHELP")) == NULL) {
		char env[256];
		sprintf(env, "SIAGHELP=%s", SIAGHELP);
		putenv(env);
		siaghelp = SIAGHELP;
	}
	if ((siagdocs = getenv("SIAGDOCS")) == NULL) {
		char env[256];
		sprintf(env, "SIAGDOCS=%s", SIAGDOCS);
		putenv(env);
		siagdocs = SIAGDOCS;
	}
        if ((p = getenv("SIAGLANG"))) {
                sprintf(b, "%s/common/dictionary.%s", siaghome, p);
                load_dictionary(b);
        }

	if ((home = getenv("HOME")) == NULL)
		home = "";
	sprintf(path, "%s/.siag", home);
	siag_basedir = cstrdup(path);
	mkdir(siag_basedir, 0700);
	sprintf(b, "%s/%ld", siag_basedir, (long)getpid());
	mkdir(b, 0700);
	sprintf(b, "%s/egon.scm", siag_basedir);
	egonrc = cstrdup(b);

	XtSetLanguageProc(NULL, (XtLanguageProc) NULL, NULL);

	topLevel = XtVaAppInitialize(
		    &app_context,	/* application context */
		    "Egon",		/* application class */
		    options,		/* command line options list */
		    XtNumber(options),
		    &argc, argv,	/* command line args */
		    fallback_resources,	/* for missing app-defaults file */
		    NULL);		/* terminate varargs list */

        XtGetApplicationResources(topLevel, &app_data, resources,
                        XtNumber(resources), NULL, 0);

	XtAppAddActions(app_context, actions, XtNumber(actions));

	shortcuts = XtVaCreatePopupShell("shortcuts",
                simpleMenuWidgetClass, topLevel, (char *)0);
        XtVaCreateManagedWidget("-",
                smeLineObjectClass, shortcuts, (char *)0);

	stage = XtVaCreateManagedWidget("stage",
		animatorWidgetClass, topLevel,
		XtNanimatorCast, NULL,
		XtNanimatorMode, ANI_STOP,
		XtNanimatorNow, 0,
		(char *)0);
	editor_init();
        highlight_color = WhitePixel(XtDisplay(topLevel),
                                DefaultScreen(XtDisplay(topLevel)));

	XtVaGetValues(edit_shell,   /* or any widget with grey bg */
	        XtNbackground, &unhighlight_color,
	        (char *)0);
	tooltip_init(edit_shell, highlight_color, unhighlight_color);

	init_menu();
	init_toolbar();
	setup_buttons();
	init_toggle();

	hsep3 = XtVaCreateManagedWidget("hsep3",
		hsepWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainRight,
		XtNbottom, XawChainTop,
		XtNfromVert, btnFont,
		(char *)0);

	label1 = XtVaCreateManagedWidget("label1",
		labelWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainRight,
		XtNbottom, XawChainTop,
		XtNwidth, 600,
		XtNfromVert, hsep3, (char *)0);

	gridpane = XtVaCreateManagedWidget("gridpane",
		panedWidgetClass, topbox,
		XtNtop, XawChainTop,
		XtNleft, XawChainLeft,
		XtNright, XawChainRight,
		XtNbottom, XawChainBottom,
		XtNfromVert, label1,
		XtNallowResize, True,
		XtNmin, 40,
		XtNwidth, 600,
		XtNheight, 200, (char *)0);

	label2 = XtVaCreateManagedWidget("label2",
		labelWidgetClass, topbox,
		XtNtop, XawChainBottom,
		XtNleft, XawChainLeft,
		XtNright, XawChainRight,
		XtNbottom, XawChainBottom,
		XtNwidth, 496,
		XtNfromVert, gridpane, (char *)0);

	label3 = XtVaCreateManagedWidget("label3",
		labelWidgetClass, topbox,
		XtNtop, XawChainBottom,
		XtNleft, XawChainRight,
		XtNright, XawChainRight,
		XtNbottom, XawChainBottom,
		XtNfromVert, gridpane,
		XtNfromHoriz, label2,
		XtNwidth, 100,
		(char *)0);

/* Start of oldmain() */
	init_interpreters();
	siod_interpreter = init_parser(argc, argv);
#ifdef GUILE
	init_guile_parser();
#endif
	interp_startup();
	waitforchild(0);
	buf = new_buffer("noname.egon", "noname.egon");
	buf->change = FALSE;

	init_windows(buf, argc, argv);

	embed_init(topLevel);

	ok2print = 1;

	init_subr_0("popup-editor", popup_editor);
	init_subr_0("popdown-editor", popdown_editor);
	init_subr_3("add-menu-entry", add_menu_entry);
	init_subr_2("add-submenu", add_submenu);
        init_subr_4("add-submenu-entry", add_submenu_entry);
	init_subr_1("tooltip-mode", ltooltip_mode);

	init_form(topLevel);

	icon_set(topLevel, egon_fg_xpm);
	DndInitialize(topLevel);
	DndRegisterOtherDrop(drop_handler);

	font_init(topLevel);
	init_position();
	init_cmds();

        highlight_color = WhitePixel(display, DefaultScreen(display));
        XtVaGetValues(label1,   /* or any widget with grey bg */
                XtNbackground, &unhighlight_color,
                NULL);

	sprintf(path, "%s/egon/egon.scm", siaghome);
	if (stat(path, &statbuf)) {
		char *buttons[] = {"OK"};

		fprintf(stderr, "Can't find the runtime library (egon.scm).\n");
		fprintf(stderr, "Expected it in %s\n", path);
		fprintf(stderr, "SIAGHOME is '%s'\n", siaghome);
		fprintf(stderr, "Please read installation instructions.\n");

		alert_box("Can't find egon.scm. Click to exit.",
				buttons, 1);
		exit(EXIT_FAILURE);
	}

	setvar(cintern("SIAGHOME"), strcons(-1, siaghome), NIL);
	setvar(cintern("SIAGHELP"), strcons(-1, siaghelp), NIL);
	setvar(cintern("SIAGDOCS"), strcons(-1, siagdocs), NIL);

	/* load runtime library */
	sprintf(b, "(load \"%s/egon/egon.scm\")", siaghome);
	execute(b);

	/* load user customizations, if any */
	if (!stat(egonrc, &statbuf)) {
		sprintf(b, "(load \"%s\")", egonrc);
		execute(b);
	}

	fileio_init();
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') {
			strcpy(path, argv[i]);
			free_buffer(w_list->buf);
			buf = new_buffer(buffer_name(argv[i]), path);
			loadmatrix(path, buf, guess_file_format(path));
			buf->change = FALSE;
			w_list->buf = buf;
		}
	}
	pr_scr_flag = TRUE;

	/* this works, for reasons beyond my comprehension */
	execute("(print-version)");
	execute("(print-version)");
	activate_window(w_list);
#ifdef TCL
	Tcl_Main(argc, argv, Tcl_AppInit);
#else
	mainloop();
#endif
}

int main(int argc, char **argv)
{
#ifdef GUILE
	gh_enter(argc, argv, realmain);
#else
	realmain(argc, argv);
#endif
	return 0;
}

