/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * input.c
 */

/*X
   Module name: input.c
   X */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "../xcommon/Animator.h"
#include "egon.h"
#include "../common/fonts.h"
#include "../xcommon/dialogs.h"

int ask_for_str_comp(char *prompt, char *buffr, int (*comp) ())
{
	return dialog_input(topLevel, prompt, buffr, comp);
}

/*X
   static int nocomp(char *b)
   This particular completion function doesn't complete at all, it just
   returns TRUE, making TAB equivalent to RET and LFD.
   X */
static int nocomp(char *b)
{
	return TRUE;
}

/*X
   int ask_for_str(char *prompt, char *buffr)
   Calls ask_for_str_comp with nocomp as completion function.
   X */
/* 95-06-29: changed "buffer" to "buffr" to please gcc */
int ask_for_str(char *prompt, char *buffr)
{
	return ask_for_str_comp(prompt, buffr, nocomp);
}

