\name{rational}
\title{Rational Approximation to Real Numbers}
\usage{
rational(x, \dots)
}
\arguments{
  \item{x}{Numeric array to be approximated.}
  \item{...}{Optional additional parameters to be passed to
    rat(x, \dots)}
}
\value{
  Numeric array of the same shape as \code{x} of rational
  approximations.

  If \code{x} contains the results of a calculation for which the
  correct answers rational with ``small'' denominators, this may remove
  roundoff error.

  Similar to \code{round(..)}, except that full accuracy is maintained
  for many exactly rational quantities.
}
\seealso{
  \code{\link{fractions}} and the primitive function \code{\link{rat}}.
}
\examples{
# solve() accuracy check using a small Hilbert Matrix
    x <- matrix(0,5,5); x <- 1/(row(x) + col(x) - 1); rat(x)

    x1 <- solve(solve(x))
#compare:
    x-x1
#with:
    x-rational(x1)
}
\keyword{rational}
% Converted by Sd2Rd version 0.2-a3.
