"read.and.check" <-
function (message = "", what = numeric(), lower, upper, answer.in, 
        default) 
{
        #Read data from the command line and check that it satisfies 
        #certain conditions.  The function will loop until it gets 
        #and answer satisfying the conditions. This entails extensive 
        #checking of the conditions to  make sure they are consistent 
        #so we don't end up in an infinite loop. 
        have.lower <- !missing(lower)
        have.upper <- !missing(upper)
        have.ans.in <- !missing(answer.in)
        have.default <- !missing(default)
        if (have.lower | have.upper) {
                if (!is.numeric(what)) 
                        stop("Can't have upper or lower limits with non numeric input")
                if (have.lower && !is.numeric(lower)) 
                        stop("lower limit not numeric")
                if (have.upper && !is.numeric(upper)) 
                        stop("upper limit not numeric")
                if ((have.upper & have.lower) && upper < lower) 
                        stop("lower limit greater than upper limit")
        }
        if (have.ans.in) {
                if (mode(answer.in) != mode(what)) 
                        stop("inconsistent values of what and answer.in")
                if (have.lower) 
                        answer.in <- answer.in[answer.in >= lower]
                if (have.upper) 
                        answer.in <- answer.in[answer.in <= upper]
                if (length(answer.in) == 0) 
                        stop("No possible response matches conditions")
        }
        if (have.default) {
                if (mode(default) != mode(what)) 
                        stop("inconsistent values of what and default")
                if (have.lower && default < lower) 
                        stop("default value below lower limit")
                if (have.upper && default > upper) 
                        stop("default value above upper limit")
                if (have.ans.in && !any(answer.in == default)) 
                        stop("default value does not satisfy conditions")
        }
        err <- T
        while (err) {
                if (nchar(message) > 0) {
                        cat("\n", message, "\n", sep = "")
                        if (have.default) 
                                cat("(Default = ", default, ")\n", 
                                 sep = "")
                }
                else cat("\n")
                repeat {
                        cat("1:")
                        ans <- readline()
                        if (length(ans) == 1 && nchar(ans) > 
                                0) 
                                break
                        else if (have.default) {
                                ans <- default
                                break
                        }
                }
                if (is.numeric(what)) {
                        err1 <- T
                        ans <- as.numeric(ans)
                        message <- "You must enter a number"
                        if (is.na(ans)) 
                                NULL
                        else if ((have.lower & have.upper) && 
                                (ans < lower | ans > upper)) 
                                message <- paste(message, "between", 
                                 lower, "and", upper)
                        else if (have.lower && ans < lower) 
                                message <- paste(message, ">=", 
                                 lower)
                        else if (have.upper && ans > upper) 
                                message <- paste(message, "<=", 
                                 upper)
                        else err1 <- F
                }
                else err1 <- F
                if (have.ans.in) {
                        if (!is.na(ans) && !any(ans == answer.in)) {
                                message <- paste("You must enter one of the following:", 
                                 paste(answer.in, collapse = ","))
                                err2 <- T
                        }
                        else err2 <- F
                }
                else err2 <- F
                err <- err1 | err2
        }
        return(ans)
}
