"raftery.diag" <-
function (data, q = 0.025, r = 0.005, s = 0.95, converge.eps = 0.001) 
{
        Nparms <- dim(data)[2]
        Niters <- dim(data)[1]
        Nchains <- dim(data)[3]
        resmatrix <- array(dim = c(Nparms, 4, Nchains))
        # 
        dimnames(resmatrix) <- list(dimnames(data)[[2]], c("M", 
                "N", "Nmin", "I"), dimnames(data)[[3]])
        phi <- qnorm(0.5 * (1 + s))
        nmin <- as.integer(ceiling((q * (1 - q) * phi^2)/r^2))
        if (nmin > Niters) 
                resmatrix <- c("Error", nmin)
        else for (k in 1:Nchains) {
                for (i in 1:Nparms) {
                        #          First need to find the thinning parameter kthin 
                        # 
                        quant <- quantile(data[, i, k, drop = T], 
                                probs = q)
                        dichot <- data[, i, k, drop = T] <= quant
                        kwork <- 0
                        bic <- 1
                        while (bic >= 0) {
                                kwork <- kwork + 1
                                testres <- dichot[seq(1, nrow(data), 
                                 by = kwork)]
                                newdim <- length(testres)
                                testtran <- table(testres[1:(newdim - 
                                 2)], testres[2:(newdim - 1)], 
                                 testres[3:newdim])
                                g2 <- 0
                                for (i1 in 1:2) {
                                 for (i2 in 1:2) {
                                  for (i3 in 1:2) {
                                   if (testtran[i1, i2, i3] != 
                                    0) {
                                    fitted <- (sum(testtran[i1, 
                                     i2, 1:2]) * sum(testtran[1:2, 
                                     i2, i3]))/(sum(testtran[1:2, 
                                     i2, 1:2]))
                                    g2 <- g2 + testtran[i1, i2, 
                                     i3] * log(testtran[i1, i2, 
                                     i3]/fitted) * 2
                                   }
                                  }
                                 }
                                }
                                bic <- g2 - log(newdim - 2) * 
                                 2
                        }
                        kthin <- as.integer(kwork * thin(data))
                        #
                        # then need to find length of burn-in and No of iterations for required precision 
                        # 
                        finaltran <- table(testres[1:(newdim - 
                                1)], testres[2:newdim])
                        alpha <- finaltran[1, 2]/(finaltran[1, 
                                1] + finaltran[1, 2])
                        beta <- finaltran[2, 1]/(finaltran[2, 
                                1] + finaltran[2, 2])
                        tempburn <- log((converge.eps* (alpha + beta))/max(alpha, 
                                beta))/(log(abs(1 - alpha - beta)))
                        nburn <- as.integer(ceiling(tempburn) * 
                                kthin)
                        tempprec <- ((2 - alpha - beta) * alpha * 
                                beta * phi^2)/(((alpha + beta)^3) * 
                                r^2)
                        nkeep <- as.integer(ceiling(tempprec) * 
                                kthin)
                        iratio <- (nburn + nkeep)/nmin
                        resmatrix[i, 1, k] <- nburn
                        resmatrix[i, 2, k] <- nkeep + nburn
                        resmatrix[i, 3, k] <- nmin
                        resmatrix[i, 4, k] <- signif(iratio, 
                                digits = 3)
                }
        }
        y <- list(tspar = tspar(data), params = c(r = r, s = s, 
                q = q), Niters = Niters, resmatrix = resmatrix)
        class(y) <- "raftery.diag"
        return(y)
}
