"print.heidel.diag" <-
function (x, digits = 3, ...) 
{
        HW.title <- matrix(c("Stationarity", "test", "# of iters.", 
                "to keep", "# of iters.", "to discard", "C-vonM", 
                "stat.", "Halfwidth", "test", "Mean", "", "Halfwidth", 
                ""), nrow = 2)
        for (i in 1:length(x)) {
                y <- matrix("", nrow = nrow(x[[i]]), ncol = 7)
                for (j in 1:ncol(y)) {
                        y[, j] <- format(x[[i]][, j], digits = digits, 
                                ...)
                }
                y[, c(1, 5)] <- ifelse(x[[i]][, c(1, 5)], "passed", 
                        "failed")
                cat("\n", names(x)[i], "\n\n", sep = "")
                y <- rbind(HW.title, y)
                dimnames(y) <- list(c("", "", dimnames(x[[i]])[[1]]), 
                        rep("", 7))
                print.default(y[, 1:4], quote = F, ...)
                print.default(y[, 5:7], quote = F, ...)
        }
        invisible(x)
}
