"print.coda.options" <-
function (data = F, stats = F, plots = F, diags = F) 
{
        #Display working data and coda options in pretty format 
        ## 
        # First define some formatting functions 
        # 
        doline <- function(x, title, type) {
                if (is.null(Version()$language)) 
                        doline <- get("doline", frame = sys.parent())
                if (length(x) > 1) {
                        doline(x[1], title)
                        for (i in 2:length(x)) doline(x[i], "")
                        return()
                }
                if (is.logical(x)) 
                        x <- ifelse(x, "Yes", "No")
                if (!missing(type) && mode(x) != type) 
                        x <- "N/A"
                len.title <- nchar(title)
                endchar <- ifelse(x == "", " ", ":")
                cat("| ", title, paste(rep(" ", 20 - nchar(title)), 
                        collapse = ""), sep = "")
                widthleft <- options("width")$width - 25 - nchar(x)
                if (widthleft > 0) 
                        cat("| ", x, paste(rep(" ", widthleft), 
                                collapse = ""), "|\n", sep = "")
                else cat("| ", x, "\n", sep = "")
        }
        dotitle <- function(title) {
                if (is.null(Version()$language)) 
                        doline <- get("doline", frame = sys.parent())
                doline("", title)
                doline("", paste(rep("-", nchar(title)), collapse = ""))
        }
        domaintitle <- function(title) {
                cat("| ", title, paste(rep(" ", options()$width - 
                        nchar(title) - 3), collapse = ""), "|\n", 
                        sep = "")
        }
        doblank <- function() {
                if (is.null(Version()$language)) 
                        doline <- get("doline", frame = sys.parent())
                doline("", "")
        }
        dosepline <- function() {
                cat("+", paste(rep("-", options("width")$width - 
                        2), collapse = ""), "+\n", sep = "")
        }
        strbrk <- function(x) {
                WIDTH <- options("width")$width - 26
                N <- length(x)
                x[-N] <- paste(x[-N], ", ", sep = "")
                tmp <- cumsum(nchar(x))
                lr <- vector("list", 1)
                lr[[1]] <- (1:N)[tmp <= WIDTH]
                rr <- x[lr[[1]]]
                i <- 1
                while (rr[length(rr)] != x[N]) {
                        tmp <- tmp + (WIDTH - sum(nchar(rr)))
                        lr <- c(lr, c(1:N)[tmp > (WIDTH * i) & 
                                tmp <= (WIDTH * (i + 1))])
                        rr <- x[lr[[i + 1]]]
                        i <- i + 1
                }
                y <- character(length(lr))
                for (i in 1:length(y)) y[[i]] <- paste(x[lr[[i]]], 
                        collapse = "")
                return(y)
        }
        # 
        # Now we can get on with it 
        # 
        cat("\nCurrent option settings:")
        cat("\n=======================\n\n")
        dosepline()
        if (data) {
                domaintitle("WORKING DATA")
                dosepline()
                doblank()
                ans <- strbrk(colnames(work.dat))
                doline(ans, "Variables selected")
                ans <- strbrk(dimnames(work.dat)[[3]])
                doline(ans, "Chains selected")
                wtspar <- tspar(work.dat)
                doline(wtspar[1], "Iterations - start")
                doline(wtspar[2], "             end")
                doline(wtspar[3], "Thinning interval")
                doblank()
                dosepline()
        }
        if (stats) {
                domaintitle("SUMMARY STATISTICS OPTIONS")
                dosepline()
                doblank()
                doline(coda.options("digits"), "Significant digits")
                doline(coda.options("combine.stats"), "Combine chains")
                doline(coda.options("batch.size"), "Batch size")
                ans <- strbrk(paste(coda.options("quantiles") * 
                        100, "%", sep = ""))
                doline(ans, "Quantiles")
                doblank()
                dosepline()
        }
        if (plots) {
                domaintitle("PLOTTING OPTIONS")
                dosepline()
                doblank()
                doline(coda.options("trace"), "Trace")
                doline(coda.options("lowess"), "Smooth lines")
                doline(coda.options("densplot"), "Density")
                width.cut <- options("width")[[1]] - 26
                if (is.null(options()$language)) {
                        func <- deparse(coda.options("bandwidth"))
                        for (i in 1:length(func)) {
                                func.i <- substring(func[i], 
                                 1:nchar(func[i]), 1:nchar(func[i]))
                                if (any(func.i == "\t")) {
                                 func.i[func.i == "\t"] <- "     "
                                 func[i] <- paste(func.i, collapse = "")
                                }
                        }
                }
                else func <- deparse(coda.options("bandwidth"), 
                        width.cutoff = width.cut)
                func.print <- vector("list", length(func))
                for (i in 1:length(func)) {
                        if (nchar(func[i]) <= width.cut) 
                                func.print[[i]] <- func[i]
                        else {
                                first <- seq(from = 1, to = nchar(func[i]), 
                                 by = width.cut)
                                last <- seq(from = width.cut, 
                                 to = nchar(func[i]), by = width.cut)
                                if (max(last) < nchar(func[i])) 
                                 last <- c(last, nchar(func[i]))
                                func.print[[i]] <- substring(func[i], 
                                 first = first, last = last)
                        }
                }
                doline(unlist(func.print), "Bandwidth")
                doline(coda.options("sepplot"), "Separate plot/chain")
                doline(coda.options("onepage"), "Separate page/var.")
                psopt <- switch(coda.options("ps.plot"), "Full page; Portrait", 
                        "Full page; Landscape", "Half page; Portrait")
                doline(psopt, "PostScript options")
                doblank()
                dosepline()
        }
        if (diags) {
                domaintitle("DIAGNOSTICS OPTIONS")
                dosepline()
                doblank()
                dotitle("Geweke")
                doline(coda.options("frac1"), "Window 1 fraction")
                doline(coda.options("frac2"), "Window 2 fraction")
                doline(coda.options("geweke.bin"), "Bin width", 
                        type = "numeric")
                doline(coda.options("geweke.max"), "Max number of bins", 
                        type = "numeric")
                doblank()
                dotitle("Gelman & Rubin")
                ans <- coda.options("gr.bin")
                doline(ans, "Bin width", type = "numeric")
                doline(coda.options("gr.max"), "Max number of bins", 
                        type = "numeric")
                doblank()
                dotitle("Raftery & Lewis")
                doline(coda.options("q"), "Quantile (q)")
                doline(coda.options("r"), "Precision (+/- r)")
                doline(coda.options("s"), "Probability (s)")
                doblank()
                dotitle("Cross-correlations")
                doline(coda.options("combine.corr"), "Combine chains")
                doblank()
                dosepline()
        }
        invisible()
}
