"codamenu.diags.gelman" <-
function () 
{
        next.menu <- this.menu <- "codamenu.diags.gelman"
        if (nchain(work.dat) == 1) {
                cat("\nError: Gelman and Rubin convergence diagnostic requires more than one chain.\n\n")
                return("codamenu.diags")
        }
        z <- window(work.dat, start = niter(work.dat)/2)
        tol <- 1e-08
        if (any(apply(z[, , 1] - z[, , -1], c(2, 3), var) < tol)) {
                cat("\nError: 2nd half of two chains are identical for at least one variable\nGelman and Rubin convergence diagnostic requires 2 or more different chains.\n\n")
                next.menu <- "codamenu.diags"
        }
        else if (niter(work.dat) <= 50) {
                cat("\nError: you must have more than 50 iterations in the working data\n")
                next.menu <- "codamenu.diags"
        }
        else {
                codamenu.output.header("GELMAN AND RUBIN DIAGNOSTIC")
                print(gelman.diag(work.dat, transform = T), digits = coda.options("digits"))
        }
        while (next.menu == "codamenu.diags.gelman") {
                cat("\nGelman & Rubin Menu\n")
                cat("*************************\n")
                choices <- c("Trace Plots", "Shrink Factor Plots", 
                        "Change bin size for shrink plot", "Return to Diagnostics Menu")
                action.list <- c("TracePlot", "ShrinkPlot", "ChangeBin", 
                        "Return")
                pick <- menu(choices)
                if (pick == 0) 
                        next.menu <- "quit"
                else switch(action.list[pick], TracePlot = {
                        gelman.trace.plot(work.dat, auto.layout = !coda.options("user.layout"))
                        mpause3()
                }, ShrinkPlot = {
                        if (is.numeric(coda.options("gr.bin")) & 
                                niter(work.dat) <= 0 + coda.options("gr.bin")) {
                                cat("\n******* Error: *******")
                                cat("\nNot enough iterations available for plot\n")
                        }
                        else {
                                if (is.numeric(coda.options("gr.max")) & 
                                 niter(work.dat) < 50 + coda.options("gr.max")) {
                                 cat("\n******* Error: *******")
                                 cat("\nNot enough iterations available for plot\n")
                                }
                                else {
                                 max.bins <- coda.options("gr.max")
                                 bin.width <- coda.options("gr.bin")
                                 auto.layout <- !coda.options("user.layout")
                                 if (max.bins != 0 & bin.width != 
                                  0) 
                                  gelman.shrink.plot(work.dat, 
                                   max.bins = max.bins, bin.width = bin.width, 
                                   auto.layout = auto.layout)
                                 else if (max.bins != 0) 
                                  gelman.shrink.plot(work.dat, 
                                   max.bins = max.bins, auto.layout = auto.layout)
                                 else if (bin.width != 0) 
                                  gelman.shrink.plot(work.dat, 
                                   bin.width = bin.width, auto.layout = auto.layout)
                                 else gelman.shrink.plot(work.dat, 
                                  auto.layout = auto.layout)
                                 mpause3()
                                }
                        }
                }, ChangeBin = {
                        next.menu <- codamenu.options.gelman(this.menu)
                }, Return = {
                        next.menu <- "codamenu.diags"
                })
        }
        return(next.menu)
}
