"codamenu.anal" <-
function () 
{
        # 
        # outanal -- Output analysis menu for CODA system 
        # 
        # Author: Kate Cowles 
        # 
        next.menu <- "codamenu.anal"
        mtitle <- "CODA Output Analysis Menu"
        cat("", mtitle, paste(rep("*", nchar(mtitle)), collapse = ""), 
                sep = "\n")
        choices <- c("Plots", "Statistics", "List/Change Options", 
                "Return to Main Menu")
        next.menu.list <- c("plots", "summary", "codamenu.options", 
                "codamenu.main")
        pick <- menu(choices)
        if (pick == 0) 
                next.menu <- "quit"
        else if (next.menu.list[pick] == "summary") 
                print(summary(work.dat, quantiles = coda.options("quantiles"), 
                        combine.chains = coda.options("combine.stats")), 
                        digits = coda.options("digits"))
        else if (next.menu.list[pick] == "plots") {
                plot(work.dat, trace = coda.options("trace"), 
                        density = coda.options("densplot"), smooth = coda.options("lowess"), 
                        auto.layout = !coda.options("user.layout"), 
                        bwf = coda.options("bandwidth"), combine.chains = !coda.options("sepplot"), 
                        one.page = coda.options("onepage"))
                mpause3()
        }
        else next.menu <- next.menu.list[pick]
        return(next.menu)
}
