"autocorr.plot" <-
function (x, lag.max, auto.layout = T) 
{
        oldpar <- NULL
        if (auto.layout) 
                oldpar <- par(mfrow = set.mfrow(Nchains = nchain(x), 
                        Nparms = nvar(x)))
        oldpar <- c(oldpar, set.scale())
        on.exit(par(oldpar))
        title.scale <- par("cex") * c(1, 0.85, 0.7)[coda.options("ps.plot")]
        scale <- par("cex") * c(1, 0.8, 0.6)[coda.options("ps.plot")]
        for (i in 1:nchain(x)) {
                xacf <- if (missing(lag.max)) 
                        acf(as.ts.mcmc(x[, , i]), plot = F)
                else acf(as.ts.mcmc(x[, , i]), lag.max = lag.max, 
                        plot = F)
                for (j in 1:nvar(x)) {
                        plot(xacf$lag, xacf$acf[, j], type = "h", 
                                ylab = "Autocorrelation", xlab = "Lag", 
                                cex = scale, ylim = c(-1, 1))
                        title(paste(varnames(x)[j], ":", chanames(x)[i], 
                                sep = ""), cex = title.scale)
                        if (j == nvar(x) && i == nchain(x)) 
                                stop.plot <- FALSE
                        else if (stop.plot <- mpause2()) 
                                break
                }
                par(new = F)
                if (stop.plot) 
                        break
        }
        invisible(x)
}
