"autocorr" <-
function (x, lags = c(1, 5, 10, 50) * thin(x)) 
{
        y <- array(dim = c(nvar(x), length(lags), nchain(x)))
        dimnames(y) <- list(varnames(x), paste("Lag", lags), 
                chanames(x))
        for (i in 1:nchain(x)) {
                acf.out <- acf(as.ts.mcmc(x[, , i]), lag.max = max(lags), 
                        plot = F)$acf
                y[, , i] <- if (is.matrix(acf.out)) 
                        t(acf.out[lags%/%thin(x) + 1, ])
                else acf.out[lags%/%thin(x) + 1]
        }
        y <- drop(y)
        return(y)
}
