"acf" <-
function (x, lag.max, type = "correlation", plot = T) 
{
        legal.types <- c("correlation", "covariance")
        check.type <- pmatch(type, legal.types)
        if (is.na(check.type)) 
                stop("Unknown type")
        else if (check.type == 0) 
                stop("Ambiguous type")
        else type <- legal.types[check.type]
        series <- deparse(substitute(x))
        x.freq <- frequency(as.ts(x))
        attr(x, "tsp") <- NULL
        x <- as.matrix(x)
        n.used <- nrow(x)
        if (missing(lag.max)) 
                lag.max <- floor(10 * log10(n.used))
        lag.max <- min(lag.max, n.used - 1)
        lag <- seq(from = 0, to = lag.max)
        acf <- matrix(nrow = lag.max + 1, ncol = ncol(x))
        x1 <- x2 <- sweep(x, 2, apply(x, 2, mean))
        for (i in 1:nrow(acf)) {
                acf[i, ] <- apply(x1 * x2, 2, sum)/n.used
                x1 <- x1[-1, , drop = F]
                x2 <- x2[-nrow(x2), , drop = F]
        }
        if (type == "correlation") 
                acf <- sweep(acf, 2, acf[1, ], "/")
        if (ncol(acf) == 1) 
                acf <- as.vector(acf)
        return(acf = acf, lag = lag/x.freq, n.used = n.used, 
                type = type, series = series)
}
