% $Id: lmList.Rd,v 1.6 1998/04/06 21:35:17 pinheiro Exp $
\name{lmList}
\title{List of lm Objects with a Common Model}
\usage{
lmList(object, data, groups, level, na.action, pool)
}
\alias{lmList}
\alias{lmList.formula}
\arguments{
  \item{object}{
    Either a linear formula object, with the response on the left of a
    \code{~} operator and the terms, separated by \code{+} operators, on
    the right or a \code{groupedData} object.  The method function
    \code{lmList.groupedData} is documented separately.
  }
  \item{data}{
    a data frame in which to interpret the variables named in
    \code{formula} and \code{groups}.
  }
  \item{groups}{
    an optional one-sided formula specifying the partitioning of the
    data according to which different \code{lm} fits should be
    performed. Defaults to \code{getGroupsFormula(data)}, in which
    case \code{data} must inherit from class \code{groupedData}.
  }
  \item{level}{
    an optional integer specifying the level of grouping to be used when 
    multiple nested levels of grouping are present.
  }
 \item{na.action}{a function that indicates what should happen when the
   data contain \code{NA}s.  The default action (\code{na.fail}) causes
   \code{lmList} to print an error message and terminate if there are any
   incomplete observations.
 }
 \item{pool}{
   an optional logical value that is preserved as an attribute of the
   returned value.  This will be used as the default for \code{pool} in
   calculations of standard deviations or standard errors for summaries.
 }
}
\description{
  \code{Data} is partitioned according to the levels of the grouping
  factor defined in \code{groups}, and individual \code{lm} fits are
  obtained for each \code{data} partition, using the model defined in
  \code{object}.
}

\value{
  a list of \code{lm} objects with as many components as the number of
  groups defined by \code{groups}. Generic functions such as \code{coef},
  \code{fixed.effects}, \code{lme}, \code{pairs}, \code{plot},
  \code{predict}, \code{random.effects}, \code{summary}, and
  \code{update} have methods that can be applied to an \code{lmList}
  object. 
}

\seealso{
\code{\link{lm}}, \code{\link{lme.lmList}}.
}
\examples{
library(lme)
data(Orthodont)
fm1 <- lmList(distance ~ age, Orthodont, groups = ~Subject)
}
\keyword{models}

